/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.core.builder.syntaxtree.utils;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.protoc.core.builder.stub.EnumMessage;
import io.ballerina.protoc.core.builder.stub.Field;
import io.ballerina.protoc.core.builder.stub.Message;
import io.ballerina.protoc.core.builder.syntaxtree.components.Annotation;
import io.ballerina.protoc.core.builder.syntaxtree.components.Expression;
import io.ballerina.protoc.core.builder.syntaxtree.components.Function;
import io.ballerina.protoc.core.builder.syntaxtree.components.IfElse;
import io.ballerina.protoc.core.builder.syntaxtree.components.Literal;
import io.ballerina.protoc.core.builder.syntaxtree.components.Record;
import io.ballerina.protoc.core.builder.syntaxtree.components.Statement;
import io.ballerina.protoc.core.builder.syntaxtree.components.Type;
import io.ballerina.protoc.core.builder.syntaxtree.components.TypeDescriptor;
import io.ballerina.protoc.core.builder.syntaxtree.components.VariableDeclaration;
import io.ballerina.protoc.core.builder.syntaxtree.constants.SyntaxTreeConstants;
import io.ballerina.protoc.core.builder.syntaxtree.utils.CommonUtils;
import io.ballerina.protoc.core.builder.syntaxtree.utils.EnumUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MessageUtils {
    private MessageUtils() {
    }

    public static NodeList<ModuleMemberDeclarationNode> getMessageNodes(Message message, String descriptorName, String filename) {
        NodeList messageMembers = AbstractNodeFactory.createEmptyNodeList();
        NodeList annotationNodes = AbstractNodeFactory.createEmptyNodeList();
        Annotation protobufDescriptor = new Annotation("protobuf", "Descriptor");
        protobufDescriptor.addField("value", descriptorName);
        annotationNodes = annotationNodes.add((Node)protobufDescriptor.getAnnotationNode());
        MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)annotationNodes);
        messageMembers = messageMembers.add((Node)MessageUtils.getMessageType(message, filename).getTypeDefinitionNode(metadataNode));
        if (message.getNestedMessageList() != null) {
            for (Message nestedMessage : message.getNestedMessageList()) {
                for (ModuleMemberDeclarationNode messageNode : MessageUtils.getMessageNodes(nestedMessage, descriptorName, filename)) {
                    messageMembers = messageMembers.add((Node)messageNode);
                }
            }
        }
        if (message.getOneofFieldMap() != null) {
            messageMembers = messageMembers.add((Node)MessageUtils.getValidationFunction(message).getFunctionDefinitionNode());
            for (Map.Entry oneOfFieldMap : message.getOneofFieldMap().entrySet()) {
                for (Field field : (List)oneOfFieldMap.getValue()) {
                    messageMembers = messageMembers.add((Node)MessageUtils.getOneOfFieldSetFunction(message.getMessageName(), field, (List)oneOfFieldMap.getValue()).getFunctionDefinitionNode());
                }
            }
        }
        if (message.getEnumList() != null) {
            for (EnumMessage enumMessage : message.getEnumList()) {
                messageMembers = messageMembers.add((Node)EnumUtils.getEnum(enumMessage).getEnumDeclarationNode());
            }
        }
        return messageMembers;
    }

    private static Type getMessageType(Message message, String filename) {
        Record messageRecord = new Record();
        block54: for (Field field : message.getFieldList()) {
            if (field.getFieldLabel() == null) {
                switch (field.getFieldType()) {
                    case "string": 
                    case "int": 
                    case "float": 
                    case "boolean": {
                        messageRecord.addBasicFieldWithDefaultValue(field.getFieldType(), field.getFieldName(), field.getDefaultValue(filename));
                        break;
                    }
                    case "byte[]": {
                        messageRecord.addArrayFieldWithDefaultValue("byte", field.getFieldName());
                        break;
                    }
                    case "Timestamp": {
                        messageRecord.addCustomFieldWithDefaultValue("time:Utc", field.getFieldName(), "[0, 0.0d]");
                        break;
                    }
                    case "Duration": {
                        messageRecord.addCustomFieldWithDefaultValue("time:Seconds", field.getFieldName(), "0.0d");
                        break;
                    }
                    case "Struct": {
                        messageRecord.addMapFieldWithDefaultValue(SyntaxTreeConstants.SYNTAX_TREE_VAR_ANYDATA, field.getFieldName());
                        break;
                    }
                    case "'any:Any": {
                        messageRecord.addCustomFieldWithDefaultValue("'any:Any", field.getFieldName(), "{}");
                        break;
                    }
                    default: {
                        messageRecord.addCustomFieldWithDefaultValue(field.getPackageName(filename) + field.getFieldType(), field.getFieldName(), field.getDefaultValue(filename));
                        break;
                    }
                }
                continue;
            }
            switch (field.getFieldType()) {
                case "byte[]": {
                    messageRecord.addArrayFieldWithDefaultValue("byte", field.getFieldName());
                    continue block54;
                }
                case "Timestamp": {
                    messageRecord.addArrayFieldWithDefaultValue("time:Utc", field.getFieldName());
                    continue block54;
                }
                case "Duration": {
                    messageRecord.addArrayFieldWithDefaultValue("time:Seconds", field.getFieldName());
                    continue block54;
                }
                case "Struct": {
                    messageRecord.addArrayFieldWithDefaultValue("map<anydata>", field.getFieldName());
                    continue block54;
                }
                case "'any:Any": {
                    messageRecord.addArrayFieldWithDefaultValue("'any:Any", field.getFieldName());
                    continue block54;
                }
            }
            messageRecord.addArrayFieldWithDefaultValue(field.getPackageName(filename) + field.getFieldType(), field.getFieldName());
        }
        if (message.getOneofFieldMap() != null) {
            for (Map.Entry entry : message.getOneofFieldMap().entrySet()) {
                block56: for (Field field : (List)entry.getValue()) {
                    switch (field.getFieldType()) {
                        case "string": 
                        case "int": 
                        case "float": 
                        case "boolean": {
                            if (field.getFieldLabel() == null) {
                                messageRecord.addOptionalBasicField(field.getFieldType(), field.getFieldName());
                                continue block56;
                            }
                            messageRecord.addOptionalArrayField(field.getFieldType(), field.getFieldName());
                            continue block56;
                        }
                        case "byte[]": {
                            messageRecord.addOptionalArrayField("byte", field.getFieldName());
                            continue block56;
                        }
                        case "Timestamp": {
                            messageRecord.addOptionalCustomField("time:Utc", field.getFieldName());
                            continue block56;
                        }
                        case "Duration": {
                            messageRecord.addOptionalCustomField("time:Seconds", field.getFieldName());
                            continue block56;
                        }
                        case "Struct": {
                            messageRecord.addOptionalMapField(SyntaxTreeConstants.SYNTAX_TREE_VAR_ANYDATA, field.getFieldName());
                            continue block56;
                        }
                    }
                    if (field.getFieldLabel() == null) {
                        messageRecord.addOptionalCustomField(field.getPackageName(filename) + field.getFieldType(), field.getFieldName());
                        continue;
                    }
                    messageRecord.addOptionalArrayField(field.getPackageName(filename) + field.getFieldType(), field.getFieldName());
                }
            }
        }
        if (message.getMapList() != null) {
            for (Message message2 : message.getMapList()) {
                Record record = new Record();
                for (Field field : message2.getFieldList()) {
                    record.addBasicField(field.getPackageName(filename) + field.getFieldType(), field.getFieldName());
                }
                messageRecord.addArrayFieldWithDefaultValue(record, message2.getMessageName());
            }
        }
        return new Type(true, message.getMessageName(), (Node)messageRecord.getRecordTypeDescriptorNode());
    }

    private static Function getValidationFunction(Message message) {
        Function function = new Function("isValid" + CommonUtils.capitalizeFirstLetter(message.getMessageName()));
        function.addReturns((TypeDescriptorNode)TypeDescriptor.getBuiltinSimpleNameReferenceNode("boolean"));
        function.addRequiredParameter((Node)TypeDescriptor.getSimpleNameReferenceNode(message.getMessageName()), "r");
        ArrayList<String> counts = new ArrayList<String>();
        for (Map.Entry<String, List<Field>> oneOfFieldMap : message.getOneofFieldMap().entrySet()) {
            counts.add(oneOfFieldMap.getKey() + "Count");
            VariableDeclaration count = new VariableDeclaration(TypeDescriptor.getTypedBindingPatternNode(SyntaxTreeConstants.SYNTAX_TREE_VAR_INT, (BindingPatternNode)TypeDescriptor.getCaptureBindingPatternNode(oneOfFieldMap.getKey() + "Count")), (ExpressionNode)Literal.getNumericLiteralNode(0));
            function.addVariableStatement(count.getVariableDeclarationNode());
            for (Field field : oneOfFieldMap.getValue()) {
                IfElse oneOfFieldCheck = new IfElse((ExpressionNode)Expression.getUnaryTypeTestExpressionNode((ExpressionNode)Expression.getOptionalFieldAccessExpressionNode("r", field.getFieldName()), (Node)TypeDescriptor.getNilTypeDescriptorNode()));
                oneOfFieldCheck.addIfStatement((StatementNode)Statement.getCompoundAssignmentStatementNode(oneOfFieldMap.getKey() + "Count", SyntaxTreeConstants.SYNTAX_TREE_OPERATOR_PLUS, 1));
                function.addIfElseStatement(oneOfFieldCheck.getIfElseStatementNode());
            }
        }
        if (counts.size() > 0) {
            IfElse countCheck = new IfElse((ExpressionNode)MessageUtils.getCountCheckBinaryExpression(counts));
            countCheck.addIfStatement((StatementNode)Statement.getReturnStatementNode((ExpressionNode)Literal.getBooleanLiteralNode(false)));
            function.addIfElseStatement(countCheck.getIfElseStatementNode());
        }
        function.addReturnStatement((ExpressionNode)Literal.getBooleanLiteralNode(true));
        function.addQualifiers(new String[]{"isolated"});
        return function;
    }

    private static BinaryExpressionNode getCountCheckBinaryExpression(ArrayList<String> counts) {
        BinaryExpressionNode binaryExpressionNode = Expression.getBinaryExpressionNode((Node)TypeDescriptor.getSimpleNameReferenceNode(counts.get(0)), (Node)Literal.getNumericLiteralNode(1), SyntaxTreeConstants.SYNTAX_TREE_OPERATOR_GREATER_THAN);
        for (int i = 1; i < counts.size(); ++i) {
            BinaryExpressionNode rhs = Expression.getBinaryExpressionNode((Node)TypeDescriptor.getSimpleNameReferenceNode(counts.get(i)), (Node)Literal.getNumericLiteralNode(1), SyntaxTreeConstants.SYNTAX_TREE_OPERATOR_GREATER_THAN);
            binaryExpressionNode = Expression.getBinaryExpressionNode((Node)binaryExpressionNode, (Node)rhs, SyntaxTreeConstants.SYNTAX_TREE_OPERATOR_OR);
        }
        return binaryExpressionNode;
    }

    private static Function getOneOfFieldSetFunction(String messageName, Field field, List<Field> fields) {
        Function function = new Function("set" + messageName + "_" + CommonUtils.toPascalCase(field.getFieldName()));
        function.addRequiredParameter((Node)TypeDescriptor.getSimpleNameReferenceNode(messageName), "r");
        function.addRequiredParameter((Node)TypeDescriptor.getBuiltinSimpleNameReferenceNode(field.getFieldType()), field.getFieldName());
        function.addAssignmentStatement((Node)Expression.getFieldAccessExpressionNode("r", field.getFieldName()), (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode(field.getFieldName()));
        for (Field oneOfField : fields) {
            if (oneOfField.getFieldName().equals(field.getFieldName())) continue;
            function.addAssignmentStatement((Node)TypeDescriptor.getSimpleNameReferenceNode("_"), (ExpressionNode)Expression.getMethodCallExpressionNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("r"), "removeIfHasKey", "\"" + oneOfField.getFieldName().replaceAll("'", "") + "\""));
        }
        function.addQualifiers(new String[]{"isolated"});
        return function;
    }
}

