/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.core.builder.syntaxtree.utils;

import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.protoc.core.builder.BallerinaFileBuilder;
import io.ballerina.protoc.core.builder.stub.Method;
import io.ballerina.protoc.core.builder.syntaxtree.components.Class;
import io.ballerina.protoc.core.builder.syntaxtree.components.Expression;
import io.ballerina.protoc.core.builder.syntaxtree.components.Function;
import io.ballerina.protoc.core.builder.syntaxtree.components.IfElse;
import io.ballerina.protoc.core.builder.syntaxtree.components.Map;
import io.ballerina.protoc.core.builder.syntaxtree.components.Record;
import io.ballerina.protoc.core.builder.syntaxtree.components.Statement;
import io.ballerina.protoc.core.builder.syntaxtree.components.TypeDescriptor;
import io.ballerina.protoc.core.builder.syntaxtree.components.VariableDeclaration;
import io.ballerina.protoc.core.builder.syntaxtree.constants.SyntaxTreeConstants;
import io.ballerina.protoc.core.builder.syntaxtree.utils.CommonUtils;

public class ServerUtils {
    private ServerUtils() {
    }

    public static Function getServerStreamingFunction(Method method, String filename) {
        Function function = new Function(method.getMethodName());
        String inputCap = "Nil";
        if (method.getInputType() != null) {
            inputCap = CommonUtils.getMethodType(method.getInputType());
            String contextParam = "Context" + inputCap;
            contextParam = CommonUtils.isBallerinaProtobufType(method.getInputType()) ? CommonUtils.getProtobufType(method.getInputType()) + ":" + contextParam : CommonUtils.getModulePrefix(contextParam, filename) + contextParam;
            function.addRequiredParameter((Node)TypeDescriptor.getUnionTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(method.getInputPackagePrefix(filename) + method.getInputType()), (TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(contextParam)), "req");
        }
        String outCap = CommonUtils.getMethodType(method.getOutputType());
        function.addReturns((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getStreamTypeDescriptorNode((Node)TypeDescriptor.getSimpleNameReferenceNode(method.getOutputPackageType(filename) + method.getOutputType()), (Node)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL), (TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR));
        ServerUtils.addServerBody(function, method, inputCap, outCap, "_", filename);
        function.addReturnStatement((ExpressionNode)Expression.getExplicitNewExpressionNode((TypeDescriptorNode)TypeDescriptor.getStreamTypeDescriptorNode((Node)TypeDescriptor.getSimpleNameReferenceNode(method.getOutputPackageType(filename) + method.getOutputType()), (Node)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL), "outputStream"));
        function.addQualifiers(new String[]{"isolated", "remote"});
        return function;
    }

    public static Function getServerStreamingContextFunction(Method method, String filename) {
        Function function = new Function(method.getMethodName() + "Context");
        String inputCap = "Nil";
        if (method.getInputType() != null) {
            inputCap = CommonUtils.getMethodType(method.getInputType());
            String contextParam = "Context" + inputCap;
            contextParam = CommonUtils.isBallerinaProtobufType(method.getInputType()) ? CommonUtils.getProtobufType(method.getInputType()) + ":" + contextParam : CommonUtils.getModulePrefix(contextParam, filename) + contextParam;
            function.addRequiredParameter((Node)TypeDescriptor.getUnionTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(method.getInputPackagePrefix(filename) + method.getInputType()), (TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(contextParam)), "req");
        }
        String outputCap = CommonUtils.getMethodType(method.getOutputType());
        String contextStreamParam = "Context" + outputCap + "Stream";
        if (CommonUtils.isBallerinaProtobufType(method.getOutputType())) {
            contextStreamParam = CommonUtils.getProtobufType(method.getOutputType()) + ":" + contextStreamParam;
        } else if (BallerinaFileBuilder.componentsModuleMap.containsKey(contextStreamParam) && BallerinaFileBuilder.protofileModuleMap.containsKey(filename)) {
            String module = BallerinaFileBuilder.componentsModuleMap.get(contextStreamParam);
            if (!BallerinaFileBuilder.protofileModuleMap.get(filename).equals(module)) {
                contextStreamParam = module.substring(module.lastIndexOf(".") + 1) + ":" + contextStreamParam;
            }
        }
        function.addReturns((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(contextStreamParam), (TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR));
        ServerUtils.addServerBody(function, method, inputCap, outputCap, "respHeaders", filename);
        Map returnMap = new Map();
        returnMap.addField("content", (ExpressionNode)Expression.getExplicitNewExpressionNode((TypeDescriptorNode)TypeDescriptor.getStreamTypeDescriptorNode((Node)TypeDescriptor.getSimpleNameReferenceNode(method.getOutputPackageType(filename) + method.getOutputType()), (Node)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL), "outputStream"));
        returnMap.addSimpleNameReferenceField("headers", "respHeaders");
        function.addReturnStatement((ExpressionNode)returnMap.getMappingConstructorExpressionNode());
        function.addQualifiers(new String[]{"isolated", "remote"});
        return function;
    }

    public static Class getServerStreamClass(Method method, String filename) {
        String outputCap = CommonUtils.getMethodType(method.getOutputType());
        Class serverStream = new Class(outputCap + "Stream", true);
        if (BallerinaFileBuilder.protofileModuleMap.containsKey(filename)) {
            BallerinaFileBuilder.componentsModuleMap.put(outputCap + "Stream", BallerinaFileBuilder.protofileModuleMap.get(filename));
        }
        serverStream.addMember((Node)TypeDescriptor.getObjectFieldNode("private", new String[0], (Node)TypeDescriptor.getStreamTypeDescriptorNode((Node)SyntaxTreeConstants.SYNTAX_TREE_VAR_ANYDATA, (Node)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL), "anydataStream"));
        serverStream.addMember((Node)ServerUtils.getInitFunction().getFunctionDefinitionNode());
        serverStream.addMember((Node)ServerUtils.getNextFunction(method, filename).getFunctionDefinitionNode());
        serverStream.addMember((Node)ServerUtils.getCloseFunction().getFunctionDefinitionNode());
        return serverStream;
    }

    private static Function getInitFunction() {
        Function function = new Function("init");
        function.addRequiredParameter((Node)TypeDescriptor.getStreamTypeDescriptorNode((Node)SyntaxTreeConstants.SYNTAX_TREE_VAR_ANYDATA, (Node)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL), "anydataStream");
        function.addAssignmentStatement((Node)Expression.getFieldAccessExpressionNode("self", "anydataStream"), (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("anydataStream"));
        function.addQualifiers(new String[]{"public", "isolated"});
        return function;
    }

    private static Function getNextFunction(Method method, String filename) {
        Function function = new Function("next");
        Record nextRecord = new Record();
        nextRecord.addCustomField(method.getOutputPackageType(filename) + method.getOutputType(), "value");
        function.addReturns((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode((TypeDescriptorNode)nextRecord.getRecordTypeDescriptorNode(), (TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL));
        VariableDeclaration streamValue = new VariableDeclaration(TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getBuiltinSimpleNameReferenceNode("var"), (BindingPatternNode)TypeDescriptor.getCaptureBindingPatternNode("streamValue")), (ExpressionNode)Expression.getMethodCallExpressionNode((ExpressionNode)Expression.getFieldAccessExpressionNode("self", "anydataStream"), "next", new String[0]));
        function.addVariableStatement(streamValue.getVariableDeclarationNode());
        IfElse streamValueNilCheck = new IfElse((ExpressionNode)Expression.getTypeTestExpressionNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("streamValue"), (Node)TypeDescriptor.getNilTypeDescriptorNode()));
        streamValueNilCheck.addIfStatement((StatementNode)Statement.getReturnStatementNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("streamValue")));
        IfElse streamValueErrorCheck = new IfElse((ExpressionNode)Expression.getTypeTestExpressionNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("streamValue"), (Node)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR));
        streamValueErrorCheck.addIfStatement((StatementNode)Statement.getReturnStatementNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("streamValue")));
        Record nextRecordRec = new Record();
        nextRecordRec.addCustomField(method.getOutputPackageType(filename) + method.getOutputType(), "value");
        Map nextRecordMap = new Map();
        if (method.getOutputType().equals("time:Utc")) {
            nextRecordMap.addTypeCastExpressionField("value", method.getOutputPackageType(filename) + method.getOutputType(), (ExpressionNode)Expression.getMethodCallExpressionNode((ExpressionNode)Expression.getFieldAccessExpressionNode("streamValue", "value"), "cloneReadOnly", new String[0]));
        } else {
            nextRecordMap.addTypeCastExpressionField("value", method.getOutputPackageType(filename) + method.getOutputType(), (ExpressionNode)Expression.getFieldAccessExpressionNode("streamValue", "value"));
        }
        VariableDeclaration nextRecordVar = new VariableDeclaration(TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)nextRecordRec.getRecordTypeDescriptorNode(), (BindingPatternNode)TypeDescriptor.getCaptureBindingPatternNode("nextRecord")), (ExpressionNode)nextRecordMap.getMappingConstructorExpressionNode());
        streamValueErrorCheck.addElseStatement((StatementNode)nextRecordVar.getVariableDeclarationNode());
        streamValueErrorCheck.addElseStatement((StatementNode)Statement.getReturnStatementNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("nextRecord")));
        streamValueNilCheck.addElseBody(streamValueErrorCheck);
        function.addIfElseStatement(streamValueNilCheck.getIfElseStatementNode());
        function.addQualifiers(new String[]{"public", "isolated"});
        return function;
    }

    private static Function getCloseFunction() {
        Function function = new Function("close");
        function.addReturns((TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL);
        function.addReturnStatement((ExpressionNode)Expression.getMethodCallExpressionNode((ExpressionNode)Expression.getFieldAccessExpressionNode("self", "anydataStream"), "close", new String[0]));
        function.addQualifiers(new String[]{"public", "isolated"});
        return function;
    }

    private static void addServerBody(Function function, Method method, String inputCap, String outCap, String headers, String filename) {
        CommonUtils.addClientCallBody(function, inputCap, method, filename);
        SeparatedNodeList payloadArgs = NodeFactory.createSeparatedNodeList((Node[])new Node[]{TypeDescriptor.getStreamTypeDescriptorNode((Node)SyntaxTreeConstants.SYNTAX_TREE_VAR_ANYDATA, (Node)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL), SyntaxTreeConstants.SYNTAX_TREE_COMMA, TypeDescriptor.getMapTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode(SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING, SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING_ARRAY))});
        VariableDeclaration payloadTuple = new VariableDeclaration(TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getTupleTypeDescriptorNode((SeparatedNodeList<Node>)payloadArgs), (BindingPatternNode)TypeDescriptor.getListBindingPatternNode(new String[]{"result", headers})), (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("payload"));
        function.addVariableStatement(payloadTuple.getVariableDeclarationNode());
        String streamParam = outCap + "Stream";
        if (CommonUtils.isBallerinaProtobufType(method.getOutputType())) {
            Object streamParamPrefix = "s" + CommonUtils.getProtobufType(method.getOutputType());
            if (inputCap.equals("Any")) {
                streamParamPrefix = "sany";
            }
            streamParam = (String)streamParamPrefix + ":" + streamParam;
        }
        if (BallerinaFileBuilder.componentsModuleMap.containsKey(streamParam) && BallerinaFileBuilder.protofileModuleMap.containsKey(filename)) {
            String module = BallerinaFileBuilder.componentsModuleMap.get(streamParam);
            if (!BallerinaFileBuilder.protofileModuleMap.get(filename).equals(module)) {
                streamParam = module.substring(module.lastIndexOf(".") + 1) + ":" + streamParam;
            }
        }
        VariableDeclaration stream = new VariableDeclaration(TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(streamParam), (BindingPatternNode)TypeDescriptor.getCaptureBindingPatternNode("outputStream")), (ExpressionNode)Expression.getExplicitNewExpressionNode(streamParam, new String[]{"result"}));
        function.addVariableStatement(stream.getVariableDeclarationNode());
    }
}

