/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.core;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Constants {
    public static final String MODEL_VERSION = "0.4.0";
    public static final String COLON = ":";
    public static final String FORWARD_SLASH = "/";
    public static final String SERVICE_ANNOTATION = "choreo:Service";
    public static final String DISPLAY_ANNOTATION = "display";
    public static final String CLIENT_ANNOTATION = "choreo:Client";
    public static final String ID = "id";
    public static final String LABEL = "label";
    public static final String MODULES = "modules";
    public static final String SERVICE_ID = "serviceId";
    public static final String ARRAY = "[]";
    public static final String LISTENER = ":Listener";
    public static final String CLIENT = ":Client";
    public static final String MAIN = "main";
    public static final String CONSTRAINT_KEYWORD = "constraint";
    public static final String CONSTRAINT_ARRAY = "Array";
    public static final String MIN_LENGTH_FIELD = "minLength";
    public static final String MAX_LENGTH_FIELD = "maxLength";
    public static final String DEFAULT_SERVICE_BASE_PATH = "_defaultBasePath";
    public static final String GET_KEYWORD = "get";
    public static final Map<SyntaxKind, String> TYPE_MAP;

    static {
        HashMap<SyntaxKind, String> typeMap = new HashMap<SyntaxKind, String>();
        typeMap.put(SyntaxKind.STRING_LITERAL, "string");
        typeMap.put(SyntaxKind.BOOLEAN_LITERAL, "boolean");
        typeMap.put(SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN, "float");
        typeMap.put(SyntaxKind.NUMERIC_LITERAL, "decimal");
        typeMap.put(SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN, "float");
        TYPE_MAP = Collections.unmodifiableMap(typeMap);
    }

    public static enum CardinalityValue {
        ZERO("0"),
        ZERO_OR_ONE("0-1"),
        ZERO_OR_MANY("0-m"),
        ONE("1"),
        ONE_AND_ONLY_ONE("1-1"),
        ONE_OR_MANY("1-m"),
        MANY("m"),
        CUSTOM;

        private final String cardinalityValue;

        private CardinalityValue(String cardinalityValue) {
            this.cardinalityValue = cardinalityValue;
        }

        private CardinalityValue() {
            this.cardinalityValue = "";
        }

        public String getValue() {
            return this.cardinalityValue;
        }

        public String getCustomValue(String min, String max) {
            return min + "-" + max;
        }
    }

    public static enum ParameterIn {
        BODY("body"),
        QUERY("query"),
        HEADER("header"),
        PATH("path");

        private final String parameterIn;

        private ParameterIn(String parameterIn) {
            this.parameterIn = parameterIn;
        }

        public String getValue() {
            return this.parameterIn;
        }
    }
}

