/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.core.generators.entrypoint;

import io.ballerina.architecturemodelgenerator.core.generators.ModelGenerator;
import io.ballerina.architecturemodelgenerator.core.generators.entrypoint.nodevisitors.FunctionEntryPointVisitor;
import io.ballerina.architecturemodelgenerator.core.model.functionentrypoint.FunctionEntryPoint;
import io.ballerina.architecturemodelgenerator.core.model.service.Connection;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.PackageCompilation;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;

public class FunctionEntryPointModelGenerator
extends ModelGenerator {
    private FunctionEntryPoint functionEntryPoint = null;
    private final List<Connection> dependencies = new LinkedList<Connection>();

    public FunctionEntryPoint getFunctionEntryPoint() {
        return this.functionEntryPoint;
    }

    public List<Connection> getDependencies() {
        return this.dependencies;
    }

    public FunctionEntryPointModelGenerator(PackageCompilation packageCompilation, Module module) {
        super(packageCompilation, module);
    }

    public void generate() {
        for (DocumentId documentId : this.getModule().documentIds()) {
            SyntaxTree syntaxTree = this.getModule().document(documentId).syntaxTree();
            Path filePath = this.getModuleRootPath().resolve(syntaxTree.filePath());
            FunctionEntryPointVisitor functionEntryPointVisitor = new FunctionEntryPointVisitor(this.getPackageCompilation(), this.getSemanticModel(), syntaxTree, this.getModule().packageInstance(), filePath);
            syntaxTree.rootNode().accept((NodeVisitor)functionEntryPointVisitor);
            FunctionEntryPoint entryPointVisited = functionEntryPointVisitor.getFunctionEntryPoint();
            if (entryPointVisited == null) continue;
            this.functionEntryPoint = entryPointVisited;
            this.dependencies.addAll(functionEntryPointVisitor.getDependencies());
        }
    }
}

