/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.core.generators.service.nodevisitors;

import io.ballerina.architecturemodelgenerator.core.Constants;
import io.ballerina.architecturemodelgenerator.core.diagnostics.ArchitectureModelDiagnostic;
import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticMessage;
import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticNode;
import io.ballerina.architecturemodelgenerator.core.generators.GeneratorUtils;
import io.ballerina.architecturemodelgenerator.core.model.common.DisplayAnnotation;
import io.ballerina.architecturemodelgenerator.core.model.common.Interaction;
import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Annotatable;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ClientResourceAccessActionNode;
import io.ballerina.compiler.syntax.tree.ComputedResourceAccessSegmentNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ActionNodeVisitor
extends NodeVisitor {
    private final PackageCompilation packageCompilation;
    private final SemanticModel semanticModel;
    private final Package currentPackage;
    private final List<Interaction> interactionList = new LinkedList<Interaction>();
    private final String filePath;
    private final Set<NameReferenceNode> visitedFunctionNames = new HashSet<NameReferenceNode>();
    private final String modulePrefix;

    public ActionNodeVisitor(PackageCompilation packageCompilation, SemanticModel semanticModel, Package currentPackage, String filePath) {
        this(packageCompilation, semanticModel, currentPackage, filePath, new HashSet<NameReferenceNode>(), null);
    }

    public ActionNodeVisitor(PackageCompilation packageCompilation, SemanticModel semanticModel, Package currentPackage, String filePath, Set<NameReferenceNode> visitedFunctionNames, String modulePrefix) {
        this.packageCompilation = packageCompilation;
        this.semanticModel = semanticModel;
        this.currentPackage = currentPackage;
        this.filePath = filePath;
        this.visitedFunctionNames.addAll(visitedFunctionNames);
        this.modulePrefix = modulePrefix;
    }

    public List<Interaction> getInteractionList() {
        return this.interactionList;
    }

    public Set<NameReferenceNode> getVisitedFunctionNames() {
        return this.visitedFunctionNames;
    }

    public void visit(ClientResourceAccessActionNode clientResourceAccessActionNode) {
        SimpleNameReferenceNode clientNode = null;
        String resourceMethod = null;
        String resourcePath = null;
        String serviceId = null;
        ArrayList<ArchitectureModelDiagnostic> diagnostics = new ArrayList<ArchitectureModelDiagnostic>();
        try {
            if (clientResourceAccessActionNode.expression().kind().equals((Object)SyntaxKind.FIELD_ACCESS)) {
                NameReferenceNode fieldName = ((FieldAccessExpressionNode)clientResourceAccessActionNode.expression()).fieldName();
                if (fieldName.kind().equals((Object)SyntaxKind.SIMPLE_NAME_REFERENCE)) {
                    clientNode = fieldName;
                }
            } else if (clientResourceAccessActionNode.expression().kind().equals((Object)SyntaxKind.SIMPLE_NAME_REFERENCE)) {
                clientNode = (SimpleNameReferenceNode)clientResourceAccessActionNode.expression();
            } else if (clientResourceAccessActionNode.expression().kind().equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE)) {
                clientNode = (QualifiedNameReferenceNode)clientResourceAccessActionNode.expression();
            }
            resourceMethod = clientResourceAccessActionNode.methodName().isPresent() ? String.valueOf(((SimpleNameReferenceNode)clientResourceAccessActionNode.methodName().get()).name().text()) : "get";
            resourcePath = this.getResourcePath((SeparatedNodeList<Node>)clientResourceAccessActionNode.resourceAccessPath());
            Optional clientSymbol = this.semanticModel.symbol((Node)clientNode);
            if (clientSymbol.isPresent()) {
                Annotatable annotatableSymbol = (Annotatable)clientSymbol.get();
                DisplayAnnotation serviceAnnotation = GeneratorUtils.getServiceAnnotation(annotatableSymbol, this.filePath);
                serviceId = serviceAnnotation.getId() != null ? serviceAnnotation.getId() : Integer.toString(clientSymbol.hashCode());
            }
        }
        catch (Exception e) {
            DiagnosticMessage message = DiagnosticMessage.failedToGenerate(DiagnosticNode.INTERACTION, e.getMessage());
            ArchitectureModelDiagnostic diagnostic = new ArchitectureModelDiagnostic(message.getCode(), message.getDescription(), message.getSeverity(), null, null);
            diagnostics.add(diagnostic);
        }
        String resourceFunctionId = String.format("%s:%s:%s", serviceId, resourcePath, resourceMethod);
        Interaction interaction = new Interaction(resourceFunctionId, GeneratorUtils.getClientModuleName((Node)clientNode, this.semanticModel), GeneratorUtils.getSourceLocation(this.filePath, clientResourceAccessActionNode.lineRange()), serviceId, diagnostics);
        this.interactionList.add(interaction);
    }

    public void visit(RemoteMethodCallActionNode remoteMethodCallActionNode) {
        SimpleNameReferenceNode clientNode = null;
        String resourceMethod = null;
        String serviceId = null;
        ArrayList<ArchitectureModelDiagnostic> diagnostics = new ArrayList<ArchitectureModelDiagnostic>();
        try {
            if (remoteMethodCallActionNode.expression().kind().equals((Object)SyntaxKind.FIELD_ACCESS)) {
                NameReferenceNode fieldName = ((FieldAccessExpressionNode)remoteMethodCallActionNode.expression()).fieldName();
                if (fieldName.kind().equals((Object)SyntaxKind.SIMPLE_NAME_REFERENCE)) {
                    clientNode = fieldName;
                }
            } else if (remoteMethodCallActionNode.expression().kind().equals((Object)SyntaxKind.SIMPLE_NAME_REFERENCE)) {
                clientNode = (SimpleNameReferenceNode)remoteMethodCallActionNode.expression();
            } else if (remoteMethodCallActionNode.expression().kind().equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE)) {
                clientNode = (QualifiedNameReferenceNode)remoteMethodCallActionNode.expression();
            }
            if (clientNode != null) {
                resourceMethod = remoteMethodCallActionNode.methodName().name().text();
                Optional clientSymbol = this.semanticModel.symbol((Node)clientNode);
                if (clientSymbol.isPresent()) {
                    Annotatable annotatableSymbol = (Annotatable)clientSymbol.get();
                    DisplayAnnotation serviceAnnotation = GeneratorUtils.getServiceAnnotation(annotatableSymbol, this.filePath);
                    serviceId = serviceAnnotation.getId() != null ? serviceAnnotation.getId() : Integer.toString(clientSymbol.hashCode());
                }
            }
        }
        catch (Exception e) {
            DiagnosticMessage message = DiagnosticMessage.failedToGenerate(DiagnosticNode.INTERACTION, e.getMessage());
            ArchitectureModelDiagnostic diagnostic = new ArchitectureModelDiagnostic(message.getCode(), message.getDescription(), message.getSeverity(), null, null);
            diagnostics.add(diagnostic);
        }
        String remoteFunctionId = String.format("%s:%s", serviceId, resourceMethod);
        if (clientNode != null) {
            Interaction interaction = new Interaction(remoteFunctionId, GeneratorUtils.getClientModuleName((Node)clientNode, this.semanticModel), GeneratorUtils.getSourceLocation(this.filePath, remoteMethodCallActionNode.lineRange()), serviceId, diagnostics);
            this.interactionList.add(interaction);
        }
    }

    public void visit(FunctionCallExpressionNode functionCallExpressionNode) {
        if ((functionCallExpressionNode.functionName() instanceof SimpleNameReferenceNode || functionCallExpressionNode.functionName() instanceof QualifiedNameReferenceNode) && this.isNodeAlreadyVisited(functionCallExpressionNode.functionName())) {
            this.visitedFunctionNames.add(functionCallExpressionNode.functionName());
            Optional symbol = this.semanticModel.symbol((Node)functionCallExpressionNode.functionName());
            symbol.ifPresent(value -> this.findInteractions(functionCallExpressionNode.functionName(), (Symbol)value));
            if (!functionCallExpressionNode.arguments().isEmpty()) {
                functionCallExpressionNode.arguments().forEach(arg -> arg.accept((NodeVisitor)this));
            }
        }
    }

    public void visit(MethodCallExpressionNode methodCallExpressionNode) {
        if (methodCallExpressionNode.methodName() instanceof SimpleNameReferenceNode && this.isNodeAlreadyVisited(methodCallExpressionNode.methodName())) {
            this.visitedFunctionNames.add(methodCallExpressionNode.methodName());
            Optional symbol = this.semanticModel.symbol((Node)methodCallExpressionNode.methodName());
            symbol.ifPresent(value -> this.findInteractions(methodCallExpressionNode.methodName(), (Symbol)value));
            if (!methodCallExpressionNode.arguments().isEmpty()) {
                methodCallExpressionNode.arguments().forEach(arg -> arg.accept((NodeVisitor)this));
            }
        }
    }

    private void findInteractions(NameReferenceNode nameNode, Symbol methodSymbol) {
        Optional location = methodSymbol.getLocation();
        Optional optionalModuleSymbol = methodSymbol.getModule();
        if (optionalModuleSymbol.isPresent()) {
            ModuleID moduleID = ((ModuleSymbol)optionalModuleSymbol.get()).id();
            this.currentPackage.modules().forEach(module -> {
                if (Objects.equals(moduleID.moduleName(), module.moduleName().toString())) {
                    Collection documentIds = module.documentIds();
                    for (DocumentId documentId : documentIds) {
                        MethodDeclarationNode methodDeclarationNode;
                        ActionNodeVisitor actionNodeVisitor;
                        String referencedFunctionName;
                        String modulePrefix;
                        SyntaxTree syntaxTree = module.document(documentId).syntaxTree();
                        NonTerminalNode node = ((ModulePartNode)syntaxTree.rootNode()).findNode(((Location)location.get()).textRange());
                        if (node.isMissing()) continue;
                        SemanticModel nextSemanticModel = this.packageCompilation.getSemanticModel(module.moduleId());
                        boolean isReferredNodeFromSameModule = this.isReferredNodeFromSameModule((Node)nameNode, (Module)module);
                        String string = modulePrefix = isReferredNodeFromSameModule ? null : module.moduleName().moduleNamePart();
                        if (node instanceof FunctionDefinitionNode) {
                            FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)node;
                            referencedFunctionName = functionDefinitionNode.functionName().text();
                            if (!this.isReferredFunction(nameNode, referencedFunctionName)) continue;
                            actionNodeVisitor = new ActionNodeVisitor(this.packageCompilation, nextSemanticModel, this.currentPackage, this.filePath, this.visitedFunctionNames, modulePrefix);
                            functionDefinitionNode.accept((NodeVisitor)actionNodeVisitor);
                            this.interactionList.addAll(actionNodeVisitor.getInteractionList());
                            this.visitedFunctionNames.addAll(actionNodeVisitor.getVisitedFunctionNames());
                            continue;
                        }
                        if (!(node instanceof MethodDeclarationNode) || !this.isReferredFunction(nameNode, referencedFunctionName = (methodDeclarationNode = (MethodDeclarationNode)node).methodName().text())) continue;
                        actionNodeVisitor = new ActionNodeVisitor(this.packageCompilation, nextSemanticModel, this.currentPackage, this.filePath, this.visitedFunctionNames, modulePrefix);
                        methodDeclarationNode.accept((NodeVisitor)actionNodeVisitor);
                        this.interactionList.addAll(actionNodeVisitor.getInteractionList());
                        this.visitedFunctionNames.addAll(actionNodeVisitor.getVisitedFunctionNames());
                    }
                }
            });
        }
    }

    private String getResourcePath(SeparatedNodeList<Node> accessPathNodes) {
        StringBuilder resourcePathBuilder = new StringBuilder();
        for (Node accessPathNode : accessPathNodes) {
            if (resourcePathBuilder.length() > 0) {
                resourcePathBuilder.append("/");
            }
            if (accessPathNode.kind() == SyntaxKind.IDENTIFIER_TOKEN) {
                resourcePathBuilder.append(((IdentifierToken)accessPathNode).text());
                continue;
            }
            if (accessPathNode.kind() != SyntaxKind.COMPUTED_RESOURCE_ACCESS_SEGMENT) continue;
            ComputedResourceAccessSegmentNode accessSegmentNode = (ComputedResourceAccessSegmentNode)accessPathNode;
            ExpressionNode expressionNode = accessSegmentNode.expression();
            if (expressionNode.kind() == SyntaxKind.STRING_LITERAL) {
                resourcePathBuilder.append(String.format("[%s]", Constants.TYPE_MAP.get(SyntaxKind.STRING_LITERAL)));
                continue;
            }
            if (expressionNode.kind().equals((Object)SyntaxKind.NUMERIC_LITERAL)) {
                SyntaxKind numericKind = ((BasicLiteralNode)expressionNode).literalToken().kind();
                if (numericKind.equals((Object)SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN)) {
                    resourcePathBuilder.append(String.format("[%s]", Constants.TYPE_MAP.get(SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN)));
                    continue;
                }
                if (numericKind.equals((Object)SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN)) {
                    resourcePathBuilder.append(String.format("[%s]", SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN));
                    continue;
                }
                resourcePathBuilder.append(String.format("[%s]", SyntaxKind.NUMERIC_LITERAL));
                continue;
            }
            if (expressionNode.kind().equals((Object)SyntaxKind.BOOLEAN_LITERAL)) {
                resourcePathBuilder.append(String.format("[%s]", SyntaxKind.BOOLEAN_LITERAL));
                continue;
            }
            if (expressionNode.kind() != SyntaxKind.SIMPLE_NAME_REFERENCE && expressionNode.kind() != SyntaxKind.FIELD_ACCESS) continue;
            String varType = ((TypeSymbol)this.semanticModel.typeOf((Node)expressionNode).get()).signature();
            resourcePathBuilder.append("[").append(varType.trim()).append("]");
        }
        return resourcePathBuilder.toString();
    }

    private boolean isNodeAlreadyVisited(NameReferenceNode functionName) {
        if (functionName instanceof SimpleNameReferenceNode) {
            return this.visitedFunctionNames.stream().noneMatch(nameNode -> {
                if (nameNode instanceof SimpleNameReferenceNode) {
                    return ((SimpleNameReferenceNode)nameNode).name().text().equals(((SimpleNameReferenceNode)functionName).name().text());
                }
                if (nameNode instanceof QualifiedNameReferenceNode && this.modulePrefix != null) {
                    return this.getQualifiedNameRefNodeFuncNameText((QualifiedNameReferenceNode)nameNode).equals(this.modulePrefix + ":" + ((SimpleNameReferenceNode)functionName).name().text());
                }
                return false;
            });
        }
        if (functionName instanceof QualifiedNameReferenceNode) {
            return this.visitedFunctionNames.stream().noneMatch(nameNode -> {
                if (nameNode instanceof QualifiedNameReferenceNode) {
                    return this.getQualifiedNameRefNodeFuncNameText((QualifiedNameReferenceNode)nameNode).equals(this.getQualifiedNameRefNodeFuncNameText((QualifiedNameReferenceNode)functionName));
                }
                return false;
            });
        }
        return false;
    }

    private String getQualifiedNameRefNodeFuncNameText(QualifiedNameReferenceNode nameNode) {
        return nameNode.modulePrefix().text() + ((Token)nameNode.colon()).text() + nameNode.identifier().text();
    }

    private boolean isReferredFunction(NameReferenceNode nameNode, String referredFunctionName) {
        if (nameNode instanceof SimpleNameReferenceNode) {
            return ((SimpleNameReferenceNode)nameNode).name().text().equals(referredFunctionName);
        }
        if (nameNode instanceof QualifiedNameReferenceNode) {
            return ((QualifiedNameReferenceNode)nameNode).identifier().text().equals(referredFunctionName);
        }
        return false;
    }

    private boolean isReferredNodeFromSameModule(Node currentNode, Module referredNodeModule) {
        String currentFilePath = currentNode.syntaxTree().filePath();
        Module currentNodeModule = null;
        ArrayList modules = new ArrayList();
        this.currentPackage.modules().forEach(modules::add);
        for (Module module : modules) {
            if (!module.documentIds().stream().anyMatch(docId -> module.document(docId).syntaxTree().filePath().equals(currentFilePath))) continue;
            currentNodeModule = module;
            break;
        }
        return currentNodeModule != null && currentNodeModule.moduleId().moduleName().equals(referredNodeModule.moduleId().moduleName());
    }
}

