/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.core.generators.service.nodevisitors;

import io.ballerina.architecturemodelgenerator.core.diagnostics.ArchitectureModelDiagnostic;
import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticMessage;
import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticNode;
import io.ballerina.architecturemodelgenerator.core.generators.GeneratorUtils;
import io.ballerina.architecturemodelgenerator.core.generators.service.nodevisitors.ServiceMemberFunctionNodeVisitor;
import io.ballerina.architecturemodelgenerator.core.model.common.DisplayAnnotation;
import io.ballerina.architecturemodelgenerator.core.model.service.Connection;
import io.ballerina.architecturemodelgenerator.core.model.service.Service;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class ServiceDeclarationNodeVisitor
extends NodeVisitor {
    private final PackageCompilation packageCompilation;
    private final SemanticModel semanticModel;
    private final SyntaxTree syntaxTree;
    private final Package currentPackage;
    private final List<Service> services = new LinkedList<Service>();
    private final List<Connection> dependencies = new LinkedList<Connection>();
    private final Path filePath;
    private List<String> servicePaths = new ArrayList<String>();

    public ServiceDeclarationNodeVisitor(PackageCompilation packageCompilation, SemanticModel semanticModel, SyntaxTree syntaxTree, Package currentPackage, Path filePath) {
        this.packageCompilation = packageCompilation;
        this.semanticModel = semanticModel;
        this.syntaxTree = syntaxTree;
        this.currentPackage = currentPackage;
        this.filePath = filePath;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public List<Connection> getDependencies() {
        return this.dependencies;
    }

    public void visit(ServiceDeclarationNode serviceDeclarationNode) {
        DisplayAnnotation serviceAnnotation = new DisplayAnnotation();
        NodeList serviceNameNodes = serviceDeclarationNode.absoluteResourcePath();
        Optional metadataNode = serviceDeclarationNode.metadata();
        if (metadataNode.isPresent()) {
            NodeList annotationNodes = ((MetadataNode)metadataNode.get()).annotations();
            serviceAnnotation = GeneratorUtils.getServiceAnnotation((NodeList<AnnotationNode>)annotationNodes, this.filePath.toString());
        }
        String serviceId = this.generateServiceId(serviceAnnotation, (NodeList<Node>)serviceNameNodes);
        String serviceLabel = this.generateServiceLabel(serviceAnnotation, (NodeList<Node>)serviceNameNodes);
        ServiceMemberFunctionNodeVisitor serviceMemberFunctionNodeVisitor = new ServiceMemberFunctionNodeVisitor(serviceId, this.packageCompilation, this.semanticModel, this.syntaxTree, this.currentPackage, this.filePath.toString());
        ArrayList<ArchitectureModelDiagnostic> diagnostics = new ArrayList<ArchitectureModelDiagnostic>();
        try {
            serviceDeclarationNode.accept((NodeVisitor)serviceMemberFunctionNodeVisitor);
        }
        catch (Exception e) {
            DiagnosticMessage message = DiagnosticMessage.failedToGenerate(DiagnosticNode.SERVICE, e.getMessage());
            ArchitectureModelDiagnostic diagnostic = new ArchitectureModelDiagnostic(message.getCode(), message.getDescription(), message.getSeverity(), null, null);
            diagnostics.add(diagnostic);
        }
        ArrayList<String> dependencyIDs = new ArrayList<String>();
        for (Connection dependency : serviceMemberFunctionNodeVisitor.getDependencies()) {
            dependencyIDs.add(dependency.getId());
        }
        this.services.add(new Service(serviceId, serviceLabel, this.getServiceType(serviceDeclarationNode), serviceMemberFunctionNodeVisitor.getResourceFunctions(), serviceMemberFunctionNodeVisitor.getRemoteFunctions(), serviceAnnotation, dependencyIDs, GeneratorUtils.getSourceLocation(this.filePath.toString(), serviceDeclarationNode.lineRange()), diagnostics));
        this.dependencies.addAll(serviceMemberFunctionNodeVisitor.getDependencies());
    }

    private String getServiceType(ServiceDeclarationNode serviceDeclarationNode) {
        String serviceType = null;
        SeparatedNodeList expressionNodes = serviceDeclarationNode.expressions();
        for (ExpressionNode expressionNode : expressionNodes) {
            Optional typeSymbol;
            if (expressionNode instanceof ExplicitNewExpressionNode) {
                ExplicitNewExpressionNode explicitNewExpressionNode = (ExplicitNewExpressionNode)expressionNode;
                TypeDescriptorNode typeDescriptorNode = explicitNewExpressionNode.typeDescriptor();
                if (!(typeDescriptorNode instanceof QualifiedNameReferenceNode)) continue;
                QualifiedNameReferenceNode listenerNode = (QualifiedNameReferenceNode)typeDescriptorNode;
                Optional listenerSymbol = this.semanticModel.symbol((Node)listenerNode);
                if (listenerSymbol.isPresent() && listenerSymbol.get() instanceof TypeReferenceTypeSymbol) {
                    serviceType = ((TypeReferenceTypeSymbol)listenerSymbol.get()).signature().replace(":Listener", "");
                    continue;
                }
                serviceType = listenerNode.modulePrefix().text().trim();
                continue;
            }
            if (!(expressionNode instanceof SimpleNameReferenceNode) || !(typeSymbol = this.semanticModel.typeOf((Node)expressionNode)).isPresent() || !((TypeSymbol)typeSymbol.get()).typeKind().equals((Object)TypeDescKind.TYPE_REFERENCE)) continue;
            serviceType = ((TypeSymbol)typeSymbol.get()).signature().replace(":Listener", "");
        }
        return serviceType;
    }

    private boolean isValidUUID(String uuidString) {
        try {
            UUID.fromString(uuidString);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private String generateServiceId(DisplayAnnotation annotation, NodeList<Node> serviceNameNodes) {
        String servicePath = this.getServicePath(serviceNameNodes);
        if (servicePath.isBlank() || servicePath.equals("/")) {
            servicePath = "_defaultBasePath";
        }
        Object indexedServicePath = servicePath;
        if (this.servicePaths.contains(servicePath)) {
            int index = this.getServicePathIndex(servicePath);
            indexedServicePath = servicePath + (index + 1);
        }
        String serviceId = this.currentPackage.descriptor().org().value() + ":" + this.currentPackage.descriptor().name().value() + ":" + ((String)indexedServicePath).replace("/", "_");
        this.servicePaths.add(servicePath);
        return annotation.getId().isEmpty() ? serviceId : annotation.getId();
    }

    private String generateServiceLabel(DisplayAnnotation annotation, NodeList<Node> serviceNameNodes) {
        String label = annotation.getLabel();
        if (label.isEmpty() || this.isValidUUID(label)) {
            String servicePath = this.servicePaths.remove(this.servicePaths.size() - 1);
            int index = this.getServicePathIndex(servicePath);
            this.servicePaths.add(servicePath);
            String rawServicePath = this.getServicePath(serviceNameNodes);
            if (rawServicePath.isBlank() || rawServicePath.equals("/")) {
                return String.valueOf(this.currentPackage.descriptor().name()) + " Component" + String.valueOf(index > 0 ? Integer.valueOf(index + 1) : "");
            }
            return rawServicePath + String.valueOf(index > 0 ? Integer.valueOf(index + 1) : "");
        }
        return label;
    }

    private String getServicePath(NodeList<Node> serviceNameNodes) {
        StringBuilder servicePathBuilder = new StringBuilder();
        for (Node serviceNameNode : serviceNameNodes) {
            servicePathBuilder.append(serviceNameNode.toString().replace("\"", ""));
        }
        return servicePathBuilder.toString().startsWith("/") ? servicePathBuilder.substring(1).trim() : servicePathBuilder.toString().trim();
    }

    private int getServicePathIndex(String servicePath) {
        List filteredServicePaths = this.servicePaths.stream().filter(path -> path.equals(servicePath)).collect(Collectors.toList());
        return filteredServicePaths.size();
    }

    public void visit(ImportDeclarationNode importDeclarationNode) {
    }

    public void visit(EnumDeclarationNode enumDeclarationNode) {
    }

    public void visit(FunctionDefinitionNode functionDefinitionNode) {
    }

    public void visit(TypeDefinitionNode typeDefinitionNode) {
    }

    public void visit(VariableDeclarationNode variableDeclarationNode) {
    }

    public void visit(ClassDefinitionNode classDefinitionNode) {
    }
}

