/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.artifactsgenerator;

import io.ballerina.artifactsgenerator.Artifact;
import io.ballerina.artifactsgenerator.ArtifactsCache;
import io.ballerina.artifactsgenerator.ModuleNodeTransformer;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.projects.Document;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class ArtifactsGenerator {
    private static final String ADDITIONS = "additions";
    private static final String UPDATES = "updates";
    private static final String DELETIONS = "deletions";

    public static Map<String, Map<String, Map<String, Artifact>>> artifactChanges(String projectPath, SyntaxTree syntaxTree, SemanticModel semanticModel) {
        if (!syntaxTree.containsModulePart()) {
            return Map.of();
        }
        HashMap<String, List<String>> prevIdMap = new HashMap<String, List<String>>(ArtifactsCache.getInstance().getArtifactIds(projectPath, syntaxTree.filePath()));
        HashMap<String, List<String>> newIdMap = new HashMap<String, List<String>>();
        HashMap<String, Map<String, Map<String, Artifact>>> categoryMap = new HashMap<String, Map<String, Map<String, Artifact>>>();
        ModulePartNode rootNode = (ModulePartNode)syntaxTree.rootNode();
        ModuleNodeTransformer moduleNodeTransformer = new ModuleNodeTransformer(semanticModel);
        rootNode.members().stream().map(member -> (Optional)member.apply((NodeTransformer)moduleNodeTransformer)).flatMap(Optional::stream).forEach(artifact -> {
            String category = Artifact.getCategory(artifact.type());
            String artifactId = artifact.id();
            List prevIds = (List)prevIdMap.get(category);
            String eventType = prevIds != null && prevIds.remove(artifactId) ? UPDATES : ADDITIONS;
            categoryMap.computeIfAbsent(category, k -> new HashMap()).computeIfAbsent(eventType, k -> new HashMap()).put(artifactId, artifact);
            newIdMap.computeIfAbsent(category, k -> new ArrayList()).add(artifactId);
        });
        prevIdMap.forEach((category, remainingIds) -> {
            if (!remainingIds.isEmpty()) {
                remainingIds.forEach(id -> categoryMap.computeIfAbsent((String)category, k -> new HashMap()).computeIfAbsent(DELETIONS, k -> new HashMap()).put(id, Artifact.emptyArtifact(id)));
            }
        });
        ArtifactsCache.getInstance().updateArtifactIds(projectPath, syntaxTree.filePath(), newIdMap);
        return categoryMap;
    }

    public static Map<String, Map<String, Artifact>> artifacts(Project project) {
        Package currentPackage = project.currentPackage();
        Module defaultModule = currentPackage.getDefaultModule();
        SemanticModel semanticModel = PackageUtil.getCompilation((Package)currentPackage).getSemanticModel(defaultModule.moduleId());
        ConcurrentHashMap<String, Map<String, Artifact>> artifactMap = new ConcurrentHashMap<String, Map<String, Artifact>>();
        ConcurrentHashMap<String, Map<String, List<String>>> documentMap = new ConcurrentHashMap<String, Map<String, List<String>>>();
        ((Stream)defaultModule.documentIds().stream().parallel()).forEach(documentId -> {
            Document document = defaultModule.document(documentId);
            HashMap idMap = new HashMap();
            SyntaxTree syntaxTree = document.syntaxTree();
            ModulePartNode rootNode = (ModulePartNode)syntaxTree.rootNode();
            ModuleNodeTransformer moduleNodeTransformer = new ModuleNodeTransformer(semanticModel);
            rootNode.members().stream().map(member -> (Optional)member.apply((NodeTransformer)moduleNodeTransformer)).flatMap(Optional::stream).forEach(artifact -> {
                String category = Artifact.getCategory(artifact.type());
                String artifactId = artifact.id();
                artifactMap.computeIfAbsent(category, k -> new HashMap()).put(artifactId, artifact);
                idMap.computeIfAbsent(category, k -> new ArrayList()).add(artifactId);
            });
            documentMap.put(document.name(), idMap);
        });
        ArtifactsCache.getInstance().initializeProject(project.sourceRoot().toString(), documentMap);
        return artifactMap;
    }
}

