/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.artifactsgenerator;

import io.ballerina.artifactsgenerator.Artifact;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.ExpressionFunctionBodyNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.modelgenerator.commons.CommonUtils;
import java.util.Optional;
import java.util.stream.Collectors;

public class ModuleNodeTransformer
extends NodeTransformer<Optional<Artifact>> {
    private final SemanticModel semanticModel;
    private static final String AUTOMATION_FUNCTION_NAME = "automation";
    private static final String MAIN_FUNCTION_NAME = "main";

    public ModuleNodeTransformer(SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
    }

    public Optional<Artifact> transform(FunctionDefinitionNode functionDefinitionNode) {
        Artifact.Builder functionBuilder = new Artifact.Builder((Node)functionDefinitionNode);
        String functionName = functionDefinitionNode.functionName().text();
        if (functionName.equals(MAIN_FUNCTION_NAME)) {
            functionBuilder.name(AUTOMATION_FUNCTION_NAME).type(Artifact.Type.AUTOMATION);
        } else if (functionDefinitionNode.functionBody().kind() == SyntaxKind.EXPRESSION_FUNCTION_BODY) {
            if (this.isNaturalExpressionBody((ExpressionFunctionBodyNode)functionDefinitionNode.functionBody())) {
                functionBuilder.name(functionName).type(Artifact.Type.NP_FUNCTION);
            } else {
                functionBuilder.name(functionName).type(Artifact.Type.DATA_MAPPER);
            }
        } else if (functionDefinitionNode.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) {
            functionBuilder.accessor(functionName).name(ModuleNodeTransformer.getPathString((NodeList<Node>)functionDefinitionNode.relativeResourcePath())).type(Artifact.Type.RESOURCE);
        } else if (ModuleNodeTransformer.hasQualifier((NodeList<Token>)functionDefinitionNode.qualifierList(), SyntaxKind.REMOTE_KEYWORD)) {
            functionBuilder.name(functionName).type(Artifact.Type.REMOTE);
        } else {
            functionBuilder.name(functionName).type(Artifact.Type.FUNCTION);
        }
        return Optional.of(functionBuilder.build());
    }

    public Optional<Artifact> transform(ServiceDeclarationNode serviceDeclarationNode) {
        ExpressionNode firstExpression;
        Artifact.Builder serviceBuilder = new Artifact.Builder((Node)serviceDeclarationNode).locationId();
        SeparatedNodeList expressions = serviceDeclarationNode.expressions();
        if (!expressions.isEmpty()) {
            firstExpression = (ExpressionNode)expressions.get(0);
            this.setIcon(serviceBuilder, (Node)firstExpression);
        } else {
            firstExpression = null;
        }
        Optional typeDescriptorNode = serviceDeclarationNode.typeDescriptor();
        NodeList resourcePaths = serviceDeclarationNode.absoluteResourcePath();
        if (typeDescriptorNode.isPresent()) {
            serviceBuilder.serviceName(((TypeDescriptorNode)typeDescriptorNode.get()).toSourceCode().strip());
        } else if (!resourcePaths.isEmpty()) {
            serviceBuilder.serviceNameWithPath(ModuleNodeTransformer.getPathString((NodeList<Node>)resourcePaths));
        } else if (firstExpression != null) {
            serviceBuilder.serviceName(firstExpression.toSourceCode().strip());
        } else {
            serviceBuilder.name("");
        }
        serviceBuilder.type(Artifact.Type.SERVICE);
        serviceDeclarationNode.members().forEach(member -> ((Optional)member.apply((NodeTransformer)this)).ifPresent(serviceBuilder::child));
        return Optional.of(serviceBuilder.build());
    }

    public Optional<Artifact> transform(ListenerDeclarationNode listenerDeclarationNode) {
        Artifact.Builder listenerBuilder = new Artifact.Builder((Node)listenerDeclarationNode).name(listenerDeclarationNode.variableName().text()).type(Artifact.Type.LISTENER);
        listenerDeclarationNode.typeDescriptor().flatMap(arg_0 -> ((SemanticModel)this.semanticModel).symbol(arg_0)).ifPresent(listenerBuilder::icon);
        return Optional.of(listenerBuilder.build());
    }

    public Optional<Artifact> transform(ModuleVariableDeclarationNode moduleVariableDeclarationNode) {
        Artifact.Builder variableBuilder = new Artifact.Builder((Node)moduleVariableDeclarationNode).name(CommonUtils.getVariableName((Node)moduleVariableDeclarationNode.typedBindingPattern().bindingPattern()));
        if (ModuleNodeTransformer.hasQualifier((NodeList<Token>)moduleVariableDeclarationNode.qualifiers(), SyntaxKind.CONFIGURABLE_KEYWORD)) {
            variableBuilder.type(Artifact.Type.CONFIGURABLE);
        } else {
            Optional<ClassSymbol> connection = this.getConnection((Node)moduleVariableDeclarationNode);
            if (connection.isPresent()) {
                variableBuilder.type(Artifact.Type.CONNECTION).icon((Symbol)connection.get());
            } else {
                variableBuilder.type(Artifact.Type.VARIABLE);
            }
        }
        return Optional.of(variableBuilder.build());
    }

    public Optional<Artifact> transform(TypeDefinitionNode typeDefinitionNode) {
        Artifact.Builder typeBuilder = new Artifact.Builder((Node)typeDefinitionNode).name(typeDefinitionNode.typeName().text()).type(Artifact.Type.TYPE);
        return Optional.of(typeBuilder.build());
    }

    public Optional<Artifact> transform(EnumDeclarationNode enumDeclarationNode) {
        Artifact.Builder typeBuilder = new Artifact.Builder((Node)enumDeclarationNode).name(enumDeclarationNode.identifier().text()).type(Artifact.Type.TYPE);
        return Optional.of(typeBuilder.build());
    }

    public Optional<Artifact> transform(ClassDefinitionNode classDefinitionNode) {
        Artifact.Builder typeBuilder = new Artifact.Builder((Node)classDefinitionNode).name(classDefinitionNode.className().text()).type(Artifact.Type.TYPE);
        return Optional.of(typeBuilder.build());
    }

    protected Optional<Artifact> transformSyntaxNode(Node node) {
        return Optional.empty();
    }

    private void setIcon(Artifact.Builder builder, Node node) {
        Optional typeSymbol = this.semanticModel.typeOf(node);
        if (typeSymbol.isEmpty()) {
            return;
        }
        if (((TypeSymbol)typeSymbol.get()).typeKind() == TypeDescKind.UNION) {
            UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol.get();
            Optional<TypeSymbol> listenerSymbol = unionTypeSymbol.memberTypeDescriptors().stream().filter(member -> !member.subtypeOf(this.semanticModel.types().ERROR)).findFirst();
            listenerSymbol.ifPresent(builder::icon);
            return;
        }
        builder.icon((Symbol)typeSymbol.get());
    }

    private Optional<ClassSymbol> getConnection(Node node) {
        try {
            Symbol symbol = (Symbol)this.semanticModel.symbol(node).orElseThrow();
            TypeReferenceTypeSymbol typeDescriptorSymbol = (TypeReferenceTypeSymbol)((VariableSymbol)symbol).typeDescriptor();
            ClassSymbol classSymbol = (ClassSymbol)typeDescriptorSymbol.typeDescriptor();
            if (classSymbol.qualifiers().contains(Qualifier.CLIENT)) {
                return Optional.of(classSymbol);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Optional.empty();
    }

    private static String getPathString(NodeList<Node> nodes) {
        return nodes.stream().map(node -> node.toString().trim()).collect(Collectors.joining());
    }

    private static boolean hasQualifier(NodeList<Token> qualifierList, SyntaxKind kind) {
        return qualifierList.stream().anyMatch(qualifier -> qualifier.kind() == kind);
    }

    private boolean isNaturalExpressionBody(ExpressionFunctionBodyNode expressionFunctionBodyNode) {
        return expressionFunctionBodyNode.expression().kind() == SyntaxKind.NATURAL_EXPRESSION;
    }
}

