/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.udp;

import io.ballerina.stdlib.udp.UdpClient;
import io.ballerina.stdlib.udp.UdpListener;
import io.ballerina.stdlib.udp.UdpService;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;

public class UdpFactory {
    private static volatile UdpFactory udpFactory = new UdpFactory();
    private EventLoopGroup group = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2);

    private UdpFactory() {
    }

    public static UdpFactory getInstance() {
        return udpFactory;
    }

    public UdpClient createUdpClient(InetSocketAddress localAddress, InetSocketAddress remoteAddress, CompletableFuture<Object> balFuture) {
        return new UdpClient(localAddress, remoteAddress, UdpFactory.getInstance().group, balFuture);
    }

    public UdpClient createUdpClient(InetSocketAddress localAddress, CompletableFuture<Object> balFuture) {
        return new UdpClient(localAddress, UdpFactory.getInstance().group, balFuture);
    }

    public UdpListener createUdpListener(InetSocketAddress localAddress, InetSocketAddress remoteAddress, CompletableFuture<Object> balFuture, UdpService udpService) {
        return new UdpListener(localAddress, remoteAddress, UdpFactory.getInstance().group, balFuture, udpService);
    }
}

