/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.udp.nativeclient;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.udp.UdpClient;
import io.ballerina.stdlib.udp.UdpFactory;
import io.ballerina.stdlib.udp.Utils;
import io.netty.buffer.Unpooled;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;

public final class ConnectClient {
    private ConnectClient() {
    }

    public static Object init(Environment env, BObject client, BString remoteHost, int remotePort, BMap<BString, Object> config) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            InetSocketAddress localAddress = Utils.getLocalInetSocketAddress(client, config);
            InetSocketAddress remoteAddress = new InetSocketAddress(remoteHost.getValue(), remotePort);
            client.addNativeData("remoteAddress", (Object)remoteAddress);
            UdpClient udpClient = UdpFactory.getInstance().createUdpClient(localAddress, remoteAddress, balFuture);
            client.addNativeData("connectClient", (Object)udpClient);
            return Utils.getResult(balFuture);
        });
    }

    public static Object read(Environment env, BObject client) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            double readTimeOut = (Double)client.getNativeData("timeout");
            UdpClient udpClient = (UdpClient)client.getNativeData("connectClient");
            udpClient.receiveData(readTimeOut, balFuture);
            return Utils.getResult(balFuture);
        });
    }

    public static Object write(Environment env, BObject client, BArray data) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            byte[] byteContent = data.getBytes();
            InetSocketAddress remoteAddress = (InetSocketAddress)client.getNativeData("remoteAddress");
            DatagramPacket datagramPacket = new DatagramPacket(Unpooled.wrappedBuffer((byte[])byteContent), remoteAddress);
            UdpClient udpClient = (UdpClient)client.getNativeData("connectClient");
            udpClient.sendData(datagramPacket, balFuture);
            return null;
        });
    }

    public static Object close(Environment env, BObject client) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            UdpClient udpClient = (UdpClient)client.getNativeData("connectClient");
            udpClient.close(balFuture);
            return Utils.getResult(balFuture);
        });
    }
}

