/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.compiler;

import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.plugins.GeneratorTask;
import io.ballerina.projects.plugins.SourceGeneratorContext;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.ballerinalang.testerina.compiler.TestFunctionVisitor;
import org.ballerinalang.testerina.compiler.TesterinaCompilerPluginUtils;

public class TestExecutionGenerationTask
implements GeneratorTask<SourceGeneratorContext> {
    public static final String BAL_EXTENSION = ".bal";

    public void generate(SourceGeneratorContext generatorContext) {
        TestExecutionGenerationTask.generateClassMockedFunctionMapping(generatorContext.currentPackage(), generatorContext);
        for (ModuleId moduleId : generatorContext.currentPackage().moduleIds()) {
            Module module = generatorContext.currentPackage().module(moduleId);
            if (module.testDocumentIds().isEmpty()) continue;
            TextDocument document = TestExecutionGenerationTask.generateDocument(module);
            generatorContext.addTestSourceFile(document, "test_execute", moduleId);
        }
    }

    private static TextDocument generateDocument(Module module) {
        ArrayList<ModuleMemberDeclarationNode> functionsList = new ArrayList<ModuleMemberDeclarationNode>();
        ArrayList<StatementNode> statements = new ArrayList<StatementNode>();
        TesterinaCompilerPluginUtils.addExitCodeGlobalVariable(functionsList);
        TesterinaCompilerPluginUtils.addSetTestOptionsCall(statements);
        AtomicInteger testIndex = new AtomicInteger(0);
        AtomicInteger group = new AtomicInteger(0);
        ArrayList<StatementNode> registrarStatements = new ArrayList<StatementNode>();
        for (DocumentId documentId : module.testDocumentIds()) {
            Document document = module.document(documentId);
            Node node = document.syntaxTree().rootNode();
            TestFunctionVisitor testFunctionVisitor = new TestFunctionVisitor();
            node.accept((NodeVisitor)testFunctionVisitor);
            TesterinaCompilerPluginUtils.traverseTestRegistrars(testIndex, group, registrarStatements, functionsList, testFunctionVisitor, statements);
        }
        if (testIndex.get() > 0) {
            TesterinaCompilerPluginUtils.populateTestRegistrarStatements(group, registrarStatements, functionsList, statements);
        }
        TesterinaCompilerPluginUtils.addStartSuiteCall(statements);
        functionsList.add((ModuleMemberDeclarationNode)TesterinaCompilerPluginUtils.createTestExecutionFunction(statements));
        ImportDeclarationNode testImport = NodeFactory.createImportDeclarationNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.IMPORT_KEYWORD, (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)" ")})), (ImportOrgNameNode)NodeFactory.createImportOrgNameNode((Token)NodeFactory.createIdentifierToken((String)"ballerina"), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SLASH_TOKEN)), (SeparatedNodeList)NodeFactory.createSeparatedNodeList((Node[])new Node[]{NodeFactory.createIdentifierToken((String)"test")}), null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN, (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)"\n")})));
        NodeList nodeList = NodeFactory.createNodeList(functionsList);
        Token eofToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.EOF_TOKEN, (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)"\n")}));
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode((NodeList)NodeFactory.createNodeList((Node[])new ImportDeclarationNode[]{testImport}), (NodeList)nodeList, (Token)eofToken);
        return TextDocuments.from((String)modulePartNode.toSourceCode());
    }

    private static void generateClassMockedFunctionMapping(Package pack, SourceGeneratorContext context) {
        HashMap testFileMockedFunctionMapping = new HashMap();
        for (ModuleId moduleId : pack.moduleIds()) {
            Document document;
            Module module = pack.module(moduleId);
            String moduleName = module.moduleName().toString();
            ArrayList<String> mockedFunctionList = new ArrayList<String>();
            for (DocumentId documentId : module.testDocumentIds()) {
                document = module.document(documentId);
                Node rootNode = document.syntaxTree().rootNode();
                TestFunctionVisitor testFunctionVisitor = new TestFunctionVisitor();
                rootNode.accept((NodeVisitor)testFunctionVisitor);
                for (FunctionDefinitionNode func : testFunctionVisitor.getTestStaticFunctions()) {
                    FunctionBodyNode functionBodyNode = func.functionBody();
                    NodeList statements = ((FunctionBodyBlockNode)functionBodyNode).statements();
                    for (int i = 0; i < statements.size(); ++i) {
                        ExpressionNode expressionStatement;
                        StatementNode statementNode = (StatementNode)statements.get(i);
                        if (statementNode.kind() != SyntaxKind.CALL_STATEMENT || (expressionStatement = ((ExpressionStatementNode)statementNode).expression()).kind() != SyntaxKind.METHOD_CALL) continue;
                        ExpressionNode methodCallExpression = ((MethodCallExpressionNode)expressionStatement).expression();
                        if (methodCallExpression.kind() == SyntaxKind.METHOD_CALL) {
                            methodCallExpression = ((MethodCallExpressionNode)methodCallExpression).expression();
                        }
                        if (methodCallExpression.kind() != SyntaxKind.FUNCTION_CALL) continue;
                        TestExecutionGenerationTask.gatherMockedFunctions(mockedFunctionList, expressionStatement, methodCallExpression);
                    }
                }
            }
            for (DocumentId documentId : module.testDocumentIds()) {
                document = module.document(documentId);
                String documentName = moduleName + "/" + document.name().replace(BAL_EXTENSION, "").replace("/", ".");
                Node rootNode = document.syntaxTree().rootNode();
                TestFunctionVisitor testFunctionVisitor = new TestFunctionVisitor();
                rootNode.accept((NodeVisitor)testFunctionVisitor);
                testFileMockedFunctionMapping.put((CallSite)((Object)documentName), new ArrayList());
                for (FunctionDefinitionNode func : testFunctionVisitor.getNormalFunctions()) {
                    if (!mockedFunctionList.contains(func.functionName().text())) continue;
                    ((List)testFileMockedFunctionMapping.get(documentName)).add(func.functionName().text());
                }
            }
        }
        Path cachePath = pack.project().targetDir().resolve("cache").resolve("tests_cache").resolve("native-config");
        TesterinaCompilerPluginUtils.writeCacheMapAsJson(testFileMockedFunctionMapping, cachePath, "mocked-func-class-map.json");
    }

    private static void gatherMockedFunctions(List<String> mockedFunctionList, ExpressionNode expressionStatement, ExpressionNode methodCallExpression) {
        MethodCallExpressionNode methodCallExpressionNode = (MethodCallExpressionNode)expressionStatement;
        FunctionCallExpressionNode functionCallExpressionNode = (FunctionCallExpressionNode)methodCallExpression;
        NameReferenceNode functionName = functionCallExpressionNode.functionName();
        if (functionName.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            String modulePrefix = ((QualifiedNameReferenceNode)functionName).modulePrefix().text();
            String identifier = ((QualifiedNameReferenceNode)functionName).identifier().text();
            String methodName = methodCallExpressionNode.methodName().toString().strip();
            if ("test".equals(modulePrefix) && "call".equals(methodName) && "when".equals(identifier)) {
                String mockedFunction = ((FunctionArgumentNode)methodCallExpressionNode.arguments().get(0)).toString().replace("\"", "");
                mockedFunctionList.add(mockedFunction);
            }
        }
    }
}

