/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.compiler;

import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class TestFunctionVisitor
extends NodeVisitor {
    static final List<String> TEST_STATIC_ANNOTATION_NAMES = List.of("Config", "BeforeSuite", "AfterSuite", "BeforeGroups", "AfterGroups", "BeforeEach", "AfterEach");
    static final String CONFIG_ANNOTATION = "Config";
    private static final String TEST_DYNAMIC_ANNOTATION_NAME = "Factory";
    private static final String TEST_MODULE_NAME = "test";
    private final List<FunctionDefinitionNode> testSetUpTearDownFunctions = new ArrayList<FunctionDefinitionNode>();
    private final List<FunctionDefinitionNode> testDynamicFunctions = new ArrayList<FunctionDefinitionNode>();
    private final List<FunctionDefinitionNode> testFunctions = new ArrayList<FunctionDefinitionNode>();
    private final List<FunctionDefinitionNode> normalFunctions = new ArrayList<FunctionDefinitionNode>();

    public void visit(ModulePartNode modulePartNode) {
        super.visit(modulePartNode);
    }

    public void visit(FunctionDefinitionNode functionDefinitionNode) {
        if (functionDefinitionNode.parent().kind() == SyntaxKind.CLASS_DEFINITION) {
            return;
        }
        Optional metadataNodeOptional = functionDefinitionNode.metadata();
        if (metadataNodeOptional.isPresent()) {
            MetadataNode metadataNode = (MetadataNode)metadataNodeOptional.get();
            for (AnnotationNode annotation : metadataNode.annotations()) {
                if (annotation.annotReference().kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) continue;
                QualifiedNameReferenceNode qualifiedNameReferenceNode = (QualifiedNameReferenceNode)annotation.annotReference();
                String modulePrefix = qualifiedNameReferenceNode.modulePrefix().text();
                String identifier = qualifiedNameReferenceNode.identifier().text();
                if (!TEST_MODULE_NAME.equals(modulePrefix)) continue;
                if (TEST_STATIC_ANNOTATION_NAMES.contains(identifier)) {
                    if (CONFIG_ANNOTATION.equals(identifier)) {
                        this.testFunctions.add(functionDefinitionNode);
                        continue;
                    }
                    this.testSetUpTearDownFunctions.add(functionDefinitionNode);
                    continue;
                }
                if (!TEST_DYNAMIC_ANNOTATION_NAME.equals(identifier)) continue;
                this.testDynamicFunctions.add(functionDefinitionNode);
            }
        } else {
            this.normalFunctions.add(functionDefinitionNode);
        }
    }

    public List<FunctionDefinitionNode> getTestStaticFunctions() {
        ArrayList<FunctionDefinitionNode> testStaticFunctions = new ArrayList<FunctionDefinitionNode>(this.testSetUpTearDownFunctions);
        testStaticFunctions.addAll(this.testFunctions);
        return testStaticFunctions;
    }

    public List<FunctionDefinitionNode> getNormalFunctions() {
        return this.normalFunctions;
    }

    public List<FunctionDefinitionNode> getTestDynamicFunctions() {
        return this.testDynamicFunctions;
    }
}

