/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.compiler;

import com.google.gson.Gson;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.projects.ProjectException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.testerina.compiler.TestFunctionVisitor;

public final class TesterinaCompilerPluginUtils {
    private TesterinaCompilerPluginUtils() {
    }

    public static void addSetTestOptionsCall(List<StatementNode> statements) {
        statements.add(TesterinaCompilerPluginUtils.getFunctionCallStatement((ExpressionNode)TesterinaCompilerPluginUtils.getTestFunctionCall("setTestOptions", TesterinaCompilerPluginUtils.getFunctionParamList(TesterinaCompilerPluginUtils.getPositionalArg("targetPath"), TesterinaCompilerPluginUtils.getPositionalArg("packageName"), TesterinaCompilerPluginUtils.getPositionalArg("moduleName"), TesterinaCompilerPluginUtils.getPositionalArg("report"), TesterinaCompilerPluginUtils.getPositionalArg("coverage"), TesterinaCompilerPluginUtils.getPositionalArg("groups"), TesterinaCompilerPluginUtils.getPositionalArg("disableGroups"), TesterinaCompilerPluginUtils.getPositionalArg("tests"), TesterinaCompilerPluginUtils.getPositionalArg("rerunFailed"), TesterinaCompilerPluginUtils.getPositionalArg("listGroups"), TesterinaCompilerPluginUtils.getPositionalArg("parallelExecution")))));
    }

    public static void addStartSuiteCall(List<StatementNode> statements) {
        statements.add(TesterinaCompilerPluginUtils.getAssignmentAndFunctionCallStatement((ExpressionNode)TesterinaCompilerPluginUtils.getTestFunctionCall("startSuite", (SeparatedNodeList<FunctionArgumentNode>)NodeFactory.createSeparatedNodeList(new ArrayList()))));
    }

    public static void addTestRegistrarCall(List<StatementNode> statements, int group) {
        statements.add(TesterinaCompilerPluginUtils.getFunctionCallStatement((ExpressionNode)NodeFactory.createFunctionCallExpressionNode((NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createIdentifierToken((String)("executeTestRegistrar" + group))), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)NodeFactory.createSeparatedNodeList(new ArrayList()), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN))));
    }

    public static void addExitCodeGlobalVariable(List<ModuleMemberDeclarationNode> globalVarDeclaration) {
        globalVarDeclaration.add(TesterinaCompilerPluginUtils.getExitCodeGlobalVarDclStatement());
    }

    public static FunctionDefinitionNode createTestExecutionFunction(List<StatementNode> statements) {
        FunctionBodyBlockNode functionBodyNode = NodeFactory.createFunctionBodyBlockNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN, (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)"\n")})), null, (NodeList)NodeFactory.createNodeList((Node[])statements.toArray(new StatementNode[0])), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.FUNCTION_DEFINITION, null, (NodeList)NodeFactory.createNodeList((Node[])new Token[]{NodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD, (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)" ")}))}), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD, (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)" ")})), (IdentifierToken)NodeFactory.createIdentifierToken((String)"__execute__", (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[0])), (NodeList)NodeFactory.createEmptyNodeList(), (FunctionSignatureNode)TesterinaCompilerPluginUtils.getFunctionSignature(), (FunctionBodyNode)functionBodyNode);
    }

    public static FunctionDefinitionNode createTestRegistrarFunction(List<StatementNode> statements, int group) {
        FunctionBodyBlockNode functionBodyNode = NodeFactory.createFunctionBodyBlockNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN, (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)"\n")})), null, (NodeList)NodeFactory.createNodeList((Node[])statements.toArray(new StatementNode[0])), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
        FunctionSignatureNode functionSignatureNode = NodeFactory.createFunctionSignatureNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)NodeFactory.createSeparatedNodeList((Node[])new Node[0]), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), null);
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.FUNCTION_DEFINITION, null, (NodeList)NodeFactory.createEmptyNodeList(), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD, (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)" ")})), (IdentifierToken)NodeFactory.createIdentifierToken((String)("executeTestRegistrar" + group), (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[0])), (NodeList)NodeFactory.createEmptyNodeList(), (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyNode);
    }

    public static StatementNode invokeRegisterFunction(String testNameVal, String testFuncVal) {
        PositionalArgumentNode testName = NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)NodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)("\"" + testNameVal + "\""), (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createEmptyMinutiaeList())));
        PositionalArgumentNode testFunction = NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createIdentifierToken((String)testFuncVal)));
        SeparatedNodeList<FunctionArgumentNode> separatedNodeList = TesterinaCompilerPluginUtils.getFunctionParamList(testName, testFunction);
        return TesterinaCompilerPluginUtils.getFunctionCallStatement((ExpressionNode)TesterinaCompilerPluginUtils.getTestFunctionCall("registerTest", separatedNodeList));
    }

    public static MethodCallExpressionNode getTestFunctionCall(String functionName, SeparatedNodeList<FunctionArgumentNode> nodeList) {
        SimpleNameReferenceNode functionRefNode = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createIdentifierToken((String)functionName));
        SimpleNameReferenceNode testRefNode = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createIdentifierToken((String)"test"));
        return NodeFactory.createMethodCallExpressionNode((ExpressionNode)testRefNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (NameReferenceNode)functionRefNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), nodeList, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
    }

    public static StatementNode getFunctionCallStatement(ExpressionNode expression) {
        return NodeFactory.createExpressionStatementNode((SyntaxKind)SyntaxKind.FUNCTION_CALL, (ExpressionNode)expression, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN, (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)"\n")})));
    }

    public static StatementNode getAssignmentAndFunctionCallStatement(ExpressionNode expression) {
        return NodeFactory.createAssignmentStatementNode((Node)NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createIdentifierToken((String)"__gH7W16nQmp0TestExecState__")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN, (MinutiaeList)TesterinaCompilerPluginUtils.singleWSML(), (MinutiaeList)TesterinaCompilerPluginUtils.singleWSML()), (ExpressionNode)expression, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN, (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)"\n")})));
    }

    public static ModuleMemberDeclarationNode getExitCodeGlobalVarDclStatement() {
        SimpleNameReferenceNode typeDescriptor = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createIdentifierToken((String)TypeKind.INT.typeName()));
        IdentifierToken varName = AbstractNodeFactory.createIdentifierToken((String)"__gH7W16nQmp0TestExecState__", (MinutiaeList)TesterinaCompilerPluginUtils.singleWSML(), (MinutiaeList)TesterinaCompilerPluginUtils.singleWSML());
        CaptureBindingPatternNode captureBindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)varName);
        Token publicKeyword = NodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD, (MinutiaeList)TesterinaCompilerPluginUtils.emptyML(), (MinutiaeList)TesterinaCompilerPluginUtils.singleWSML());
        Token equalsToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN, (MinutiaeList)TesterinaCompilerPluginUtils.emptyML(), (MinutiaeList)TesterinaCompilerPluginUtils.singleWSML());
        return NodeFactory.createModuleVariableDeclarationNode((MetadataNode)NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[0])), (Token)publicKeyword, (NodeList)NodeFactory.createEmptyNodeList(), (TypedBindingPatternNode)NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)typeDescriptor, (BindingPatternNode)captureBindingPattern), (Token)equalsToken, (ExpressionNode)NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.NUMERIC_LITERAL, (Token)NodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN, (String)"0", (MinutiaeList)TesterinaCompilerPluginUtils.emptyML(), (MinutiaeList)TesterinaCompilerPluginUtils.emptyML())), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN, (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)"\n")})));
    }

    public static SeparatedNodeList<FunctionArgumentNode> getFunctionParamList(PositionalArgumentNode ... args) {
        ArrayList<Object> nodeList = new ArrayList<Object>();
        for (PositionalArgumentNode arg : args) {
            nodeList.add(arg);
            nodeList.add(NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        if (args.length > 0) {
            nodeList.remove(nodeList.size() - 1);
        }
        return NodeFactory.createSeparatedNodeList(nodeList);
    }

    public static FunctionSignatureNode getFunctionSignature() {
        OptionalTypeDescriptorNode optionalErrorTypeDescriptorNode = NodeFactory.createOptionalTypeDescriptorNode((Node)NodeFactory.createParameterizedTypeDescriptorNode((SyntaxKind)SyntaxKind.ERROR_TYPE_DESC, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.ERROR_KEYWORD), null), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN, (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)" ")})));
        ReturnTypeDescriptorNode returnTypeDescriptorNode = NodeFactory.createReturnTypeDescriptorNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD, (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)" ")}), (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)" ")})), (NodeList)NodeFactory.createEmptyNodeList(), (Node)optionalErrorTypeDescriptorNode);
        return NodeFactory.createFunctionSignatureNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)NodeFactory.createSeparatedNodeList((Node[])new Node[]{TesterinaCompilerPluginUtils.getStringParameter("targetPath"), NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), TesterinaCompilerPluginUtils.getStringParameter("packageName"), NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), TesterinaCompilerPluginUtils.getStringParameter("moduleName"), NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), TesterinaCompilerPluginUtils.getStringParameter("report"), NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), TesterinaCompilerPluginUtils.getStringParameter("coverage"), NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), TesterinaCompilerPluginUtils.getStringParameter("groups"), NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), TesterinaCompilerPluginUtils.getStringParameter("disableGroups"), NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), TesterinaCompilerPluginUtils.getStringParameter("tests"), NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), TesterinaCompilerPluginUtils.getStringParameter("rerunFailed"), NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), TesterinaCompilerPluginUtils.getStringParameter("listGroups"), NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), TesterinaCompilerPluginUtils.getStringParameter("parallelExecution")}), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), (ReturnTypeDescriptorNode)returnTypeDescriptorNode);
    }

    public static void traverseTestRegistrars(AtomicInteger testIndex, AtomicInteger group, List<StatementNode> registrarStatements, List<ModuleMemberDeclarationNode> functionsList, TestFunctionVisitor testFunctionVisitor, List<StatementNode> statements) {
        for (FunctionDefinitionNode func : testFunctionVisitor.getTestStaticFunctions()) {
            registrarStatements.add(TesterinaCompilerPluginUtils.invokeRegisterFunction(func.functionName().toString(), func.functionName().toString()));
            testIndex.getAndIncrement();
            if (testIndex.get() < 150) continue;
            TesterinaCompilerPluginUtils.populateTestRegistrarStatements(group, registrarStatements, functionsList, statements);
            testIndex.set(0);
            group.incrementAndGet();
            registrarStatements.clear();
        }
    }

    public static void populateTestRegistrarStatements(AtomicInteger group, List<StatementNode> registrarStatements, List<ModuleMemberDeclarationNode> functionsList, List<StatementNode> statements) {
        functionsList.add((ModuleMemberDeclarationNode)TesterinaCompilerPluginUtils.createTestRegistrarFunction(registrarStatements, group.get()));
        TesterinaCompilerPluginUtils.addTestRegistrarCall(statements, group.get());
    }

    public static RequiredParameterNode getStringParameter(String varName) {
        return NodeFactory.createRequiredParameterNode((NodeList)NodeFactory.createEmptyNodeList(), (Node)NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD, (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)" ")}), (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)" ")}))), (Token)NodeFactory.createIdentifierToken((String)varName));
    }

    public static PositionalArgumentNode getPositionalArg(String argName) {
        return NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createIdentifierToken((String)argName)));
    }

    public static void writeCacheMapAsJson(Map<?, ?> map, Path path, String fileName) {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProjectException("couldn't create cache directories : " + e.toString());
            }
        }
        Path jsonFilePath = Path.of(path.toString(), fileName);
        File jsonFile = new File(jsonFilePath.toString());
        try (FileOutputStream fileOutputStream = new FileOutputStream(jsonFile);){
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
                Gson gson = new Gson();
                String json = gson.toJson(map);
                writer.write(new String(json.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new ProjectException("couldn't write cache data to the file : " + e.toString());
            }
        }
        catch (IOException e) {
            throw new ProjectException("couldn't write cache data to the file : " + e.toString());
        }
    }

    private static MinutiaeList singleWSML() {
        return TesterinaCompilerPluginUtils.emptyML().add(NodeFactory.createWhitespaceMinutiae((String)" "));
    }

    private static MinutiaeList emptyML() {
        return NodeFactory.createEmptyMinutiaeList();
    }
}

