/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.auth.ldap.utils;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.auth.ModuleUtils;
import io.ballerina.stdlib.auth.ldap.CommonLdapConfiguration;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LdapUtils.class);
    private static final ThreadLocal<String> socketFactoryName = new ThreadLocal();

    private LdapUtils() {
    }

    public static String getNameInSpaceForUsernameFromLDAP(String username, CommonLdapConfiguration ldapConfiguration, DirContext dirContext) throws NamingException {
        String userSearchFilter = ldapConfiguration.getUsernameSearchFilter();
        userSearchFilter = userSearchFilter.replace("?", LdapUtils.escapeSpecialCharactersForFilter(username));
        String searchBase = ldapConfiguration.getUserSearchBase();
        return LdapUtils.getNameInSpaceForUsername(username, searchBase, userSearchFilter, dirContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNameInSpaceForUsername(String username, String searchBase, String searchFilter, DirContext dirContext) throws NamingException {
        String userDN = null;
        NamingEnumeration<SearchResult> answer = null;
        try {
            String[] searchBases;
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            for (String base : searchBases = searchBase.split("#")) {
                SearchResult userObj;
                answer = dirContext.search(LdapUtils.escapeDNForSearch(base), searchFilter, searchCtls);
                if (!answer.hasMore() || (userObj = answer.next()) == null) continue;
                userDN = userObj.getNameInNamespace();
                break;
            }
            LOG.debug("Name in space for user '{}' is '{}'", (Object)username, userDN);
        }
        finally {
            LdapUtils.closeNamingEnumeration(answer);
        }
        return userDN;
    }

    public static Name escapeDNForSearch(String dn) throws InvalidNameException {
        return new CompositeName().add(dn);
    }

    public static void closeContext(DirContext dirContext) throws NamingException {
        if (dirContext != null) {
            dirContext.close();
        }
    }

    public static void closeNamingEnumeration(NamingEnumeration<?> namingEnumeration) throws NamingException {
        if (namingEnumeration != null) {
            namingEnumeration.close();
        }
    }

    private static String escapeSpecialCharactersForFilter(String dnPartial) {
        dnPartial = dnPartial.replace("\\*", "*");
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < dnPartial.length(); ++i) {
            char currentChar = dnPartial.charAt(i);
            switch (currentChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(currentChar);
                }
            }
        }
        return sb.toString();
    }

    public static boolean isLdapsUrl(String url) {
        return null != url && url.length() > 7 && url.substring(0, 8).equalsIgnoreCase("ldaps://");
    }

    public static String getInstanceIdFromThreadLocal() {
        String result = socketFactoryName.get();
        if (result == null) {
            throw LdapUtils.createError("Cannot infer the SSL context related to the service.");
        }
        return result;
    }

    public static void setServiceName(String serviceName) {
        socketFactoryName.set(serviceName);
    }

    public static void removeServiceName() {
        socketFactoryName.remove();
    }

    public static BError createError(String errMsg) {
        return ErrorCreator.createDistinctError((String)"Error", (Module)ModuleUtils.getModule(), (BString)StringUtils.fromString((String)errMsg));
    }
}

