/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.launcher.LauncherUtils;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.debugadapter.launcher.DebugAdapterLauncher;
import picocli.CommandLine;

@CommandLine.Command(name="start-debugger-adapter", description={"start Ballerina Debug adapter"})
public class DebugAdapterStartCmd
implements BLauncherCmd {
    private static final String CMD_NAME = "start-debugger-adapter";
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;

    public void execute() {
        try {
            ArrayList<String> debugLauncherArgs = new ArrayList<String>();
            if (this.argList != null && !this.argList.isEmpty()) {
                int debugServerPort = Integer.parseInt(this.argList.get(0));
                debugLauncherArgs.add(String.valueOf(debugServerPort));
            }
            DebugAdapterLauncher.main((String[])debugLauncherArgs.toArray(new String[0]));
        }
        catch (NumberFormatException e) {
            throw LauncherUtils.createLauncherException((String)("Failed to start debug adapter due to the invalid port specified: '" + this.argList.get(0) + "'"));
        }
        catch (Throwable e) {
            throw LauncherUtils.createLauncherException((String)("Failed to start debug adapter due to: " + e.getMessage()));
        }
    }

    public String getName() {
        return CMD_NAME;
    }

    public void printLongDesc(StringBuilder out) {
    }

    public void printUsage(StringBuilder out) {
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

