/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.parameter;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.model.OperationInventory;
import io.ballerina.openapi.service.mapper.parameter.AbstractParameterMapper;
import io.ballerina.openapi.service.mapper.type.TypeMapper;
import io.ballerina.openapi.service.mapper.type.UnionTypeMapper;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import java.util.Map;
import java.util.Objects;

public class QueryParameterMapper
extends AbstractParameterMapper {
    private TypeSymbol type = null;
    private String name = null;
    private boolean isRequired = false;
    private String description = null;
    private boolean treatNilableAsOptional = false;
    private Object defaultValue = null;
    private TypeMapper typeMapper = null;
    private SemanticModel semanticModel;

    public QueryParameterMapper(ParameterNode parameterNode, Map<String, String> apiDocs, OperationInventory operationInventory, boolean treatNilableAsOptional, AdditionalData additionalData, TypeMapper typeMapper) {
        super(operationInventory);
        Symbol parameterSymbol = additionalData.semanticModel().symbol((Node)parameterNode).orElse(null);
        if (Objects.nonNull(parameterSymbol) && parameterSymbol instanceof ParameterSymbol) {
            ParameterSymbol queryParameter = (ParameterSymbol)parameterSymbol;
            this.type = queryParameter.typeDescriptor();
            String paramName = MapperCommonUtils.unescapeIdentifier((String)queryParameter.getName().get());
            this.name = MapperCommonUtils.getQueryName(parameterNode, paramName);
            this.isRequired = queryParameter.paramKind().equals((Object)ParameterKind.REQUIRED);
            this.description = apiDocs.get(queryParameter.getName().get());
            this.treatNilableAsOptional = treatNilableAsOptional;
            this.semanticModel = additionalData.semanticModel();
            this.typeMapper = typeMapper;
            if (parameterNode instanceof DefaultableParameterNode) {
                DefaultableParameterNode defaultableQueryParam = (DefaultableParameterNode)parameterNode;
                this.defaultValue = AbstractParameterMapper.getDefaultValue(defaultableQueryParam, additionalData.semanticModel());
            }
        }
    }

    public QueryParameter getParameterSchema() {
        if (Objects.isNull(this.type)) {
            return null;
        }
        QueryParameter queryParameter = new QueryParameter();
        queryParameter.setName(this.name);
        if (!(!this.isRequired || this.treatNilableAsOptional && UnionTypeMapper.hasNilableType(this.type))) {
            queryParameter.setRequired(Boolean.valueOf(true));
        }
        Schema typeSchema = this.typeMapper.getTypeSchema(this.type);
        if (Objects.nonNull(this.defaultValue)) {
            TypeMapper.setDefaultValue(typeSchema, this.defaultValue);
        }
        if (AbstractParameterMapper.hasObjectType(this.semanticModel, this.type)) {
            Content content = new Content();
            content.put((Object)"application/json", (Object)new MediaType().schema(typeSchema));
            queryParameter.setContent(content);
        } else {
            queryParameter.setSchema(typeSchema);
        }
        queryParameter.setDescription(this.description);
        return queryParameter;
    }
}

