/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websub.task.service.path;

import io.ballerina.projects.DocumentId;
import io.ballerina.projects.ModuleId;
import io.ballerina.stdlib.websub.task.service.path.ServicePathContext;
import io.ballerina.stdlib.websub.task.service.path.ServicePathContextHandler;
import io.ballerina.stdlib.websub.task.service.path.ServicePathGenerator;
import io.ballerina.stdlib.websub.task.service.path.ServicePathGeneratorException;
import java.util.Random;

public abstract class AbstractServicePathGenerator
implements ServicePathGenerator {
    @Override
    public void generate(ModuleId moduleId, DocumentId documentId, int serviceId) throws ServicePathGeneratorException {
        try {
            String generatedServicePath = this.generateRandomAlphaNumericString(10);
            ServicePathContext.ServicePathInformation servicePathDetails = new ServicePathContext.ServicePathInformation(serviceId, generatedServicePath);
            ServicePathContextHandler.getContextHandler().updateServicePathContext(moduleId, documentId, servicePathDetails);
        }
        catch (Exception ex) {
            String errorMsg = String.format("service path generation failed due to %s", ex.getLocalizedMessage());
            throw new ServicePathGeneratorException(errorMsg, ex);
        }
    }

    private String generateRandomAlphaNumericString(int stringLength) {
        int leftLimit = 48;
        int rightLimit = 122;
        Random random = new Random();
        return random.ints(leftLimit, rightLimit + 1).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(stringLength).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }
}

