/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websub.task.service.path;

import io.ballerina.projects.Project;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.websub.task.service.path.BalProjectServicePathGenerator;
import io.ballerina.stdlib.websub.task.service.path.ServicePathGenerator;
import io.ballerina.stdlib.websub.task.service.path.ServicePathGeneratorException;
import io.ballerina.stdlib.websub.task.service.path.SingleFileServicePathGenerator;
import java.util.List;

public final class ServicePathGeneratorManager {
    private final List<ServicePathGenerator> servicePathGenerators = List.of(new SingleFileServicePathGenerator(), new BalProjectServicePathGenerator());

    public void generate(SyntaxNodeAnalysisContext context, int serviceId) throws ServicePathGeneratorException {
        Project currentProject = context.currentPackage().project();
        for (ServicePathGenerator servicePathGenerator : this.servicePathGenerators) {
            if (!servicePathGenerator.isSupported(currentProject.kind())) continue;
            servicePathGenerator.generate(context.moduleId(), context.documentId(), serviceId);
            return;
        }
        throw new ServicePathGeneratorException("Valid service path generator not found");
    }
}

