/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket;

import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnection;
import io.ballerina.stdlib.websocket.Handler;
import io.ballerina.stdlib.websocket.ModuleUtils;
import io.ballerina.stdlib.websocket.WebSocketResourceCallback;
import io.ballerina.stdlib.websocket.WebSocketResourceDispatcher;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.actions.websocketconnector.WebSocketConnector;
import io.ballerina.stdlib.websocket.observability.WebSocketObservabilityUtil;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionInfo;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.util.Map;
import org.ballerinalang.langlib.value.ToJsonString;

public class ReturnStreamUnitCallBack
implements Handler {
    private final Runtime runtime;
    private final BObject bObject;
    private final WebSocketConnectionInfo connectionInfo;
    private final WebSocketConnection webSocketConnection;

    ReturnStreamUnitCallBack(BObject bObject, Runtime runtime, WebSocketConnectionInfo connectionInfo, WebSocketConnection webSocketConnection) {
        this.bObject = bObject;
        this.runtime = runtime;
        this.connectionInfo = connectionInfo;
        this.webSocketConnection = webSocketConnection;
    }

    @Override
    public void notifySuccess(Object response) {
        if (response != null) {
            PromiseCombiner promiseCombiner = new PromiseCombiner((EventExecutor)ImmediateEventExecutor.INSTANCE);
            if (response instanceof BError) {
                String content = ((BError)((Object)response)).getMessage();
                this.webSocketConnection.terminateConnection(1011, String.format("streaming failed: %s", content));
            } else {
                Object contentObj = ((BMap)response).get((Object)StringUtils.fromString((String)"value"));
                if (WebSocketResourceCallback.isCloseFrameRecord(contentObj)) {
                    WebSocketResourceCallback.sendCloseFrame(contentObj, this.connectionInfo);
                    return;
                }
                if (contentObj instanceof BString) {
                    BString bString = (BString)contentObj;
                    this.sendTextMessageStream(bString, promiseCombiner);
                } else {
                    this.sendTextMessageStream(ToJsonString.toJsonString((Object)contentObj), promiseCombiner);
                }
                Thread.startVirtualThread(() -> {
                    Map<String, Object> properties = ModuleUtils.getProperties("next");
                    StrandMetadata strandMetadata = new StrandMetadata(true, properties);
                    try {
                        Object result = this.runtime.callMethod(this.bObject, "next", strandMetadata, new Object[0]);
                        this.notifySuccess(result);
                    }
                    catch (BError bError) {
                        this.notifyFailure(bError);
                    }
                });
            }
        }
    }

    @Override
    public void notifyFailure(BError bError) {
        bError.printStackTrace();
        WebSocketUtil.closeDuringUnexpectedCondition(this.webSocketConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTextMessageStream(BString result, PromiseCombiner promiseCombiner) {
        block8: {
            ByteBuf byteBuf = null;
            ByteBuf lastSlice = null;
            try {
                int index;
                byteBuf = WebSocketConnector.fromText(result.getValue());
                int noBytes = byteBuf.readableBytes();
                int size = (Integer)this.connectionInfo.getWebSocketEndpoint().getNativeData("MAX_FRAME_SIZE");
                for (index = 0; index < noBytes - size; index += size) {
                    ByteBuf slice = null;
                    try {
                        slice = byteBuf.retainedSlice(index, size);
                        String chunk = slice.toString(CharsetUtil.UTF_8);
                        ChannelFuture future = this.connectionInfo.getWebSocketConnection().pushText(chunk, false);
                        promiseCombiner.add((Future)future);
                    }
                    catch (Throwable throwable) {
                        WebSocketConnector.release(slice);
                        throw throwable;
                    }
                    WebSocketConnector.release(slice);
                }
                lastSlice = byteBuf.retainedSlice(index, noBytes - index);
                String chunk = lastSlice.toString(CharsetUtil.UTF_8);
                ChannelFuture future = this.connectionInfo.getWebSocketConnection().pushText(chunk, true);
                promiseCombiner.add((Future)future);
                promiseCombiner.finish((Promise)this.connectionInfo.getWebSocketConnection().getChannel().newPromise().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                    if (channelFuture.isSuccess()) {
                        WebSocketObservabilityUtil.observeSend("text", this.connectionInfo);
                    } else {
                        WebSocketResourceDispatcher.dispatchOnError(this.connectionInfo, future.cause(), true);
                    }
                })));
                WebSocketConnector.release(byteBuf);
            }
            catch (IllegalAccessException | IllegalStateException e) {
                WebSocketResourceDispatcher.dispatchOnError(this.connectionInfo, e, true);
                break block8;
            }
            finally {
                WebSocketConnector.release(byteBuf);
                WebSocketConnector.release(lastSlice);
            }
            WebSocketConnector.release(lastSlice);
        }
    }
}

