/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket;

import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RemoteMethodType;
import io.ballerina.runtime.api.types.ResourceMethodType;
import io.ballerina.runtime.api.types.ServiceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.utils.XmlUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.stdlib.constraint.Constraints;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.ValueCreatorUtils;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketBinaryMessage;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketCloseMessage;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnection;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnectorException;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketControlMessage;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketControlSignal;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketHandshaker;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketTextMessage;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.transport.message.HttpCarbonRequest;
import io.ballerina.stdlib.http.uri.URIUtil;
import io.ballerina.stdlib.websocket.Handler;
import io.ballerina.stdlib.websocket.HeaderParam;
import io.ballerina.stdlib.websocket.ModuleUtils;
import io.ballerina.stdlib.websocket.QueryParam;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.WebSocketResourceCallback;
import io.ballerina.stdlib.websocket.WebSocketService;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.observability.WebSocketObservabilityUtil;
import io.ballerina.stdlib.websocket.observability.WebSocketObserverContext;
import io.ballerina.stdlib.websocket.server.OnUpgradeResourceCallback;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionInfo;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionManager;
import io.ballerina.stdlib.websocket.server.WebSocketServerService;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langlib.value.CloneReadOnly;
import org.ballerinalang.langlib.value.FromJsonString;
import org.ballerinalang.langlib.value.FromJsonStringWithType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketResourceDispatcher {
    private static final Logger log = LoggerFactory.getLogger(WebSocketResourceDispatcher.class);
    public static final MapType MAP_TYPE = TypeCreator.createMapType((Type)PredefinedTypes.TYPE_JSON);

    private WebSocketResourceDispatcher() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dispatchUpgrade(WebSocketHandshaker webSocketHandshaker, WebSocketServerService wsService, WebSocketConnectionManager connectionManager) {
        ResourceMethodType resourceFunction = ((ServiceType)TypeUtils.getType((Object)wsService.getBalService())).getResourceMethods()[0];
        String[] resourcePath = resourceFunction.getResourcePath();
        List<String> resourceParams = Arrays.stream(resourcePath).map(value -> value.equals(".") || value.equals("^") ? value : HttpUtil.unescapeAndEncodeValue((String)value)).toList();
        BObject inRequest = ValueCreatorUtils.createRequestObject();
        BObject inRequestEntity = ValueCreatorUtils.createEntityObject();
        HttpCarbonRequest httpCarbonMessage = webSocketHandshaker.getHttpCarbonRequest();
        String errMsg = "No resource found for path " + httpCarbonMessage.getRequestUrl();
        String subPath = (String)httpCarbonMessage.getProperty("SUB_PATH");
        String[] subPaths = new String[]{};
        ArrayList<String> pathParamArr = new ArrayList<String>();
        if (!subPath.isEmpty()) {
            subPath = WebSocketResourceDispatcher.sanitizeSubPath(subPath).substring(1);
            subPaths = subPath.split("/");
        }
        if (!resourceParams.get(0).equals(".")) {
            if (resourceParams.size() != subPaths.length) {
                webSocketHandshaker.cancelHandshake(404, errMsg);
                return;
            }
            int i = 0;
            for (String resourceParam : resourceParams) {
                if (resourceParam.equals("^")) {
                    pathParamArr.add(subPaths[i]);
                } else if (!resourceParam.equals(subPaths[i])) {
                    webSocketHandshaker.cancelHandshake(404, errMsg);
                    return;
                }
                ++i;
            }
        }
        Parameter[] parameters = resourceFunction.getParameters();
        HashMap<String, Object> allHeaderParams = new HashMap<String, Object>();
        HashMap<String, QueryParam> allQueryParams = new HashMap<String, QueryParam>();
        int index = pathParamArr.size();
        while (true) {
            block43: {
                if (index < parameters.length) {
                    try {
                        paramName = resourceFunction.getParameters()[index].name;
                        String paramType = resourceFunction.getParameters()[index].type.getName();
                        annotations = (BMap)resourceFunction.getAnnotation(StringUtils.fromString((String)("$param$." + paramName)));
                        if (annotations == null && paramType.equals("Request")) break block43;
                        if (annotations != null) {
                            Object[] annotationsKeys;
                            var21_28 = annotationsKeys = annotations.getKeys();
                            var22_31 = var21_28.length;
                            break block44;
                        }
                        Type parameterType = resourceFunction.getParameters()[index].type;
                        WebSocketResourceDispatcher.validateQueryParam(index, resourceFunction, parameterType, allQueryParams);
                    }
                    catch (WebSocketConnectorException e) {
                        webSocketHandshaker.cancelHandshake(404, e.getMessage());
                    }
                } else {
                    Object headerParam;
                    block44: {
                        HttpUtil.populateInboundRequest((BObject)inRequest, (BObject)inRequestEntity, (HttpCarbonMessage)httpCarbonMessage);
                        Object[] bValues = new Object[parameters.length];
                        int index2 = 0;
                        int pathParamIndex = 0;
                        int paramIndex = 0;
                        try {
                            BMap<BString, Object> urlQueryParams = WebSocketResourceDispatcher.getQueryParams(httpCarbonMessage.getProperty("RAW_QUERY_STR"));
                            for (Parameter parameter : parameters) {
                                String typeName = parameter.type.getName();
                                String paramName = parameter.name;
                                if (allHeaderParams.get(paramName) != null) {
                                    String token;
                                    headerParam = (HeaderParam)allHeaderParams.get(paramName);
                                    HttpHeaders httpHeaders = httpCarbonMessage.getHeaders();
                                    List headerValues = httpHeaders.getAll(token = ((HeaderParam)headerParam).getHeaderName());
                                    if (headerValues.isEmpty()) {
                                        if (((HeaderParam)headerParam).isNilable()) {
                                            index2 = WebSocketResourceDispatcher.createBvaluesForNillable(bValues, index2);
                                            continue;
                                        }
                                        webSocketHandshaker.cancelHandshake(404, errMsg);
                                    }
                                    if (((HeaderParam)headerParam).getTypeTag() == 32) {
                                        String[] headerArray = headerValues.toArray(new String[0]);
                                        bValues[index2++] = StringUtils.fromStringArray((String[])headerArray);
                                    } else {
                                        bValues[index2++] = StringUtils.fromString((String)((String)headerValues.getFirst()));
                                    }
                                    ++paramIndex;
                                    continue;
                                }
                                if (pathParamArr.size() > paramIndex) {
                                    switch (typeName) {
                                        case "string": {
                                            bValues[index2++] = StringUtils.fromString((String)((String)pathParamArr.get(pathParamIndex++)));
                                            break;
                                        }
                                        case "int": {
                                            bValues[index2++] = Long.parseLong((String)pathParamArr.get(pathParamIndex++));
                                            break;
                                        }
                                        case "float": {
                                            bValues[index2++] = Double.parseDouble((String)pathParamArr.get(pathParamIndex++));
                                            break;
                                        }
                                        case "boolean": {
                                            bValues[index2++] = Boolean.parseBoolean((String)pathParamArr.get(pathParamIndex++));
                                            break;
                                        }
                                    }
                                } else if (typeName.equals("Request")) {
                                    bValues[index2++] = inRequest;
                                } else {
                                    Object queryValue = urlQueryParams.get((Object)StringUtils.fromString((String)paramName));
                                    QueryParam queryParam = (QueryParam)allQueryParams.get(paramName);
                                    BArray queryValueArr = (BArray)queryValue;
                                    Type qParamType = queryParam.getType();
                                    if (queryValue == null) {
                                        if (!queryParam.isNilable()) {
                                            WebSocketResourceDispatcher.reportQueryParamError(webSocketHandshaker, paramName);
                                            return;
                                        }
                                        index2 = WebSocketResourceDispatcher.createBvaluesForNillable(bValues, index2);
                                    } else {
                                        bValues[index2++] = qParamType.getTag() == 5 ? queryValueArr.getBString(0L) : FromJsonStringWithType.fromJsonStringWithType((BString)queryValueArr.getBString(0L), (BTypedesc)ValueCreator.createTypedescValue((Type)qParamType));
                                    }
                                }
                                ++paramIndex;
                            }
                        }
                        catch (WebSocketConnectorException | NumberFormatException e) {
                            webSocketHandshaker.cancelHandshake(404, errMsg);
                            return;
                        }
                        HashMap<String, HttpCarbonRequest> properties = new HashMap<String, HttpCarbonRequest>();
                        properties.put("INBOUND_MESSAGE", httpCarbonMessage);
                        BObject bObject = wsService.getBalService();
                        String function = resourceFunction.getName();
                        OnUpgradeResourceCallback handler = new OnUpgradeResourceCallback(webSocketHandshaker, wsService, connectionManager);
                        Thread.startVirtualThread(() -> {
                            StrandMetadata strandMetadata = new StrandMetadata(WebSocketResourceDispatcher.isIsolated(bObject, function), properties);
                            try {
                                Object result = wsService.getRuntime().callMethod(bObject, function, strandMetadata, bValues);
                                handler.notifySuccess(result);
                            }
                            catch (BError bError) {
                                handler.notifyFailure(bError);
                            }
                        });
                        return;
                    }
                    for (int i = 0; i < var22_31; ++i) {
                        Object object = var21_28[i];
                        String key = ((BString)object).getValue();
                        if (!key.contains(":Header")) continue;
                        Type parameterType = resourceFunction.getParameters()[index].type;
                        headerParam = new HeaderParam();
                        BMap mapValue = annotations.getMapValue(StringUtils.fromString((String)WebSocketConstants.BALLERINA_HTTP_HEADER));
                        Object headerName = mapValue.get((Object)HttpConstants.ANN_FIELD_NAME);
                        if (headerName instanceof BString) {
                            String value2 = ((BString)headerName).getValue();
                            ((HeaderParam)headerParam).setHeaderName(value2);
                        } else {
                            ((HeaderParam)headerParam).setHeaderName(paramName);
                        }
                        allHeaderParams.put(paramName, headerParam);
                        ((HeaderParam)headerParam).init(parameterType);
                    }
                }
            }
            ++index;
        }
    }

    private static int createBvaluesForNillable(Object[] bValues, int index) {
        bValues[index++] = null;
        return index;
    }

    private static void reportQueryParamError(WebSocketHandshaker webSocketHandshaker, String paramName) throws WebSocketConnectorException {
        webSocketHandshaker.cancelHandshake(400, String.format("No query param value found for: %s", paramName));
    }

    public static BMap<BString, Object> getQueryParams(Object rawQueryString) throws WebSocketConnectorException {
        BMap queryParams = ValueCreator.createMapValue((MapType)MAP_TYPE);
        if (rawQueryString != null) {
            try {
                URIUtil.populateQueryParamMap((String)((String)rawQueryString), (BMap)queryParams);
            }
            catch (UnsupportedEncodingException e) {
                throw new WebSocketConnectorException("Error while retrieving query param from message: " + e.getMessage());
            }
        }
        return queryParams;
    }

    private static String sanitizeSubPath(String subPath) {
        if ("/".equals(subPath)) {
            return subPath;
        }
        if (!((String)subPath).startsWith("/")) {
            subPath = "/" + (String)subPath;
        }
        subPath = ((String)subPath).endsWith("/") ? ((String)subPath).substring(0, ((String)subPath).length() - 1) : subPath;
        return subPath;
    }

    private static void validateQueryParam(int index, ResourceMethodType balResource, Type parameterType, Map<String, QueryParam> allQueryParams) throws WebSocketConnectorException {
        if (parameterType instanceof UnionType) {
            List memberTypes = ((UnionType)parameterType).getMemberTypes();
            int size = memberTypes.size();
            if (size > 2 || !parameterType.isNilable()) {
                throw new WebSocketConnectorException("Invalid query param type '" + parameterType.getName());
            }
            for (Type type : memberTypes) {
                if (type.getTag() == 14) continue;
                QueryParam queryParam = new QueryParam(type, true);
                allQueryParams.put(balResource.getParameters()[index].name, queryParam);
                break;
            }
        } else {
            QueryParam queryParam = new QueryParam(parameterType, false);
            allQueryParams.put(balResource.getParameters()[index].name, queryParam);
        }
    }

    public static void dispatchOnOpen(WebSocketConnection webSocketConnection, BObject webSocketCaller, WebSocketServerService wsService) {
        MethodType onOpenResource = null;
        Object dispatchingService = wsService.getWsService(webSocketConnection.getChannelId());
        MethodType[] remoteFunctions = ((ServiceType)((BValue)dispatchingService).getType()).getMethods();
        BObject balService = (BObject)dispatchingService;
        for (MethodType remoteFunc : remoteFunctions) {
            if (!remoteFunc.getName().equals("onOpen")) continue;
            onOpenResource = remoteFunc;
            break;
        }
        if (onOpenResource != null) {
            WebSocketResourceDispatcher.executeOnOpenResource(wsService, balService, onOpenResource, webSocketCaller, webSocketConnection);
        } else {
            webSocketConnection.readNextFrame();
        }
    }

    private static void executeOnOpenResource(WebSocketService wsService, BObject balService, MethodType onOpenResource, BObject webSocketEndpoint, WebSocketConnection webSocketConnection) {
        Parameter[] parameters = onOpenResource.getParameters();
        Object[] bValues = new Object[parameters.length];
        if (parameters.length > 0) {
            bValues[0] = webSocketEndpoint;
        }
        WebSocketConnectionInfo connectionInfo = new WebSocketConnectionInfo(wsService, webSocketConnection, webSocketEndpoint);
        try {
            WebSocketResourceDispatcher.executeResource(wsService, balService, new WebSocketResourceCallback(connectionInfo, "onOpen", wsService.getRuntime()), bValues, connectionInfo, "onOpen");
        }
        catch (IllegalAccessException e) {
            WebSocketObservabilityUtil.observeError(connectionInfo, "resource_invocation", "onOpen", e.getMessage());
        }
    }

    public static void dispatchOnText(WebSocketConnectionInfo connectionInfo, WebSocketTextMessage textMessage) {
        WebSocketObservabilityUtil.observeOnMessage("text", connectionInfo);
        try {
            WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
            WebSocketService wsService = connectionInfo.getService();
            WebSocketConnectionInfo.StringAggregator stringAggregator = connectionInfo.createIfNullAndGetStringAggregator();
            stringAggregator.appendAggregateString(textMessage.getText());
            boolean finalFragment = textMessage.isFinalFragment();
            if (!finalFragment) {
                webSocketConnection.readNextFrame();
                return;
            }
            String dispatchingKey = ((WebSocketServerService)wsService).getDispatchingKey();
            Optional<String> dispatchingValue = WebSocketResourceDispatcher.getDispatchingValue(dispatchingKey, stringAggregator);
            Optional<String> customRemoteMethodName = dispatchingValue.map(WebSocketResourceDispatcher::createCustomRemoteFunction);
            MethodType onTextMessageResource = null;
            BObject wsEndpoint = connectionInfo.getWebSocketEndpoint();
            Object dispatchingService = wsService.getWsService(connectionInfo.getWebSocketConnection().getChannelId());
            Map<String, RemoteMethodType> dispatchingFunctions = wsService.getDispatchingFunctions(connectionInfo.getWebSocketConnection().getChannelId());
            if (dispatchingValue.isPresent() && dispatchingFunctions.containsKey(dispatchingValue.get())) {
                onTextMessageResource = (MethodType)dispatchingFunctions.get(dispatchingValue.get());
            } else if (customRemoteMethodName.isPresent() && dispatchingFunctions.containsKey(customRemoteMethodName.get())) {
                onTextMessageResource = (MethodType)dispatchingFunctions.get(customRemoteMethodName.get());
            } else if (dispatchingFunctions.containsKey("onTextMessage")) {
                onTextMessageResource = (MethodType)dispatchingFunctions.get("onTextMessage");
            } else if (dispatchingFunctions.containsKey("onMessage")) {
                onTextMessageResource = (MethodType)dispatchingFunctions.get("onMessage");
            }
            boolean hasOnError = dispatchingFunctions.containsKey("onError");
            String errorMethodName = null;
            boolean hasOnCustomError = false;
            if (onTextMessageResource != null) {
                errorMethodName = onTextMessageResource.getName() + "Error";
                hasOnCustomError = dispatchingFunctions.containsKey(errorMethodName);
            } else if (customRemoteMethodName.isPresent()) {
                errorMethodName = customRemoteMethodName.get() + "Error";
                hasOnCustomError = dispatchingFunctions.containsKey(errorMethodName);
            }
            if (onTextMessageResource == null) {
                stringAggregator.resetAggregateString();
                webSocketConnection.readNextFrame();
                return;
            }
            boolean validationEnabled = (Boolean)wsService.getBalService().getNativeData("validation");
            Parameter[] parameters = onTextMessageResource.getParameters();
            Object[] bValues = new Object[parameters.length];
            int index = 0;
            try {
                for (Parameter param : parameters) {
                    Object validationResult;
                    Object bValue;
                    int typeTag = TypeUtils.getReferredType((Type)param.type).getTag();
                    boolean readOnly = false;
                    Type paramType = param.type;
                    if (typeTag == 34) {
                        List memberTypes = ((IntersectionType)param.type).getConstituentTypes();
                        if (WebSocketResourceDispatcher.invalidInputParams(webSocketConnection, param.type, memberTypes)) {
                            return;
                        }
                        readOnly = true;
                        for (Type type : memberTypes) {
                            if (type.getTag() == 51) continue;
                            paramType = type;
                            typeTag = type.getTag();
                            break;
                        }
                    }
                    if ((bValue = WebSocketResourceDispatcher.getBvaluesForTextMessage(paramType, typeTag, wsEndpoint, stringAggregator)) instanceof BError) {
                        BError bError = (BError)((Object)bValue);
                        WebSocketResourceDispatcher.handleError(connectionInfo, bError, hasOnCustomError, errorMethodName, hasOnError);
                        stringAggregator.resetAggregateString();
                        return;
                    }
                    if (readOnly) {
                        bValue = CloneReadOnly.cloneReadOnly((Object)bValue);
                    }
                    if (typeTag != 47 && validationEnabled && (validationResult = Constraints.validate((Object)bValue, (BTypedesc)ValueCreator.createTypedescValue((Type)paramType))) instanceof BError) {
                        BError validationErr = WebSocketUtil.createWebsocketErrorWithCause(String.format("data validation failed: %s", validationResult), WebSocketConstants.ErrorCode.PayloadValidationError, (BError)((Object)validationResult));
                        WebSocketResourceDispatcher.dispatchOnError(connectionInfo, validationErr, true);
                        stringAggregator.resetAggregateString();
                        return;
                    }
                    bValues[index++] = bValue;
                }
            }
            catch (BError error) {
                WebSocketResourceDispatcher.handleError(connectionInfo, error, hasOnCustomError, errorMethodName, hasOnError);
                stringAggregator.resetAggregateString();
                return;
            }
            WebSocketResourceDispatcher.executeResource(wsService, (BObject)dispatchingService, new WebSocketResourceCallback(connectionInfo, onTextMessageResource.getName(), wsService.getRuntime()), bValues, connectionInfo, onTextMessageResource.getName());
            stringAggregator.resetAggregateString();
        }
        catch (IllegalAccessException e) {
            WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "text", e.getMessage());
        }
    }

    private static Object getBvaluesForTextMessage(Type param, int typeTag, BObject wsEndpoint, WebSocketConnectionInfo.StringAggregator stringAggregator) {
        return switch (typeTag) {
            case 47 -> wsEndpoint;
            case 5 -> StringUtils.fromString((String)stringAggregator.getAggregateString());
            case 16 -> XmlUtils.parse((String)stringAggregator.getAggregateString());
            case 24 -> ValueUtils.convert((Object)JsonUtils.parse((String)stringAggregator.getAggregateString()), (Type)param);
            case 33 -> {
                if (WebSocketUtil.hasStringType(param)) {
                    yield ValueUtils.convert((Object)StringUtils.fromString((String)stringAggregator.getAggregateString()), (Type)param);
                }
            }
            default -> FromJsonStringWithType.fromJsonStringWithType((BString)StringUtils.fromString((String)stringAggregator.getAggregateString()), (BTypedesc)ValueCreator.createTypedescValue((Type)param));
        };
    }

    private static void handleError(WebSocketConnectionInfo connectionInfo, BError error, boolean hasOnCustomError, String errorMethodName, boolean hasOnError) throws IllegalAccessException {
        if (hasOnCustomError) {
            WebSocketResourceDispatcher.dispatchOnCustomError(connectionInfo, error, errorMethodName);
        } else {
            WebSocketResourceDispatcher.handleDataBindingError(connectionInfo, hasOnError, error);
        }
    }

    private static void handleDataBindingError(WebSocketConnectionInfo connectionInfo, boolean hasOnError, BError bValue) throws IllegalAccessException {
        if (hasOnError) {
            WebSocketResourceDispatcher.dispatchOnError(connectionInfo, bValue, true);
        } else {
            WebSocketResourceDispatcher.sendDataBindingError(connectionInfo.getWebSocketConnection(), bValue.getMessage());
        }
    }

    private static Optional<String> getDispatchingValue(String dispatchingKey, WebSocketConnectionInfo.StringAggregator stringAggregator) {
        return Optional.ofNullable(dispatchingKey).flatMap(key -> {
            try {
                String dispatchingValue = ((BMap)FromJsonString.fromJsonString((BString)StringUtils.fromString((String)stringAggregator.getAggregateString()))).getStringValue(StringUtils.fromString((String)dispatchingKey)).getValue();
                return Optional.of(dispatchingValue);
            }
            catch (RuntimeException e) {
                return Optional.empty();
            }
        });
    }

    public static String createCustomRemoteFunction(String dispatchingValue) {
        dispatchingValue = "on " + (String)dispatchingValue;
        StringBuilder builder = new StringBuilder();
        String[] words = ((String)dispatchingValue).split("[\\W_]+");
        for (int i = 0; i < words.length; ++i) {
            Object word = words[i];
            word = i == 0 ? (((String)word).isEmpty() ? word : ((String)word).toLowerCase(Locale.ENGLISH)) : (((String)word).isEmpty() ? word : Character.toUpperCase(((String)word).charAt(0)) + ((String)word).substring(1).toLowerCase(Locale.ENGLISH));
            builder.append((String)word);
        }
        return builder.toString();
    }

    private static void sendDataBindingError(WebSocketConnection webSocketConnection, String errorMessage) {
        if (((String)errorMessage).length() > 100) {
            errorMessage = ((String)errorMessage).substring(0, 80) + "...";
        }
        webSocketConnection.terminateConnection(1003, String.format("data binding failed: %s", errorMessage));
    }

    public static void dispatchOnBinary(WebSocketConnectionInfo connectionInfo, WebSocketBinaryMessage binaryMessage) {
        WebSocketObservabilityUtil.observeOnMessage("binary", connectionInfo);
        try {
            MethodType[] remoteFunctions;
            WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
            WebSocketService wsService = connectionInfo.getService();
            MethodType onBinaryMessageResource = null;
            Object dispatchingService = wsService.getWsService(connectionInfo.getWebSocketConnection().getChannelId());
            BObject balservice = (BObject)dispatchingService;
            for (MethodType remoteFunc2 : remoteFunctions = ((ServiceType)((BValue)dispatchingService).getType()).getMethods()) {
                String funcName = remoteFunc2.getName();
                if (!funcName.equals("onBinaryMessage") && !funcName.equals("onMessage")) continue;
                onBinaryMessageResource = remoteFunc2;
                break;
            }
            boolean hasOnError = Arrays.stream(remoteFunctions).anyMatch(remoteFunc -> remoteFunc.getName().equals("onError"));
            if (onBinaryMessageResource == null) {
                webSocketConnection.readNextFrame();
                return;
            }
            boolean finalFragment = binaryMessage.isFinalFragment();
            WebSocketConnectionInfo.ByteArrAggregator byteAggregator = connectionInfo.createIfNullAndGetByteArrAggregator();
            if (finalFragment) {
                byteAggregator.appendAggregateArr(binaryMessage.getByteArray());
                WebSocketResourceDispatcher.createBvaluesForBinary(onBinaryMessageResource, balservice, connectionInfo, byteAggregator.getAggregateByteArr(), webSocketConnection, wsService, hasOnError);
                byteAggregator.resetAggregateByteArr();
            } else {
                byteAggregator.appendAggregateArr(binaryMessage.getByteArray());
                webSocketConnection.readNextFrame();
            }
        }
        catch (IOException | IllegalAccessException e) {
            WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "binary", e.getMessage());
        }
    }

    public static void dispatchOnPingOnPong(WebSocketConnectionInfo connectionInfo, WebSocketControlMessage controlMessage, boolean server) {
        if (controlMessage.getControlSignal() == WebSocketControlSignal.PING) {
            WebSocketResourceDispatcher.dispatchOnPing(connectionInfo, controlMessage, server);
        } else if (controlMessage.getControlSignal() == WebSocketControlSignal.PONG) {
            WebSocketResourceDispatcher.dispatchOnPong(connectionInfo, controlMessage, server);
        }
    }

    private static void dispatchOnPing(WebSocketConnectionInfo connectionInfo, WebSocketControlMessage controlMessage, boolean server) {
        WebSocketObservabilityUtil.observeOnMessage("ping", connectionInfo);
        try {
            WebSocketService wsService = connectionInfo.getService();
            MethodType onPingMessageResource = null;
            BObject balservice = null;
            if (server) {
                MethodType[] remoteFunctions;
                Object dispatchingService = wsService.getWsService(connectionInfo.getWebSocketConnection().getChannelId());
                balservice = (BObject)dispatchingService;
                for (MethodType remoteFunc : remoteFunctions = ((ServiceType)((BValue)dispatchingService).getType()).getMethods()) {
                    if (!remoteFunc.getName().equals("onPing")) continue;
                    onPingMessageResource = remoteFunc;
                    break;
                }
            } else {
                balservice = wsService.getBalService();
                onPingMessageResource = wsService.getResourceByName("onPing");
            }
            if (onPingMessageResource == null) {
                WebSocketResourceDispatcher.pongAutomatically(controlMessage);
                return;
            }
            Parameter[] parameters = onPingMessageResource.getParameters();
            Object[] bValues = new Object[parameters.length];
            WebSocketResourceDispatcher.createBvaluesForBarray(connectionInfo.getWebSocketEndpoint(), parameters, bValues, controlMessage.getByteArray());
            WebSocketResourceDispatcher.executeResource(wsService, balservice, new WebSocketResourceCallback(connectionInfo, "onPing", wsService.getRuntime()), bValues, connectionInfo, "onPing");
        }
        catch (Exception e) {
            WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "ping", e.getMessage());
        }
    }

    private static void createBvaluesForBinary(MethodType onBinaryMessageResource, BObject balservice, WebSocketConnectionInfo connectionInfo, byte[] byteArray, WebSocketConnection webSocketConnection, WebSocketService wsService, boolean hasOnError) throws IllegalAccessException {
        BObject wsEndpoint = connectionInfo.getWebSocketEndpoint();
        boolean validationEnabled = (Boolean)wsService.getBalService().getNativeData("validation");
        Parameter[] parameters = onBinaryMessageResource.getParameters();
        Object[] bValues = new Object[parameters.length];
        int index = 0;
        try {
            for (Parameter param : parameters) {
                Object validationResult;
                int typeName = TypeUtils.getReferredType((Type)param.type).getTag();
                boolean readOnly = false;
                typeName = WebSocketResourceDispatcher.getTypeName(param.type, typeName);
                Type paramType = param.type;
                if (typeName == 34) {
                    List memberTypes = ((IntersectionType)param.type).getConstituentTypes();
                    if (WebSocketResourceDispatcher.invalidInputParams(webSocketConnection, param.type, memberTypes)) {
                        return;
                    }
                    readOnly = true;
                    for (Type type : memberTypes) {
                        if (type.getTag() == 51) continue;
                        paramType = type;
                        typeName = WebSocketResourceDispatcher.getTypeName(type, type.getTag());
                        break;
                    }
                }
                Object bValue = switch (typeName) {
                    case 47 -> wsEndpoint;
                    case 2 -> ValueCreator.createArrayValue((byte[])byteArray);
                    case 5 -> WebSocketUtil.getBString(byteArray);
                    case 16 -> XmlUtils.parse((BString)WebSocketUtil.getBString(byteArray));
                    case 24 -> ValueUtils.convert((Object)JsonUtils.parse((BString)WebSocketUtil.getBString(byteArray)), (Type)paramType);
                    case 33 -> {
                        if (WebSocketUtil.hasByteArrayType(paramType)) {
                            yield ValueUtils.convert((Object)ValueCreator.createArrayValue((byte[])byteArray), (Type)paramType);
                        }
                    }
                    default -> FromJsonStringWithType.fromJsonStringWithType((BString)WebSocketUtil.getBString(byteArray), (BTypedesc)ValueCreator.createTypedescValue((Type)paramType));
                };
                if (bValue instanceof BError) {
                    WebSocketResourceDispatcher.handleDataBindingError(connectionInfo, hasOnError, (BError)((Object)bValue));
                    return;
                }
                if (readOnly) {
                    bValue = CloneReadOnly.cloneReadOnly((Object)bValue);
                }
                if (typeName != 47 && validationEnabled && (validationResult = Constraints.validate((Object)bValue, (BTypedesc)ValueCreator.createTypedescValue((Type)paramType))) instanceof BError) {
                    BError validationErr = WebSocketUtil.createWebsocketErrorWithCause(String.format("data validation failed: %s", validationResult), WebSocketConstants.ErrorCode.PayloadValidationError, (BError)((Object)validationResult));
                    WebSocketResourceDispatcher.dispatchOnError(connectionInfo, validationErr, true);
                    return;
                }
                bValues[index++] = bValue;
            }
            WebSocketResourceDispatcher.executeResource(wsService, balservice, new WebSocketResourceCallback(connectionInfo, onBinaryMessageResource.getName(), wsService.getRuntime()), bValues, connectionInfo, onBinaryMessageResource.getName());
        }
        catch (BError | IllegalAccessException e) {
            if (e instanceof BError) {
                WebSocketResourceDispatcher.handleDataBindingError(connectionInfo, hasOnError, (BError)e);
                return;
            }
            WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "binary", e.getMessage());
        }
    }

    private static int getTypeName(Type param, int typeName) {
        if (typeName == 32 && param.toString().equals("byte[]")) {
            typeName = 2;
        }
        return typeName;
    }

    private static boolean invalidInputParams(WebSocketConnection webSocketConnection, Type param, List<Type> memberTypes) {
        if (memberTypes.size() > 2) {
            WebSocketResourceDispatcher.sendDataBindingError(webSocketConnection, "invalid param type '" + param.getName() + "': only readonly intersection is allowed");
            return true;
        }
        return false;
    }

    private static void createBvaluesForBarray(BObject wsEndpoint, Parameter[] parameters, Object[] bValues, byte[] byteArray) {
        int index = 0;
        block5: for (Parameter param : parameters) {
            int typeName = param.type.getTag();
            switch (typeName) {
                case 47: {
                    bValues[index++] = wsEndpoint;
                    continue block5;
                }
                case 32: {
                    bValues[index++] = ValueCreator.createArrayValue((byte[])byteArray);
                    continue block5;
                }
                case 34: {
                    bValues[index++] = ValueCreator.createReadonlyArrayValue((byte[])byteArray);
                    continue block5;
                }
            }
        }
    }

    private static void dispatchOnPong(WebSocketConnectionInfo connectionInfo, WebSocketControlMessage controlMessage, boolean server) {
        WebSocketObservabilityUtil.observeOnMessage("pong", connectionInfo);
        try {
            BObject balservice;
            WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
            WebSocketService wsService = connectionInfo.getService();
            MethodType onPongMessageResource = null;
            if (server) {
                MethodType[] remoteFunctions;
                Object dispatchingService = wsService.getWsService(connectionInfo.getWebSocketConnection().getChannelId());
                balservice = (BObject)dispatchingService;
                for (MethodType remoteFunc : remoteFunctions = ((ServiceType)((BValue)dispatchingService).getType()).getMethods()) {
                    if (!remoteFunc.getName().equals("onPong")) continue;
                    onPongMessageResource = remoteFunc;
                    break;
                }
            } else {
                balservice = wsService.getBalService();
                onPongMessageResource = wsService.getResourceByName("onPong");
            }
            if (onPongMessageResource == null) {
                webSocketConnection.readNextFrame();
                return;
            }
            Parameter[] paramDetails = onPongMessageResource.getParameters();
            Object[] bValues = new Object[paramDetails.length];
            WebSocketResourceDispatcher.createBvaluesForBarray(connectionInfo.getWebSocketEndpoint(), paramDetails, bValues, controlMessage.getByteArray());
            WebSocketResourceDispatcher.executeResource(wsService, balservice, new WebSocketResourceCallback(connectionInfo, "onPong", wsService.getRuntime()), bValues, connectionInfo, "onPong");
        }
        catch (Exception e) {
            WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "pong", e.getMessage());
        }
    }

    public static void dispatchOnClose(final WebSocketConnectionInfo connectionInfo, WebSocketCloseMessage closeMessage, boolean server) {
        WebSocketObservabilityUtil.observeOnMessage("close", connectionInfo);
        try {
            WebSocketUtil.setListenerOpenField(connectionInfo);
            final WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
            WebSocketService wsService = connectionInfo.getService();
            MethodType onCloseResource = null;
            final int closeCode = closeMessage.getCloseCode();
            String closeReason = closeMessage.getCloseReason();
            BObject balservice = null;
            if (server) {
                MethodType[] remoteFunctions;
                Object dispatchingService = wsService.getWsService(connectionInfo.getWebSocketConnection().getChannelId());
                balservice = (BObject)dispatchingService;
                for (MethodType remoteFunc : remoteFunctions = ((ServiceType)((BValue)dispatchingService).getType()).getMethods()) {
                    if (!remoteFunc.getName().equals("onClose")) continue;
                    onCloseResource = remoteFunc;
                    break;
                }
            } else {
                balservice = wsService.getBalService();
                onCloseResource = wsService.getResourceByName("onClose");
            }
            if (onCloseResource == null) {
                WebSocketResourceDispatcher.finishConnectionClosureIfOpen(webSocketConnection, closeCode, connectionInfo);
                return;
            }
            Parameter[] paramDetails = onCloseResource.getParameters();
            Object[] bValues = new Object[paramDetails.length];
            int index = 0;
            block8: for (Parameter param : paramDetails) {
                int typeName = param.type.getTag();
                switch (typeName) {
                    case 47: {
                        bValues[index++] = connectionInfo.getWebSocketEndpoint();
                        continue block8;
                    }
                    case 5: {
                        bValues[index++] = closeReason == null ? StringUtils.fromString((String)"") : StringUtils.fromString((String)closeReason);
                        continue block8;
                    }
                    case 1: {
                        bValues[index++] = closeCode;
                        continue block8;
                    }
                }
            }
            Handler onCloseCallback = new Handler(){

                @Override
                public void notifySuccess(Object result) {
                    WebSocketResourceDispatcher.finishConnectionClosureIfOpen(webSocketConnection, closeCode, connectionInfo);
                }

                @Override
                public void notifyFailure(BError error) {
                    error.printStackTrace();
                    WebSocketResourceDispatcher.finishConnectionClosureIfOpen(webSocketConnection, closeCode, connectionInfo);
                    WebSocketObservabilityUtil.observeError(connectionInfo, "resource_invocation", "onClose", error.getMessage());
                }
            };
            WebSocketResourceDispatcher.executeResource(wsService, balservice, onCloseCallback, bValues, connectionInfo, "onClose");
        }
        catch (Exception e) {
            WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "close", e.getMessage());
        }
    }

    public static void finishConnectionClosureIfOpen(WebSocketConnection webSocketConnection, int closeCode, WebSocketConnectionInfo connectionInfo) {
        if (webSocketConnection.isOpen()) {
            ChannelFuture finishFuture = closeCode == 1005 ? webSocketConnection.finishConnectionClosure() : webSocketConnection.finishConnectionClosure(closeCode, null);
            finishFuture.addListener(closeFuture -> WebSocketUtil.setListenerOpenField(connectionInfo));
        }
    }

    public static void dispatchOnError(WebSocketConnectionInfo connectionInfo, Throwable throwable, boolean server) {
        try {
            WebSocketUtil.setListenerOpenField(connectionInfo);
        }
        catch (IllegalAccessException e) {
            connectionInfo.getWebSocketEndpoint().set(WebSocketConstants.LISTENER_IS_OPEN_FIELD, (Object)false);
        }
        WebSocketService webSocketService = connectionInfo.getService();
        MethodType onErrorResource = null;
        if (WebSocketResourceDispatcher.isUnexpectedError(throwable)) {
            log.error("Unexpected error", throwable);
            WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "text", "Unexpected error");
        }
        BObject balservice = null;
        if (server) {
            try {
                Object dispatchingService = webSocketService.getWsService(connectionInfo.getWebSocketConnection().getChannelId());
                balservice = (BObject)dispatchingService;
                onErrorResource = WebSocketResourceDispatcher.getErrorMethod((BValue)dispatchingService, "onError");
            }
            catch (IllegalAccessException ex) {
                connectionInfo.getWebSocketEndpoint().set(WebSocketConstants.LISTENER_IS_OPEN_FIELD, (Object)false);
            }
        }
        if (onErrorResource == null) {
            ErrorCreator.createError((Throwable)throwable.getCause()).printStackTrace();
            return;
        }
        Parameter[] paramDetails = onErrorResource.getParameters();
        Object[] bValues = new Object[paramDetails.length];
        WebSocketResourceDispatcher.getErrorBValues(connectionInfo, throwable, paramDetails, bValues);
        Handler onErrorCallback = WebSocketResourceDispatcher.getOnErrorCallback(connectionInfo);
        WebSocketResourceDispatcher.executeResource(webSocketService, balservice, onErrorCallback, bValues, connectionInfo, "onError");
    }

    public static void dispatchOnCustomError(WebSocketConnectionInfo connectionInfo, Throwable throwable, String errorMethodName) {
        try {
            WebSocketUtil.setListenerOpenField(connectionInfo);
            WebSocketService webSocketService = connectionInfo.getService();
            Object dispatchingService = webSocketService.getWsService(connectionInfo.getWebSocketConnection().getChannelId());
            BObject balservice = (BObject)dispatchingService;
            MethodType onErrorRemoteFunction = WebSocketResourceDispatcher.getErrorMethod((BValue)dispatchingService, errorMethodName);
            Parameter[] paramDetails = onErrorRemoteFunction.getParameters();
            Object[] bValues = new Object[paramDetails.length];
            WebSocketResourceDispatcher.getErrorBValues(connectionInfo, throwable, paramDetails, bValues);
            Handler onErrorCallback = WebSocketResourceDispatcher.getOnErrorCallback(connectionInfo);
            WebSocketResourceDispatcher.executeResource(webSocketService, balservice, onErrorCallback, bValues, connectionInfo, errorMethodName);
        }
        catch (IllegalAccessException e) {
            connectionInfo.getWebSocketEndpoint().set(WebSocketConstants.LISTENER_IS_OPEN_FIELD, (Object)false);
        }
    }

    private static Handler getOnErrorCallback(final WebSocketConnectionInfo connectionInfo) {
        return new Handler(){

            @Override
            public void notifySuccess(Object result) {
                try {
                    WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
                    if (WebSocketResourceCallback.isCloseFrameRecord(result)) {
                        WebSocketResourceCallback.sendCloseFrame(result, connectionInfo);
                    } else if (webSocketConnection.isOpen()) {
                        webSocketConnection.readNextFrame();
                    }
                }
                catch (IllegalAccessException e) {
                    WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "text", e.getMessage());
                }
            }

            @Override
            public void notifyFailure(BError error) {
                error.printStackTrace();
                WebSocketObservabilityUtil.observeError(connectionInfo, "resource_invocation", "onError", error.getMessage());
            }
        };
    }

    private static void getErrorBValues(WebSocketConnectionInfo connectionInfo, Throwable throwable, Parameter[] paramDetails, Object[] bValues) {
        int index = 0;
        block4: for (Parameter param : paramDetails) {
            int typeName = param.type.getTag();
            switch (typeName) {
                case 47: {
                    bValues[index++] = connectionInfo.getWebSocketEndpoint();
                    continue block4;
                }
                case 42: {
                    bValues[index++] = WebSocketUtil.createErrorByType(throwable);
                    continue block4;
                }
            }
        }
    }

    private static MethodType getErrorMethod(BValue dispatchingService, String onErrorFunctionName) {
        MethodType[] remoteFunctions;
        for (MethodType remoteFunc : remoteFunctions = ((ServiceType)dispatchingService.getType()).getMethods()) {
            if (!remoteFunc.getName().equals(onErrorFunctionName)) continue;
            return remoteFunc;
        }
        return null;
    }

    private static boolean isUnexpectedError(Throwable throwable) {
        return !(throwable instanceof CorruptedFrameException);
    }

    public static void dispatchOnIdleTimeout(final WebSocketConnectionInfo connectionInfo) {
        try {
            MethodType[] remoteFunctions;
            final WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
            WebSocketService wsService = connectionInfo.getService();
            MethodType onIdleTimeoutResource = null;
            Object dispatchingService = wsService.getWsService(connectionInfo.getWebSocketConnection().getChannelId());
            BObject balservice = (BObject)dispatchingService;
            for (MethodType remoteFunc : remoteFunctions = ((ServiceType)((BValue)dispatchingService).getType()).getMethods()) {
                if (!remoteFunc.getName().equals("onIdleTimeout")) continue;
                onIdleTimeoutResource = remoteFunc;
                break;
            }
            if (onIdleTimeoutResource == null) {
                return;
            }
            Parameter[] paramDetails = onIdleTimeoutResource.getParameters();
            Object[] bValues = new Object[paramDetails.length];
            if (paramDetails.length > 0) {
                bValues[0] = connectionInfo.getWebSocketEndpoint();
            }
            Handler onIdleTimeoutCallback = new Handler(){

                @Override
                public void notifySuccess(Object result) {
                    if (WebSocketResourceCallback.isCloseFrameRecord(result)) {
                        WebSocketResourceCallback.sendCloseFrame(result, connectionInfo);
                    }
                }

                @Override
                public void notifyFailure(BError error) {
                    error.printStackTrace();
                    WebSocketUtil.closeDuringUnexpectedCondition(webSocketConnection);
                }
            };
            WebSocketResourceDispatcher.executeResource(wsService, balservice, onIdleTimeoutCallback, bValues, connectionInfo, "onIdleTimeout");
        }
        catch (Exception e) {
            log.error("Error on idle timeout", (Throwable)e);
            WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "text", e.getMessage());
        }
    }

    private static void pongAutomatically(WebSocketControlMessage controlMessage) {
        WebSocketConnection webSocketConnection = controlMessage.getWebSocketConnection();
        webSocketConnection.pong(controlMessage.getByteBuffer()).addListener(future -> {
            Throwable cause = future.cause();
            if (!future.isSuccess() && cause != null) {
                ErrorCreator.createError((Throwable)cause).printStackTrace();
            }
            webSocketConnection.readNextFrame();
        });
    }

    private static void executeResource(WebSocketService wsService, BObject balservice, Handler callback, Object[] bValues, WebSocketConnectionInfo connectionInfo, String resource) {
        Thread.startVirtualThread(() -> {
            try {
                Map<String, Object> properties = ModuleUtils.getProperties(resource);
                if (ObserveUtils.isTracingEnabled()) {
                    WebSocketObserverContext observerContext = new WebSocketObserverContext(connectionInfo);
                    properties.put("__observer_context__", (Object)observerContext);
                }
                StrandMetadata strandMetadata = new StrandMetadata(WebSocketResourceDispatcher.isIsolated(balservice, resource), properties);
                Object result = wsService.getRuntime().callMethod(balservice, resource, strandMetadata, bValues);
                callback.notifySuccess(result);
                WebSocketObservabilityUtil.observeResourceInvocation(connectionInfo, resource);
            }
            catch (BError bError) {
                callback.notifyFailure(bError);
            }
        });
    }

    private static boolean isIsolated(BObject serviceObj, String remoteMethod) {
        ObjectType serviceObjType = (ObjectType)TypeUtils.getReferredType((Type)serviceObj.getType());
        return serviceObjType.isIsolated() && serviceObjType.isIsolated(remoteMethod);
    }
}

