/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket;

import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.RemoteMethodType;
import io.ballerina.runtime.api.types.ServiceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.stdlib.websocket.ModuleUtils;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class WebSocketService {
    protected final BObject service;
    protected Runtime runtime;
    private final Map<String, MethodType> resourcesMap = new ConcurrentHashMap<String, MethodType>();
    private Map<String, Object> wsServices = new ConcurrentHashMap<String, Object>();
    private Map<String, Map<String, RemoteMethodType>> wsServicesDispatchingFunctions = new ConcurrentHashMap<String, Map<String, RemoteMethodType>>();

    public WebSocketService(Runtime runtime) {
        this.runtime = runtime;
        this.service = null;
    }

    public WebSocketService(BObject service, Runtime runtime) {
        this.runtime = runtime;
        this.service = service;
        this.populateResourcesMap(service);
    }

    private void populateResourcesMap(BObject service) {
        ObjectType serviceType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service));
        for (MethodType resource : serviceType.getMethods()) {
            this.resourcesMap.put(resource.getName(), resource);
        }
    }

    private Map<String, RemoteMethodType> getDispatchingFunctionMap(ServiceType dispatchingService) {
        ConcurrentHashMap<String, RemoteMethodType> dispatchingFunctions = new ConcurrentHashMap<String, RemoteMethodType>();
        for (MethodType method : dispatchingService.getMethods()) {
            if (!SymbolFlags.isFlagOn((long)method.getFlags(), (long)32768L)) continue;
            RemoteMethodType remoteMethodType = (RemoteMethodType)method;
            Optional<String> dispatchingValue = WebSocketService.getAnnotationDispatchingValue(remoteMethodType);
            if (dispatchingValue.isPresent()) {
                dispatchingFunctions.put(dispatchingValue.get(), remoteMethodType);
                continue;
            }
            dispatchingFunctions.put(remoteMethodType.getName(), remoteMethodType);
        }
        return dispatchingFunctions;
    }

    public static Optional<String> getAnnotationDispatchingValue(RemoteMethodType remoteFunc) {
        BMap annotations = (BMap)remoteFunc.getAnnotation(StringUtils.fromString((String)(ModuleUtils.getPackageIdentifier() + ":DispatcherConfig")));
        if (annotations != null && annotations.containsKey((Object)StringUtils.fromString((String)"dispatcherValue"))) {
            String dispatchingValue = annotations.getStringValue(StringUtils.fromString((String)"dispatcherValue")).getValue();
            return Optional.of(dispatchingValue);
        }
        return Optional.empty();
    }

    public MethodType getResourceByName(String resourceName) {
        return this.resourcesMap.get(resourceName);
    }

    public BObject getBalService() {
        return this.service;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public void addWsService(String channelId, Object dispatchingService) {
        this.wsServices.put(channelId, dispatchingService);
        this.wsServicesDispatchingFunctions.put(channelId, this.getDispatchingFunctionMap((ServiceType)((BValue)dispatchingService).getType()));
    }

    public Object getWsService(String key) {
        return this.wsServices.get(key);
    }

    public Map<String, RemoteMethodType> getDispatchingFunctions(String key) {
        return this.wsServicesDispatchingFunctions.get(key);
    }
}

