/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.contract.websocket.ClientHandshakeFuture;
import io.ballerina.stdlib.http.transport.contract.websocket.ClientHandshakeListener;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketClientConnector;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnection;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnectorListener;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.websocket.ModuleUtils;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.WebSocketException;
import io.ballerina.stdlib.websocket.WebSocketService;
import io.ballerina.stdlib.websocket.client.RetryContext;
import io.ballerina.stdlib.websocket.client.listener.RetryWebSocketClientHandshakeListener;
import io.ballerina.stdlib.websocket.client.listener.RetryWriteBinaryHandshakeListener;
import io.ballerina.stdlib.websocket.client.listener.RetryWriteTextHandshakeListener;
import io.ballerina.stdlib.websocket.client.listener.SyncClientConnectorListener;
import io.ballerina.stdlib.websocket.client.listener.WebSocketHandshakeListener;
import io.ballerina.stdlib.websocket.observability.WebSocketObservabilityUtil;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionInfo;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionManager;
import io.ballerina.stdlib.websocket.server.WebSocketServerService;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.websocketx.CorruptedWebSocketFrameException;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketUtil {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketUtil.class);
    private static final String WEBSOCKET_FAILOVER_CLIENT_NAME = "websocket:WebSocketFailoverClient";
    public static final String ERROR_MESSAGE = "Error occurred: ";

    public static BObject createAndPopulateWebSocketCaller(WebSocketConnection webSocketConnection, WebSocketServerService wsService, WebSocketConnectionManager connectionManager) {
        BObject webSocketCaller = ValueCreator.createObjectValue((Module)ModuleUtils.getWebsocketModule(), (String)"Caller", (Object[])new Object[]{StringUtils.fromString((String)""), null, null});
        webSocketCaller.addNativeData("MAX_FRAME_SIZE", (Object)wsService.getMaxFrameSize());
        WebSocketUtil.populatWebSocketEndpoint(webSocketConnection, webSocketCaller);
        webSocketCaller.set(WebSocketConstants.INITIALIZED_BY_SERVICE, (Object)true);
        WebSocketConnectionInfo connectionInfo = new WebSocketConnectionInfo(wsService, webSocketConnection, webSocketCaller);
        connectionManager.addConnection(webSocketConnection.getChannelId(), connectionInfo);
        webSocketCaller.addNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO", (Object)connectionInfo);
        WebSocketObservabilityUtil.observeConnection(connectionManager.getConnectionInfo(webSocketConnection.getChannelId()));
        return webSocketCaller;
    }

    public static void populatWebSocketEndpoint(WebSocketConnection webSocketConnection, BObject webSocketClient) {
        webSocketClient.addNativeData("id", (Object)webSocketConnection.getChannelId());
        webSocketClient.addNativeData("negotiatedSubProtocol", (Object)webSocketConnection.getNegotiatedSubProtocol());
        webSocketClient.addNativeData("secure", (Object)webSocketConnection.isSecure());
        webSocketClient.set(WebSocketConstants.LISTENER_IS_OPEN_FIELD, (Object)webSocketConnection.isOpen());
    }

    public static void handleWebSocketCallback(CompletableFuture<Object> balFuture, ChannelFuture webSocketChannelFuture, Logger log, WebSocketConnectionInfo connectionInfo, AtomicBoolean futureCompleted) {
        webSocketChannelFuture.addListener(future -> {
            Throwable cause = future.cause();
            if (!future.isSuccess() && cause != null) {
                log.error(ERROR_MESSAGE, cause);
                WebSocketUtil.setCallbackFunctionBehaviour(connectionInfo, balFuture, cause, futureCompleted);
            } else if (!futureCompleted.get()) {
                balFuture.complete(null);
                futureCompleted.set(true);
            }
        });
    }

    public static void handlePingWebSocketCallback(CompletableFuture<Object> balFuture, ChannelFuture webSocketChannelFuture, Logger log, WebSocketConnectionInfo connectionInfo, AtomicBoolean pingCallbackCompleted) {
        webSocketChannelFuture.addListener(future -> {
            Throwable cause = future.cause();
            if (!future.isSuccess() && cause != null) {
                log.error(ERROR_MESSAGE, cause);
                WebSocketUtil.setCallbackFunctionBehaviour(connectionInfo, balFuture, cause, pingCallbackCompleted);
            } else {
                if (!pingCallbackCompleted.get()) {
                    balFuture.complete(null);
                    pingCallbackCompleted.set(true);
                }
                if (TypeUtils.getType((Object)connectionInfo.getWebSocketEndpoint()).getName().equals("Client")) {
                    connectionInfo.getWebSocketConnection().readNextFrame();
                }
            }
        });
    }

    public static void setCallbackFunctionBehaviour(WebSocketConnectionInfo connectionInfo, CompletableFuture<Object> balFuture, Throwable error, AtomicBoolean futureCompleted) {
        if (!futureCompleted.get()) {
            balFuture.complete((Object)WebSocketUtil.createErrorByType(error));
            futureCompleted.set(true);
        }
    }

    public static void closeDuringUnexpectedCondition(WebSocketConnection webSocketConnection) {
        webSocketConnection.terminateConnection(1011, "Unexpected condition");
    }

    public static void setListenerOpenField(WebSocketConnectionInfo connectionInfo) throws IllegalAccessException {
        connectionInfo.getWebSocketEndpoint().set(WebSocketConstants.LISTENER_IS_OPEN_FIELD, (Object)connectionInfo.getWebSocketConnection().isOpen());
    }

    public static int findMaxFrameSize(BMap<BString, Object> configs) {
        long size = configs.getIntValue(WebSocketConstants.ANNOTATION_ATTR_MAX_FRAME_SIZE);
        if (size <= 0L) {
            return 65536;
        }
        try {
            return Math.toIntExact(size);
        }
        catch (ArithmeticException e) {
            logger.warn("The value set for maxFrameSize needs to be less than 2147483647. The maxFrameSize value is set to 2147483647");
            return Integer.MAX_VALUE;
        }
    }

    public static int findTimeoutInSeconds(BMap<BString, Object> config, BString key) {
        int timeout;
        String value = config.get((Object)key).toString();
        try {
            timeout = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw WebSocketUtil.createErrorByType(new Exception("Invalid timeout value: " + value));
        }
        if (timeout < 0 && timeout != -1) {
            throw WebSocketUtil.createErrorByType(new Exception("Invalid timeout value: " + value));
        }
        return timeout;
    }

    public static int findTimeoutInSeconds(BMap<BString, Object> config, BString key, int defaultValue) {
        try {
            int timeout = (int)((BDecimal)config.get((Object)key)).floatValue();
            if (timeout < 0) {
                return defaultValue;
            }
            return timeout;
        }
        catch (ArithmeticException e) {
            logger.warn("The value set for {} needs to be less than {} .The {} value is set to {} ", new Object[]{key, Integer.MAX_VALUE, key, Integer.MAX_VALUE});
            return Integer.MAX_VALUE;
        }
    }

    public static String[] findNegotiableSubProtocols(BMap<BString, Object> configs) {
        return configs.getArrayValue(WebSocketConstants.ANNOTATION_ATTR_SUB_PROTOCOLS).getStringArray();
    }

    static String getErrorMessage(Throwable err) {
        if (err.getMessage() == null) {
            return "Unexpected error occurred";
        }
        return err.getMessage();
    }

    public static BString getBString(byte[] byteArray) {
        return StringUtils.fromString((String)new String(byteArray, StandardCharsets.UTF_8));
    }

    public static boolean hasStringType(Type targetType) {
        if (targetType instanceof UnionType) {
            List memberTypes = ((UnionType)targetType).getMemberTypes();
            return memberTypes.stream().anyMatch(member -> member.getTag() == 5 | member.getTag() == 46);
        }
        return false;
    }

    public static boolean hasByteArrayType(Type targetType) {
        List memberTypes = ((UnionType)targetType).getMemberTypes();
        return memberTypes.stream().anyMatch(member -> member.getTag() == 32 && member.toString().equals("byte[]"));
    }

    public static BError createErrorByType(Throwable throwable) {
        if (throwable instanceof WebSocketException) {
            return ((WebSocketException)throwable).getWsError();
        }
        String errorCode = WebSocketConstants.ErrorCode.Error.errorCode();
        BError cause = null;
        String message = WebSocketUtil.getErrorMessage(throwable);
        if (throwable instanceof CorruptedWebSocketFrameException) {
            WebSocketCloseStatus status = ((CorruptedWebSocketFrameException)throwable).closeStatus();
            errorCode = status == WebSocketCloseStatus.MESSAGE_TOO_BIG ? WebSocketConstants.ErrorCode.PayloadTooLargeError.errorCode() : WebSocketConstants.ErrorCode.CorruptedFrameError.errorCode();
        } else if (throwable instanceof SSLException) {
            cause = WebSocketUtil.createErrorCause(throwable.getMessage(), WebSocketConstants.ErrorCode.SslError.errorCode(), ModuleUtils.getWebsocketModule());
        } else if (throwable instanceof IllegalStateException) {
            if (throwable.getMessage().toLowerCase(Locale.ENGLISH).contains("close frame")) {
                errorCode = WebSocketConstants.ErrorCode.ConnectionClosureError.errorCode();
            }
        } else if (throwable instanceof IllegalAccessException && throwable.getMessage().equals("WebSocket connection failure")) {
            errorCode = WebSocketConstants.ErrorCode.ConnectionError.errorCode();
            if (throwable.getMessage() == null) {
                message = "WebSocket connection failure";
            }
        } else if (throwable instanceof TooLongFrameException) {
            errorCode = WebSocketConstants.ErrorCode.PayloadTooLargeError.errorCode();
        } else if (throwable instanceof CodecException) {
            errorCode = WebSocketConstants.ErrorCode.CorruptedFrameError.errorCode();
        } else if (throwable instanceof WebSocketHandshakeException) {
            errorCode = WebSocketConstants.ErrorCode.InvalidHandshakeError.errorCode();
        } else if (throwable instanceof IOException) {
            errorCode = WebSocketConstants.ErrorCode.ConnectionError.errorCode();
            String errMessage = throwable.getMessage() != null ? throwable.getMessage() : "Connection Error";
            cause = WebSocketUtil.createErrorCause(errMessage, WebSocketConstants.ErrorCode.Error.errorCode(), ModuleUtils.getWebsocketModule());
            message = "IO Error";
        }
        return WebSocketUtil.getWebSocketError(message, null, errorCode, cause);
    }

    private static BError createErrorCause(String message, String errorIdName, Module packageName) {
        return ErrorCreator.createError((Module)packageName, (String)errorIdName, (BString)StringUtils.fromString((String)message), null, null);
    }

    public static Map<String, String> getCustomHeaders(BMap<BString, Object> headers) {
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        headers.entrySet().forEach(entry -> customHeaders.put(((BString)entry.getKey()).getValue(), headers.get(entry.getKey()).toString()));
        return customHeaders;
    }

    public static WebSocketService validateAndCreateWebSocketService(Runtime runtime, BObject callbackService) {
        if (callbackService != null) {
            ObjectType objectType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)callbackService));
            Type param = objectType.getMethods()[0].getParameters()[0].type;
            if (param == null || !"websocket:Caller".equals(param.toString()) && !WEBSOCKET_FAILOVER_CLIENT_NAME.equals(param.toString())) {
                throw WebSocketUtil.getWebSocketError("The callback service should be a PingPongService", null, WebSocketConstants.ErrorCode.Error.errorCode(), null);
            }
            return new WebSocketService(callbackService, runtime);
        }
        return new WebSocketService(runtime);
    }

    public static BError getWebSocketError(String msg, Throwable throwable, String errorCode, BError cause) {
        String message = errorCode + ": " + msg;
        WebSocketException exception = throwable != null ? new WebSocketException(throwable, errorCode) : (cause != null ? new WebSocketException(message, cause, errorCode) : new WebSocketException(message, errorCode));
        return exception.getWsError();
    }

    public static BError createWebsocketError(String message, WebSocketConstants.ErrorCode errorType) {
        return ErrorCreator.createError((Module)ModuleUtils.getWebsocketModule(), (String)errorType.errorCode(), (BString)StringUtils.fromString((String)message), null, null);
    }

    public static BError createWebsocketErrorWithCause(String message, WebSocketConstants.ErrorCode errorType, BError cause) {
        return ErrorCreator.createError((Module)ModuleUtils.getWebsocketModule(), (String)errorType.errorCode(), (BString)StringUtils.fromString((String)message), (BError)cause, null);
    }

    public static boolean reconnect(WebSocketConnectionInfo connectionInfo, CompletableFuture<Object> balFuture, AtomicBoolean futureCompleted) {
        BObject webSocketClient = connectionInfo.getWebSocketEndpoint();
        RetryContext retryConnectorConfig = (RetryContext)webSocketClient.getNativeData(WebSocketConstants.RETRY_CONFIG.toString());
        int interval = retryConnectorConfig.getInterval();
        int maxInterval = retryConnectorConfig.getMaxInterval();
        int maxAttempts = retryConnectorConfig.getMaxAttempts();
        int noOfReconnectAttempts = retryConnectorConfig.getReconnectAttempts();
        double backOfFactor = retryConnectorConfig.getBackOfFactor();
        WebSocketService wsService = connectionInfo.getService();
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        if (noOfReconnectAttempts < maxAttempts || maxAttempts == 0) {
            retryConnectorConfig.setReconnectAttempts(noOfReconnectAttempts + 1);
            String time = formatter.format(date.getTime());
            logger.debug("{} {}", (Object)time, (Object)"reconnecting...");
            WebSocketUtil.createDelay(WebSocketUtil.calculateWaitingTime(interval, maxInterval, backOfFactor, noOfReconnectAttempts));
            WebSocketUtil.establishWebSocketConnection(webSocketClient, wsService, balFuture, futureCompleted);
            return true;
        }
        logger.debug("{} {}", (Object)"Maximum retry attempts but couldn't connect to the server: ", (Object)webSocketClient.getStringValue(WebSocketConstants.CLIENT_URL_CONFIG));
        return false;
    }

    public static boolean reconnectForWrite(WebSocketConnectionInfo connectionInfo, CompletableFuture<Object> balFuture, AtomicBoolean futureCompleted, String txtMessage, BArray binMessage) {
        BObject webSocketClient = connectionInfo.getWebSocketEndpoint();
        RetryContext retryConnectorConfig = (RetryContext)webSocketClient.getNativeData(WebSocketConstants.RETRY_CONFIG.toString());
        int interval = retryConnectorConfig.getInterval();
        int maxInterval = retryConnectorConfig.getMaxInterval();
        int maxAttempts = retryConnectorConfig.getMaxAttempts();
        int noOfReconnectAttempts = retryConnectorConfig.getReconnectAttempts();
        double backOfFactor = retryConnectorConfig.getBackOfFactor();
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        if (noOfReconnectAttempts < maxAttempts || maxAttempts == 0) {
            retryConnectorConfig.setReconnectAttempts(noOfReconnectAttempts + 1);
            String time = formatter.format(date.getTime());
            logger.debug("{} {}", (Object)time, (Object)"reconnecting...");
            WebSocketUtil.createDelay(WebSocketUtil.calculateWaitingTime(interval, maxInterval, backOfFactor, noOfReconnectAttempts));
            WebSocketUtil.establishWebSocketConnectionForWrite(webSocketClient, balFuture, futureCompleted, txtMessage, binMessage);
            return true;
        }
        logger.debug("{} {}", (Object)"Maximum retry attempts but couldn't connect to the server: ", (Object)webSocketClient.getStringValue(WebSocketConstants.CLIENT_URL_CONFIG));
        return false;
    }

    public static void establishWebSocketConnectionForWrite(BObject webSocketClient, CompletableFuture<Object> balFuture, AtomicBoolean futureCompleted, String txtMessage, BArray binMessage) {
        SyncClientConnectorListener clientConnectorListener = (SyncClientConnectorListener)webSocketClient.getNativeData("clientListener");
        WebSocketClientConnector clientConnector = (WebSocketClientConnector)webSocketClient.getNativeData("clientConnector");
        ClientHandshakeFuture handshakeFuture = clientConnector.connect();
        handshakeFuture.setWebSocketConnectorListener((WebSocketConnectorListener)clientConnectorListener);
        if (WebSocketUtil.hasRetryConfig(webSocketClient)) {
            if (txtMessage != null) {
                handshakeFuture.setClientHandshakeListener((ClientHandshakeListener)new RetryWriteTextHandshakeListener(txtMessage, webSocketClient, clientConnectorListener, balFuture, futureCompleted));
            } else {
                handshakeFuture.setClientHandshakeListener((ClientHandshakeListener)new RetryWriteBinaryHandshakeListener(binMessage, webSocketClient, clientConnectorListener, balFuture, futureCompleted));
            }
        }
    }

    public static void establishWebSocketConnection(BObject webSocketClient, WebSocketService wsService, CompletableFuture<Object> balFuture, AtomicBoolean callbackCompleted) {
        SyncClientConnectorListener clientConnectorListener = (SyncClientConnectorListener)webSocketClient.getNativeData("clientListener");
        WebSocketClientConnector clientConnector = (WebSocketClientConnector)webSocketClient.getNativeData("clientConnector");
        ClientHandshakeFuture handshakeFuture = clientConnector.connect();
        handshakeFuture.setWebSocketConnectorListener((WebSocketConnectorListener)clientConnectorListener);
        if (WebSocketUtil.hasRetryConfig(webSocketClient)) {
            handshakeFuture.setClientHandshakeListener((ClientHandshakeListener)new RetryWebSocketClientHandshakeListener(webSocketClient, wsService, clientConnectorListener, balFuture, (RetryContext)webSocketClient.getNativeData(WebSocketConstants.RETRY_CONFIG.toString()), callbackCompleted));
        } else {
            handshakeFuture.setClientHandshakeListener((ClientHandshakeListener)new WebSocketHandshakeListener(webSocketClient, wsService, clientConnectorListener, balFuture, callbackCompleted));
        }
    }

    public static boolean hasRetryConfig(BObject webSocketClient) {
        return webSocketClient.getMapValue(WebSocketConstants.CLIENT_ENDPOINT_CONFIG).getMapValue(WebSocketConstants.RETRY_CONFIG) != null;
    }

    private static void createDelay(int interval) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        try {
            if (!countDownLatch.await(interval, TimeUnit.SECONDS)) {
                countDownLatch.countDown();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WebSocketException("WebSocketConstants.ERROR_MESSAGE", e.getMessage());
        }
    }

    private static int calculateWaitingTime(int interval, int maxInterval, double backOfFactor, int reconnectAttempts) {
        if ((interval = (int)((double)interval * Math.pow(backOfFactor, reconnectAttempts))) > maxInterval) {
            interval = maxInterval;
        }
        return interval;
    }

    public static void adjustContextOnSuccess(RetryContext retryConfig) {
        retryConfig.setFirstConnectionMadeSuccessfully();
        retryConfig.setReconnectAttempts(0);
    }

    public static Object getAuthorizationHeader(Environment env) {
        HttpCarbonMessage inboundMessage = (HttpCarbonMessage)env.getStrandLocal("INBOUND_MESSAGE");
        String authorizationHeader = inboundMessage.getHeader(HttpHeaderNames.AUTHORIZATION.toString());
        if (authorizationHeader == null) {
            return HttpUtil.createHttpError((String)"HTTP header does not exist", (HttpErrorType)HttpErrorType.HEADER_NOT_FOUND_ERROR);
        }
        return StringUtils.fromString((String)authorizationHeader);
    }

    public static BString getConnectionId(Environment env, BObject wsSyncClient) {
        return StringUtils.fromString((String)((String)wsSyncClient.getNativeData("id")));
    }

    public static Boolean isSecure(Environment env, BObject wsSyncClient) {
        return (Boolean)wsSyncClient.getNativeData("secure");
    }

    public static Object getNegotiatedSubProtocol(Environment env, BObject wsSyncClient) {
        return StringUtils.fromString((String)((String)wsSyncClient.getNativeData("negotiatedSubProtocol")));
    }

    private WebSocketUtil() {
    }
}

