/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.observability;

import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.metrics.DefaultMetricRegistry;
import io.ballerina.runtime.observability.metrics.MetricId;
import io.ballerina.runtime.observability.metrics.MetricRegistry;
import io.ballerina.runtime.observability.metrics.StatisticConfig;
import io.ballerina.stdlib.websocket.observability.WebSocketObservabilityConstants;
import io.ballerina.stdlib.websocket.observability.WebSocketObserverContext;
import java.util.Set;

class WebSocketMetricsUtil {
    private static final MetricRegistry metricRegistry = DefaultMetricRegistry.getInstance();

    static void reportRequestMetrics(WebSocketObserverContext observerContext) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        WebSocketMetricsUtil.incrementCounterMetric(observerContext, WebSocketObservabilityConstants.METRIC_REQUESTS[0], WebSocketObservabilityConstants.METRIC_REQUESTS[1]);
    }

    static void reportConnectionMetrics(WebSocketObserverContext observerContext) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        WebSocketMetricsUtil.incrementGaugeMetric(observerContext, WebSocketObservabilityConstants.METRIC_CONNECTIONS[0], WebSocketObservabilityConstants.METRIC_CONNECTIONS[1]);
    }

    static void reportSendMetrics(WebSocketObserverContext observerContext, String type) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        observerContext.addTag("type", type);
        WebSocketMetricsUtil.incrementCounterMetric(observerContext, WebSocketObservabilityConstants.METRIC_MESSAGES_SENT[0], WebSocketObservabilityConstants.METRIC_MESSAGES_SENT[1]);
    }

    static void reportReceivedMetrics(WebSocketObserverContext observerContext, String type) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        observerContext.addTag("type", type);
        WebSocketMetricsUtil.incrementCounterMetric(observerContext, WebSocketObservabilityConstants.METRIC_MESSAGES_RECEIVED[0], WebSocketObservabilityConstants.METRIC_MESSAGES_RECEIVED[1]);
    }

    static void reportCloseMetrics(WebSocketObserverContext observerContext) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        WebSocketMetricsUtil.decrementGaugeMetric(observerContext, WebSocketObservabilityConstants.METRIC_CONNECTIONS[0], WebSocketObservabilityConstants.METRIC_CONNECTIONS[1]);
    }

    static void reportResourceInvocationMetrics(WebSocketObserverContext observerContext, String resource) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        observerContext.addTag("resource", resource);
        WebSocketMetricsUtil.incrementCounterMetric(observerContext, WebSocketObservabilityConstants.METRIC_RESOURCES_INVOKED[0], WebSocketObservabilityConstants.METRIC_RESOURCES_INVOKED[1]);
    }

    static void reportErrorMetrics(WebSocketObserverContext observerContext, String errorType, String messageType) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        observerContext.addTag("error_type", errorType);
        if (messageType != null) {
            observerContext.addTag("type", messageType);
        }
        WebSocketMetricsUtil.incrementCounterMetric(observerContext, WebSocketObservabilityConstants.METRIC_ERRORS[0], WebSocketObservabilityConstants.METRIC_ERRORS[1]);
    }

    static void reportErrorMetrics(String errorType, String url, String clientOrServer) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        WebSocketObserverContext observerContext = new WebSocketObserverContext();
        observerContext.addTag("error_type", errorType);
        observerContext.addTag("service", url);
        observerContext.addTag("client_or_server", clientOrServer);
        WebSocketMetricsUtil.incrementCounterMetric(observerContext, WebSocketObservabilityConstants.METRIC_ERRORS[0], WebSocketObservabilityConstants.METRIC_ERRORS[1]);
    }

    private static void incrementCounterMetric(WebSocketObserverContext observerContext, String name, String desc) {
        Set tags = observerContext.getAllTags();
        metricRegistry.counter(new MetricId("ws_" + name, desc, tags)).increment();
    }

    private static void incrementGaugeMetric(WebSocketObserverContext observerContext, String name, String desc) {
        Set tags = observerContext.getAllTags();
        metricRegistry.gauge(new MetricId("ws_" + name, desc, tags), new StatisticConfig[0]).increment();
    }

    private static void decrementGaugeMetric(WebSocketObserverContext observerContext, String name, String desc) {
        Set tags = observerContext.getAllTags();
        metricRegistry.gauge(new MetricId("ws_" + name, desc, tags), new StatisticConfig[0]).decrement();
    }

    private WebSocketMetricsUtil() {
    }
}

