/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.server;

import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.transport.contract.websocket.ServerHandshakeFuture;
import io.ballerina.stdlib.http.transport.contract.websocket.ServerHandshakeListener;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketHandshaker;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.server.UpgradeListener;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionManager;
import io.ballerina.stdlib.websocket.server.WebSocketServerService;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;

public class OnUpgradeResourceCallback {
    private final WebSocketHandshaker webSocketHandshaker;
    private final WebSocketServerService wsService;
    private final WebSocketConnectionManager connectionManager;

    public OnUpgradeResourceCallback(WebSocketHandshaker webSocketHandshaker, WebSocketServerService wsService, WebSocketConnectionManager connectionManager) {
        this.webSocketHandshaker = webSocketHandshaker;
        this.wsService = wsService;
        this.connectionManager = connectionManager;
    }

    public void notifySuccess(Object result) {
        if (result instanceof BError) {
            BError error = (BError)((Object)result);
            if (error.getType().getName().equals(WebSocketConstants.ErrorCode.AuthnError.errorCode())) {
                this.webSocketHandshaker.cancelHandshake(401, error.getErrorMessage().toString());
                return;
            }
            if (error.getType().getName().equals(WebSocketConstants.ErrorCode.AuthzError.errorCode())) {
                this.webSocketHandshaker.cancelHandshake(403, error.getErrorMessage().toString());
                return;
            }
            this.webSocketHandshaker.cancelHandshake(400, error.getErrorMessage().toString());
            return;
        }
        if (!this.webSocketHandshaker.isCancelled() && !this.webSocketHandshaker.isHandshakeStarted()) {
            DefaultHttpHeaders headers = null;
            ObjectType type = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)result));
            if (type.getFields().get(WebSocketConstants.CUSTOM_HEADERS.toString()) != null) {
                BMap headersMap = (BMap)((BObject)result).get(WebSocketConstants.CUSTOM_HEADERS);
                headers = OnUpgradeResourceCallback.populateAndGetHttpHeaders((BMap<BString, BString>)headersMap);
            }
            ServerHandshakeFuture future = this.webSocketHandshaker.handshake(this.wsService.getNegotiableSubProtocols(), this.wsService.getIdleTimeoutInSeconds() * 1000, (HttpHeaders)headers, this.wsService.getMaxFrameSize());
            future.setHandshakeListener((ServerHandshakeListener)new UpgradeListener(this.wsService, this.connectionManager, result));
        }
    }

    public void notifyFailure(BError error) {
        if (error.getType().getName().equals(WebSocketConstants.ErrorCode.AuthnError.errorCode())) {
            this.webSocketHandshaker.cancelHandshake(401, null);
            return;
        }
        if (error.getType().getName().equals(WebSocketConstants.ErrorCode.AuthzError.errorCode())) {
            this.webSocketHandshaker.cancelHandshake(403, null);
            return;
        }
        error.printStackTrace();
        this.webSocketHandshaker.cancelHandshake(500, error.getMessage());
    }

    private static DefaultHttpHeaders populateAndGetHttpHeaders(BMap<BString, BString> headers) {
        BString[] keys;
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        for (BString key : keys = (BString[])headers.getKeys()) {
            httpHeaders.add(key.toString(), (Object)((BString)headers.get((Object)key)).getValue());
        }
        return httpHeaders;
    }
}

