/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.server;

import io.ballerina.stdlib.http.api.HttpDispatcher;
import io.ballerina.stdlib.http.api.HttpResourceArguments;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketBinaryMessage;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketCloseMessage;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnection;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnectorListener;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketControlMessage;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketHandshaker;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketMessage;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketTextMessage;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.uri.URIUtil;
import io.ballerina.stdlib.websocket.WebSocketResourceDispatcher;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.observability.WebSocketObservabilityUtil;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionInfo;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionManager;
import io.ballerina.stdlib.websocket.server.WebSocketServerService;
import io.ballerina.stdlib.websocket.server.WebSocketServicesRegistry;
import java.net.URI;
import java.util.HashMap;

public class WebSocketServerListener
implements WebSocketConnectorListener {
    private final WebSocketServicesRegistry servicesRegistry;
    private final WebSocketConnectionManager connectionManager;

    public WebSocketServerListener(WebSocketServicesRegistry servicesRegistry) {
        this.servicesRegistry = servicesRegistry;
        this.connectionManager = new WebSocketConnectionManager();
    }

    public void onHandshake(WebSocketHandshaker webSocketHandshaker) {
        HttpResourceArguments pathParams = new HttpResourceArguments();
        URI requestUri = this.createRequestUri(webSocketHandshaker);
        HashMap matrixParams = new HashMap();
        String uriWithoutMatrixParams = URIUtil.extractMatrixParams((String)requestUri.getRawPath(), matrixParams, (HttpCarbonMessage)webSocketHandshaker.getHttpCarbonRequest());
        URI validatedUri = HttpDispatcher.getValidatedURI((String)uriWithoutMatrixParams);
        String matchingBasePath = this.servicesRegistry.findTheMostSpecificBasePath(validatedUri.getRawPath(), this.servicesRegistry.getServicesByBasePath(), this.servicesRegistry.getSortedServiceURIs());
        if (matchingBasePath == null) {
            this.sendNotFoundError(webSocketHandshaker, requestUri);
            return;
        }
        WebSocketServerService wsService = this.servicesRegistry.findMatching(matchingBasePath, pathParams, webSocketHandshaker);
        if (wsService == null) {
            this.sendNotFoundError(webSocketHandshaker, requestUri);
            return;
        }
        this.setCarbonMessageProperties(pathParams, requestUri, validatedUri, (HttpCarbonMessage)webSocketHandshaker.getHttpCarbonRequest(), matchingBasePath);
        WebSocketResourceDispatcher.dispatchUpgrade(webSocketHandshaker, wsService, this.connectionManager);
    }

    private void sendNotFoundError(WebSocketHandshaker webSocketHandshaker, URI requestUri) {
        String errMsg = "No service found to handle the service request";
        webSocketHandshaker.cancelHandshake(404, errMsg);
        WebSocketObservabilityUtil.observeError("connection", errMsg, requestUri.getPath(), "server");
    }

    private URI createRequestUri(WebSocketHandshaker webSocketHandshaker) {
        String serviceUri = webSocketHandshaker.getTarget();
        serviceUri = HttpUtil.sanitizeBasePath((String)serviceUri);
        return URI.create(serviceUri);
    }

    private void setCarbonMessageProperties(HttpResourceArguments pathParams, URI requestUri, URI validateUri, HttpCarbonMessage msg, String matchingBasePath) {
        String subPath = URIUtil.getSubPath((String)validateUri.getRawPath(), (String)matchingBasePath);
        msg.setProperty("QUERY_STR", (Object)requestUri.getRawQuery());
        msg.setProperty("RAW_QUERY_STR", (Object)requestUri.getRawQuery());
        msg.setProperty("RESOURCE_ARGS", (Object)pathParams);
        if (subPath.startsWith("/")) {
            msg.setProperty("SUB_PATH", (Object)subPath.substring(1));
        } else {
            msg.setProperty("SUB_PATH", (Object)subPath);
        }
    }

    public void onMessage(WebSocketTextMessage webSocketTextMessage) {
        WebSocketResourceDispatcher.dispatchOnText(this.getConnectionInfo((WebSocketMessage)webSocketTextMessage), webSocketTextMessage);
    }

    public void onMessage(WebSocketBinaryMessage webSocketBinaryMessage) {
        WebSocketResourceDispatcher.dispatchOnBinary(this.getConnectionInfo((WebSocketMessage)webSocketBinaryMessage), webSocketBinaryMessage);
    }

    public void onMessage(WebSocketControlMessage webSocketControlMessage) {
        WebSocketResourceDispatcher.dispatchOnPingOnPong(this.getConnectionInfo((WebSocketMessage)webSocketControlMessage), webSocketControlMessage, true);
    }

    public void onMessage(WebSocketCloseMessage webSocketCloseMessage) {
        WebSocketResourceDispatcher.dispatchOnClose(this.getConnectionInfo((WebSocketMessage)webSocketCloseMessage), webSocketCloseMessage, true);
    }

    public void onClose(WebSocketConnection webSocketConnection) {
        WebSocketObservabilityUtil.observeClose(this.getConnectionInfo(webSocketConnection));
        try {
            WebSocketUtil.setListenerOpenField(this.connectionManager.removeConnectionInfo(webSocketConnection.getChannelId()));
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void onError(WebSocketConnection webSocketConnection, Throwable throwable) {
        WebSocketResourceDispatcher.dispatchOnError(this.getConnectionInfo(webSocketConnection), throwable, true);
    }

    public void onIdleTimeout(WebSocketControlMessage controlMessage) {
        WebSocketResourceDispatcher.dispatchOnIdleTimeout(this.getConnectionInfo((WebSocketMessage)controlMessage));
    }

    private String getConnectionId(WebSocketMessage webSocketMessage) {
        return webSocketMessage.getWebSocketConnection().getChannelId();
    }

    private WebSocketConnectionInfo getConnectionInfo(WebSocketMessage webSocketMessage) {
        return this.connectionManager.getConnectionInfo(this.getConnectionId(webSocketMessage));
    }

    private WebSocketConnectionInfo getConnectionInfo(WebSocketConnection webSocketConnection) {
        return this.connectionManager.getConnectionInfo(webSocketConnection.getChannelId());
    }
}

