/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.trigger;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import io.ballerina.projects.Settings;
import io.ballerina.projects.internal.model.Proxy;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.trigger.entity.BallerinaTriggerListRequest;
import io.ballerina.trigger.entity.BallerinaTriggerListResponse;
import io.ballerina.trigger.entity.BallerinaTriggerRequest;
import io.ballerina.trigger.entity.CentralTriggerListResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.toml.exceptions.SettingsTomlException;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.wso2.ballerinalang.util.RepoUtils;

@JsonSegment(value="ballerinaTrigger")
public class BallerinaTriggerService
implements ExtendedLanguageServerService {
    private LanguageClient languageClient;
    private final Map<String, InBuiltTrigger> inBuiltTriggers;
    private static final Type MAP_TYPE = MapTypeToken.TYPE;

    public BallerinaTriggerService() {
        InputStream propertiesStream = this.getClass().getClassLoader().getResourceAsStream("inbuilt-triggers/properties.json");
        Map triggers = Map.of();
        if (propertiesStream != null) {
            try (JsonReader reader = new JsonReader(new InputStreamReader(propertiesStream, StandardCharsets.UTF_8));){
                triggers = (Map)new Gson().fromJson(reader, MAP_TYPE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.inBuiltTriggers = triggers;
    }

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager, LanguageServerContext serverContext) {
        this.languageClient = (LanguageClient)serverContext.get(ExtendedLanguageClient.class);
    }

    @JsonRequest
    public CompletableFuture<BallerinaTriggerListResponse> triggers(BallerinaTriggerListRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            BallerinaTriggerListResponse triggersList = new BallerinaTriggerListResponse();
            try {
                CentralTriggerListResult centralTriggerListResult = BallerinaTriggerService.getCentralTriggerListResult(request);
                triggersList.setCentralTriggers(centralTriggerListResult.getTriggers());
                return triggersList;
            }
            catch (CentralClientException | SettingsTomlException e) {
                String msg = "Operation 'ballerinaTrigger/triggers' failed!";
                this.languageClient.logMessage(new MessageParams(MessageType.Error, msg));
                return triggersList;
            }
        });
    }

    @JsonRequest
    public CompletableFuture<JsonObject> triggersNew(BallerinaTriggerListRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject triggersList = new JsonObject();
            List<JsonObject> inBuiltTriggers = this.getInBuiltTriggers(request);
            triggersList.add("central", new Gson().toJsonTree(inBuiltTriggers));
            return triggersList;
        });
    }

    @JsonRequest
    public CompletableFuture<JsonObject> trigger(BallerinaTriggerRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            Optional<JsonObject> trigger = this.getTriggerFromCentral(request);
            return trigger.orElseGet(JsonObject::new);
        });
    }

    @JsonRequest
    public CompletableFuture<JsonObject> triggerNew(BallerinaTriggerRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            Optional<JsonObject> trigger;
            if (BallerinaTriggerService.expectsTriggerByName(request)) {
                return this.getTriggerByName(request).orElseGet(JsonObject::new);
            }
            if (request.getTriggerId() != null && (trigger = this.getInBuiltTriggerJsonById(request.getTriggerId())).isPresent()) {
                return trigger.get();
            }
            return new JsonObject();
        });
    }

    private static boolean expectsTriggerByName(BallerinaTriggerRequest request) {
        return request.getTriggerId() == null && request.getOrgName() != null && request.getPackageName() != null;
    }

    private Optional<JsonObject> getTriggerByName(BallerinaTriggerRequest request) {
        return this.getInBuiltTriggerJson(request.getPackageName());
    }

    private static CentralTriggerListResult getCentralTriggerListResult(BallerinaTriggerListRequest triggerListRequest) throws SettingsTomlException, CentralClientException {
        Settings settings = RepoUtils.readSettings();
        CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy((Proxy)settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI((Settings)settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
        JsonElement triggerSearchResult = client.getTriggers(triggerListRequest.getQueryMap(), "any", RepoUtils.getBallerinaVersion());
        return new Gson().fromJson(triggerSearchResult.getAsString(), CentralTriggerListResult.class);
    }

    private Optional<JsonObject> getTriggerFromCentral(BallerinaTriggerRequest request) {
        try {
            Settings settings = RepoUtils.readSettings();
            CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy((Proxy)settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI((Settings)settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
            if (request.getTriggerId() != null) {
                JsonObject trigger = client.getTrigger(request.getTriggerId(), "any", RepoUtils.getBallerinaVersion());
                return Optional.of(trigger);
            }
        }
        catch (CentralClientException e) {
            String msg = "Operation 'ballerinaTrigger/trigger' failed!";
            this.languageClient.logMessage(new MessageParams(MessageType.Error, msg));
        }
        return Optional.empty();
    }

    public Class<?> getRemoteInterface() {
        return this.getClass();
    }

    public String getName() {
        return "ballerinaTrigger";
    }

    private List<JsonObject> getInBuiltTriggers(BallerinaTriggerListRequest request) {
        return this.inBuiltTriggers.values().stream().filter(inBuiltTrigger -> this.filterInBuiltTriggers((InBuiltTrigger)inBuiltTrigger, request)).map(inBuiltTrigger -> this.getInBuiltTriggerJson(inBuiltTrigger.name())).flatMap(Optional::stream).limit(request.getLimit() > 0 ? (long)request.getLimit() : Long.MAX_VALUE).toList();
    }

    private boolean filterInBuiltTriggers(InBuiltTrigger inBuiltTrigger, BallerinaTriggerListRequest request) {
        return !(request.getOrganization() != null && !request.getOrganization().equals(inBuiltTrigger.orgName()) || request.getPackageName() != null && !request.getPackageName().equals(inBuiltTrigger.packageName()) || request.getKeyword() != null && !inBuiltTrigger.keywords().stream().anyMatch(keyword -> keyword.equalsIgnoreCase(request.getKeyword())) || request.getQuery() != null && !inBuiltTrigger.keywords().stream().anyMatch(keyword -> keyword.contains(request.getQuery())));
    }

    private Optional<JsonObject> getInBuiltTriggerJsonById(String triggerId) {
        if (!this.inBuiltTriggers.containsKey(triggerId)) {
            return Optional.empty();
        }
        return this.getInBuiltTriggerJson(this.inBuiltTriggers.get(triggerId).name());
    }

    private Optional<JsonObject> getInBuiltTriggerJson(String triggerName) {
        Optional<JsonObject> optional;
        if (this.inBuiltTriggers.values().stream().noneMatch(inBuiltTrigger -> inBuiltTrigger.name().equals(triggerName))) {
            return Optional.empty();
        }
        InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(String.format("inbuilt-triggers/%s.json", triggerName));
        if (resourceStream == null) {
            String msg = String.format("Trigger info file not found for the trigger: %s", triggerName);
            this.languageClient.logMessage(new MessageParams(MessageType.Error, msg));
            return Optional.empty();
        }
        JsonReader reader = new JsonReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
        try {
            optional = Optional.of((JsonObject)new Gson().fromJson(reader, (Type)((Object)JsonObject.class)));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                String msg = String.format("Error occurred while reading the trigger info file for the trigger: %s", triggerName);
                this.languageClient.logMessage(new MessageParams(MessageType.Error, msg));
                return Optional.empty();
            }
        }
        reader.close();
        return optional;
    }

    public record InBuiltTrigger(String name, String orgName, String packageName, List<String> keywords) {
        private final List<String> keywords;

        public InBuiltTrigger(String name, String orgName, String packageName, List<String> keywords) {
            this.name = name;
            this.orgName = orgName;
            this.packageName = packageName;
            this.keywords = keywords == null ? List.of() : new ArrayList<String>(keywords);
        }

        public List<String> keywords() {
            return List.copyOf(this.keywords);
        }
    }

    private static class MapTypeToken {
        private static final Type TYPE = new TypeToken<Map<String, InBuiltTrigger>>(){}.getType();

        private MapTypeToken() {
        }
    }
}

