/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai.plugin;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.openapi.service.mapper.type.TypeMapper;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.CodeModifier;
import io.ballerina.projects.plugins.CodeModifierContext;
import io.ballerina.projects.plugins.ModifierTask;
import io.ballerina.stdlib.ai.plugin.AiSourceModifier;
import io.ballerina.stdlib.ai.plugin.GenerateMethodModificationTask;
import io.ballerina.stdlib.ai.plugin.InitFunctionAnalysisTask;
import io.ballerina.stdlib.ai.plugin.ModifierContext;
import io.ballerina.stdlib.ai.plugin.ModuleLevelAgentAnalysisTask;
import io.ballerina.stdlib.ai.plugin.ToolAnnotationAnalysisTask;
import io.ballerina.stdlib.ai.plugin.TypeMapperImplInitializer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AiCodeModifier
extends CodeModifier {
    private final Map<DocumentId, ModifierContext> modifierContextMap = new HashMap<DocumentId, ModifierContext>();
    private final Set<ModuleId> modulesWithPredefinedInitMethods = new HashSet<ModuleId>();

    public void init(CodeModifierContext codeModifierContext) {
        AnalysisData analysisData = new AnalysisData();
        codeModifierContext.addSyntaxNodeAnalysisTask((AnalysisTask)new ToolAnnotationAnalysisTask(this.modifierContextMap), SyntaxKind.ANNOTATION);
        codeModifierContext.addSyntaxNodeAnalysisTask((AnalysisTask)new ModuleLevelAgentAnalysisTask(this.modifierContextMap), SyntaxKind.MODULE_VAR_DECL);
        codeModifierContext.addSyntaxNodeAnalysisTask((AnalysisTask)new InitFunctionAnalysisTask(this.modulesWithPredefinedInitMethods), SyntaxKind.FUNCTION_DEFINITION);
        codeModifierContext.addSourceModifierTask((ModifierTask)new AiSourceModifier(this.modifierContextMap, this.modulesWithPredefinedInitMethods));
        codeModifierContext.addSyntaxNodeAnalysisTask((AnalysisTask)new TypeMapperImplInitializer(analysisData), SyntaxKind.MODULE_PART);
        codeModifierContext.addSourceModifierTask((ModifierTask)new GenerateMethodModificationTask(analysisData));
    }

    public static final class AnalysisData {
        TypeMapper typeMapper;
    }
}

