/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai.plugin;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.List;

public final class ChatServiceOpenAPISchema {
    private static final String SCHEMA_CHAT_REQ = "ChatReqMessage";
    private static final String SCHEMA_CHAT_RESP = "ChatRespMessage";
    private static final String SCHEMA_ERROR = "ErrorPayload";
    private static final String MEDIA_TYPE_JSON = "application/json";

    private ChatServiceOpenAPISchema() {
    }

    public static OpenAPI generate() {
        Components components = ChatServiceOpenAPISchema.createComponents();
        RequestBody chatRequestBody = ChatServiceOpenAPISchema.createRequestBody();
        ApiResponses responses = ChatServiceOpenAPISchema.createResponses();
        Operation postChatOperation = ChatServiceOpenAPISchema.createPostChatOperation(chatRequestBody, responses);
        PathItem chatPath = new PathItem().post(postChatOperation);
        return new OpenAPI().info(ChatServiceOpenAPISchema.createInfo()).components(components).paths(new Paths().addPathItem("/chat", chatPath));
    }

    private static Components createComponents() {
        return new Components().addSchemas(SCHEMA_CHAT_REQ, ChatServiceOpenAPISchema.createChatRequestSchema()).addSchemas(SCHEMA_CHAT_RESP, ChatServiceOpenAPISchema.createChatResponseSchema()).addSchemas(SCHEMA_ERROR, ChatServiceOpenAPISchema.createErrorSchema());
    }

    private static Schema<Object> createChatRequestSchema() {
        return new ObjectSchema().addProperty("sessionId", new StringSchema().description("Unique identifier for the chat session.")).addProperty("message", new StringSchema().description("The user message sent to the chat service.")).required(List.of("sessionId", "message")).description("Represents a request message for the chat service.").additionalProperties((Object)false);
    }

    private static Schema<Object> createChatResponseSchema() {
        return new ObjectSchema().addProperty("message", new StringSchema().description("Response message generated by the chat service.")).required(List.of("message")).description("Represents a response message from the chat service.").additionalProperties((Object)false);
    }

    private static Schema<Object> createErrorSchema() {
        return new ObjectSchema().addProperty("timestamp", new StringSchema().description("Time when the error occurred.")).addProperty("status", new IntegerSchema().format("int64").description("HTTP status code associated with the error.")).addProperty("reason", new StringSchema().description("Short reason for the error.")).addProperty("message", new StringSchema().description("Detailed message describing the error.")).addProperty("path", new StringSchema().description("Request path where the error occurred.")).addProperty("method", new StringSchema().description("HTTP method used for the request.")).required(List.of("timestamp", "status", "reason", "message", "path", "method")).description("Represents a standard error payload.").additionalProperties((Object)false);
    }

    private static RequestBody createRequestBody() {
        return new RequestBody().required(Boolean.valueOf(true)).content(new Content().addMediaType(MEDIA_TYPE_JSON, new MediaType().schema(new Schema().$ref("#/components/schemas/ChatReqMessage"))));
    }

    private static ApiResponses createResponses() {
        return new ApiResponses().addApiResponse("201", ChatServiceOpenAPISchema.createApiResponse("Created", SCHEMA_CHAT_RESP)).addApiResponse("400", ChatServiceOpenAPISchema.createApiResponse("Bad Request", SCHEMA_ERROR)).addApiResponse("500", ChatServiceOpenAPISchema.createApiResponse("Internal Server Error", SCHEMA_ERROR));
    }

    private static ApiResponse createApiResponse(String description, String schemaRef) {
        return new ApiResponse().description(description).content(new Content().addMediaType(MEDIA_TYPE_JSON, new MediaType().schema(new Schema().$ref("#/components/schemas/" + schemaRef))));
    }

    private static Operation createPostChatOperation(RequestBody requestBody, ApiResponses responses) {
        return new Operation().operationId("postChat").summary("Send a chat message").description("Processes an input chat message and returns a response.").requestBody(requestBody).responses(responses);
    }

    private static Info createInfo() {
        return new Info().title("Chat Service API").version("1.0.0").description("OpenAPI specification for the Chat Service endpoint.");
    }
}

