/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai.plugin;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TreeModifier;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.openapi.service.mapper.type.TypeMapper;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.plugins.ModifierTask;
import io.ballerina.projects.plugins.SourceModifierContext;
import io.ballerina.stdlib.ai.plugin.AiCodeModifier;
import io.ballerina.tools.text.TextDocument;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.OpenAPISchema2JsonSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GenerateMethodModificationTask
implements ModifierTask<SourceModifierContext> {
    private static final String AI_MODULE_NAME = "ai";
    private static final String BALLERINA_ORG_NAME = "ballerina";
    private static final String AI_MODULE_MAJOR_VERSION = "1";
    private static final String MODEL_PROVIDER_NAME = "ModelProvider";
    private final AiCodeModifier.AnalysisData analysisData;
    private final ModifierData modifierData;

    public GenerateMethodModificationTask(AiCodeModifier.AnalysisData analysisData) {
        this.analysisData = analysisData;
        this.modifierData = new ModifierData();
    }

    public void modify(SourceModifierContext modifierContext) {
        Package currentPackage = modifierContext.currentPackage();
        PackageCompilation compilation = modifierContext.compilation();
        if (compilation.diagnosticResult().errorCount() > 0) {
            return;
        }
        for (ModuleId moduleId : currentPackage.moduleIds()) {
            Module module = currentPackage.module(moduleId);
            SemanticModel semanticModel = compilation.getSemanticModel(moduleId);
            Collection documentIds = module.documentIds();
            Collection testDocumentIds = module.testDocumentIds();
            Types types = semanticModel.types();
            Optional aiModelProviderSymbol = types.getTypeByName(BALLERINA_ORG_NAME, AI_MODULE_NAME, AI_MODULE_MAJOR_VERSION, MODEL_PROVIDER_NAME);
            for (DocumentId documentId : documentIds) {
                this.analyzeDocument(module, documentId, semanticModel, aiModelProviderSymbol);
            }
            for (DocumentId documentId : testDocumentIds) {
                this.analyzeDocument(module, documentId, semanticModel, aiModelProviderSymbol);
            }
            for (DocumentId documentId : documentIds) {
                modifierContext.modifySourceFile(GenerateMethodModificationTask.modifyDocument(module.document(documentId), this.modifierData), documentId);
            }
            for (DocumentId documentId : testDocumentIds) {
                modifierContext.modifyTestSourceFile(GenerateMethodModificationTask.modifyDocument(module.document(documentId), this.modifierData), documentId);
            }
        }
    }

    private void analyzeDocument(Module module, DocumentId documentId, SemanticModel semanticModel, Optional<Symbol> aiModelProviderSymbol) {
        Document document = module.document(documentId);
        Node rootNode = document.syntaxTree().rootNode();
        if (!(rootNode instanceof ModulePartNode)) {
            return;
        }
        ModulePartNode modulePartNode = (ModulePartNode)rootNode;
        this.analyzeGenerateMethod(semanticModel, modulePartNode, aiModelProviderSymbol, this.analysisData);
    }

    private static TextDocument modifyDocument(Document document, ModifierData modifierData) {
        ModulePartNode modulePartNode = (ModulePartNode)document.syntaxTree().rootNode();
        DocumentId documentId = document.documentId();
        String aiImportPrefix = GenerateMethodModificationTask.getAiModuleImportPrefix((NodeList<ImportDeclarationNode>)modulePartNode.imports());
        boolean isAiImportPresent = aiImportPrefix != null;
        TypeDefinitionModifier typeDefinitionModifier = new TypeDefinitionModifier(modifierData.typeSchemas, document, modifierData, isAiImportPresent ? aiImportPrefix : AI_MODULE_NAME);
        ModulePartNode finalRoot = (ModulePartNode)modulePartNode.apply((NodeTransformer)typeDefinitionModifier);
        NodeList imports = finalRoot.imports();
        if (modifierData.aiImportRequiredDocuments.contains(documentId) && !isAiImportPresent) {
            imports = imports.add((Node)GenerateMethodModificationTask.createImportDeclarationForAIModule());
        }
        finalRoot = finalRoot.modify(imports, finalRoot.members(), finalRoot.eofToken());
        return document.syntaxTree().modifyWith((Node)finalRoot).textDocument();
    }

    private static ImportDeclarationNode createImportDeclarationForAIModule() {
        return NodeParser.parseImportDeclaration((String)String.format("import %s/%s;", BALLERINA_ORG_NAME, AI_MODULE_NAME));
    }

    private void analyzeGenerateMethod(SemanticModel semanticModel, ModulePartNode modulePartNode, Optional<Symbol> aiModelProviderSymbol, AiCodeModifier.AnalysisData analysisData) {
        new GenerateMethodJsonSchemaGenerator(semanticModel, aiModelProviderSymbol, analysisData).generate(modulePartNode);
    }

    private static String getAiModuleImportPrefix(NodeList<ImportDeclarationNode> imports) {
        for (ImportDeclarationNode importDeclarationNode : imports) {
            String orgName;
            Optional importOrgNameNode = importDeclarationNode.orgName();
            if (importOrgNameNode.isEmpty() || !BALLERINA_ORG_NAME.equals(orgName = ((ImportOrgNameNode)importOrgNameNode.get()).orgName().text())) continue;
            for (IdentifierToken module : importDeclarationNode.moduleName()) {
                if (!AI_MODULE_NAME.equals(module.text())) continue;
                String importPrefix = AI_MODULE_NAME;
                Optional prefix = importDeclarationNode.prefix();
                if (prefix.isPresent()) {
                    String prefixText = ((ImportPrefixNode)prefix.get()).prefix().text();
                    importPrefix = !prefixText.equals("_") ? prefixText : null;
                }
                return importPrefix;
            }
        }
        return null;
    }

    static final class ModifierData {
        Map<String, String> typeSchemas = new HashMap<String, String>();
        HashSet<DocumentId> aiImportRequiredDocuments = new HashSet();

        ModifierData() {
        }
    }

    private static class TypeDefinitionModifier
    extends TreeModifier {
        private static final String SCHEMA_ANNOTATION_IDENTIFIER = "JsonSchema";
        private static final String COLON = ":";
        private final Map<String, String> typeSchemas;
        private final Document document;
        private final ModifierData modifierData;
        private final String aiPrefix;

        TypeDefinitionModifier(Map<String, String> typeSchemas, Document document, ModifierData modifierData, String aiPrefix) {
            this.typeSchemas = typeSchemas;
            this.document = document;
            this.modifierData = modifierData;
            this.aiPrefix = aiPrefix != null ? aiPrefix : GenerateMethodModificationTask.AI_MODULE_NAME;
        }

        public TypeDefinitionNode transform(TypeDefinitionNode typeDefinitionNode) {
            String typeName = typeDefinitionNode.typeName().text();
            if (!this.typeSchemas.containsKey(typeName)) {
                return typeDefinitionNode;
            }
            MetadataNode updatedMetadataNode = this.updateMetadata(typeDefinitionNode, this.typeSchemas.get(typeName));
            return typeDefinitionNode.modify().withMetadata(updatedMetadataNode).apply();
        }

        private MetadataNode updateMetadata(TypeDefinitionNode typeDefinitionNode, String schema) {
            MetadataNode metadataNode = TypeDefinitionModifier.getMetadataNode(typeDefinitionNode);
            NodeList currentAnnotations = metadataNode.annotations();
            NodeList<AnnotationNode> updatedAnnotations = TypeDefinitionModifier.updateAnnotations((NodeList<AnnotationNode>)currentAnnotations, schema, this.aiPrefix);
            if (currentAnnotations.size() < updatedAnnotations.size()) {
                this.modifierData.aiImportRequiredDocuments.add(this.document.documentId());
            }
            return metadataNode.modify().withAnnotations(updatedAnnotations).apply();
        }

        public static MetadataNode getMetadataNode(TypeDefinitionNode typeDefinitionNode) {
            return typeDefinitionNode.metadata().orElseGet(() -> {
                NodeList annotations = NodeFactory.createNodeList((Node[])new AnnotationNode[0]);
                return NodeFactory.createMetadataNode(null, (NodeList)annotations);
            });
        }

        private static NodeList<AnnotationNode> updateAnnotations(NodeList<AnnotationNode> currentAnnotations, String jsonSchema, String aiPrefix) {
            for (AnnotationNode annotationNode : currentAnnotations) {
                if (!TypeDefinitionModifier.isJsonSchemaAnnotationAvailable(annotationNode, aiPrefix)) continue;
                return currentAnnotations;
            }
            return currentAnnotations.add((Node)TypeDefinitionModifier.getSchemaAnnotation(jsonSchema, aiPrefix));
        }

        public static boolean isJsonSchemaAnnotationAvailable(AnnotationNode annotationNode, String aiPrefix) {
            Node node = annotationNode.annotReference();
            if (!(node instanceof QualifiedNameReferenceNode)) {
                return false;
            }
            QualifiedNameReferenceNode referenceNode = (QualifiedNameReferenceNode)node;
            if (!aiPrefix.equals(referenceNode.modulePrefix().text())) {
                return false;
            }
            return SCHEMA_ANNOTATION_IDENTIFIER.equals(referenceNode.identifier().text());
        }

        public static AnnotationNode getSchemaAnnotation(String jsonSchema, String aiPrefix) {
            String configIdentifierString = aiPrefix + ":JsonSchema";
            IdentifierToken identifierToken = NodeFactory.createIdentifierToken((String)configIdentifierString);
            return NodeFactory.createAnnotationNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)NodeFactory.createSimpleNameReferenceNode((Token)identifierToken), (MappingConstructorExpressionNode)TypeDefinitionModifier.getAnnotationExpression(jsonSchema));
        }

        public static MappingConstructorExpressionNode getAnnotationExpression(String jsonSchema) {
            return (MappingConstructorExpressionNode)NodeParser.parseExpression((String)jsonSchema);
        }
    }

    private class GenerateMethodJsonSchemaGenerator
    extends NodeVisitor {
        private static final String GENERATE_METHOD_NAME = "generate";
        private static final String STRING = "string";
        private static final String BYTE = "byte";
        private static final String NUMBER = "number";
        private final SemanticModel semanticModel;
        private final TypeMapper typeMapper;
        private final TypeDefinitionSymbol modelProviderSymbol;

        public GenerateMethodJsonSchemaGenerator(SemanticModel semanticModel, Optional<Symbol> aiModelProviderSymbolOpt, AiCodeModifier.AnalysisData analyserData) {
            TypeDefinitionSymbol typeDefSymbol;
            this.semanticModel = semanticModel;
            this.typeMapper = analyserData.typeMapper;
            if (aiModelProviderSymbolOpt.isEmpty()) {
                this.modelProviderSymbol = null;
                return;
            }
            Symbol aiModelProviderSymbol = aiModelProviderSymbolOpt.get();
            this.modelProviderSymbol = aiModelProviderSymbol instanceof TypeDefinitionSymbol ? (typeDefSymbol = (TypeDefinitionSymbol)aiModelProviderSymbol) : null;
        }

        void generate(ModulePartNode modulePartNode) {
            if (this.modelProviderSymbol == null) {
                return;
            }
            this.visit(modulePartNode);
        }

        public void visit(RemoteMethodCallActionNode remoteMethodCallActionNode) {
            SimpleNameReferenceNode methodName = remoteMethodCallActionNode.methodName();
            if (!methodName.name().text().equals(GENERATE_METHOD_NAME)) {
                this.visitSyntaxNode((Node)remoteMethodCallActionNode);
                return;
            }
            ExpressionNode expression = remoteMethodCallActionNode.expression();
            this.semanticModel.typeOf((Node)expression).ifPresent(expressionTypeSymbol -> {
                if (expressionTypeSymbol.subtypeOf(this.modelProviderSymbol.typeDescriptor())) {
                    this.updateTypeSchemaForTypeDef(remoteMethodCallActionNode);
                }
            });
        }

        private void updateTypeSchemaForTypeDef(RemoteMethodCallActionNode remoteMethodCallActionNode) {
            this.semanticModel.typeOf((Node)remoteMethodCallActionNode).ifPresent(symbol -> GenerateMethodJsonSchemaGenerator.populateTypeSchema(symbol, this.typeMapper, GenerateMethodModificationTask.this.modifierData.typeSchemas, this.semanticModel.types().ANYDATA));
        }

        private static void populateTypeSchema(TypeSymbol memberType, TypeMapper typeMapper, Map<String, String> typeSchemas, TypeSymbol anydataType) {
            TypeSymbol typeSymbol = memberType;
            Objects.requireNonNull(typeSymbol);
            TypeSymbol typeSymbol2 = typeSymbol;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TypeReferenceTypeSymbol.class, ArrayTypeSymbol.class, TupleTypeSymbol.class, RecordTypeSymbol.class, UnionTypeSymbol.class}, (Object)typeSymbol2, n)) {
                case 0: {
                    TypeReferenceTypeSymbol typeReference = (TypeReferenceTypeSymbol)typeSymbol2;
                    if (!typeReference.subtypeOf(anydataType)) {
                        return;
                    }
                    typeSchemas.put((String)typeReference.definition().getName().get(), GenerateMethodJsonSchemaGenerator.getJsonSchema(typeMapper.getSchema((TypeSymbol)typeReference)));
                    break;
                }
                case 1: {
                    ArrayTypeSymbol arrayType = (ArrayTypeSymbol)typeSymbol2;
                    GenerateMethodJsonSchemaGenerator.populateTypeSchema(arrayType.memberTypeDescriptor(), typeMapper, typeSchemas, anydataType);
                    break;
                }
                case 2: {
                    TupleTypeSymbol tupleType = (TupleTypeSymbol)typeSymbol2;
                    tupleType.members().forEach(member -> GenerateMethodJsonSchemaGenerator.populateTypeSchema(member.typeDescriptor(), typeMapper, typeSchemas, anydataType));
                    break;
                }
                case 3: {
                    RecordTypeSymbol recordType = (RecordTypeSymbol)typeSymbol2;
                    recordType.fieldDescriptors().values().forEach(field -> GenerateMethodJsonSchemaGenerator.populateTypeSchema(field.typeDescriptor(), typeMapper, typeSchemas, anydataType));
                    break;
                }
                case 4: {
                    UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol2;
                    unionTypeSymbol.memberTypeDescriptors().forEach(member -> GenerateMethodJsonSchemaGenerator.populateTypeSchema(member, typeMapper, typeSchemas, anydataType));
                    break;
                }
            }
        }

        private static String getJsonSchema(Schema schema) {
            GenerateMethodJsonSchemaGenerator.modifySchema(schema);
            OpenAPISchema2JsonSchema openAPISchema2JsonSchema = new OpenAPISchema2JsonSchema();
            openAPISchema2JsonSchema.process(schema);
            String newLineRegex = "\\R";
            String jsonCompressionRegex = "\\s*([{}\\[\\]:,])\\s*";
            return Json.pretty((Object)schema.getJsonSchema()).replaceAll(newLineRegex, "").replaceAll(jsonCompressionRegex, "$1");
        }

        private static void modifySchema(Schema schema) {
            List oneOf;
            List anyOf;
            List allOf;
            if (schema == null) {
                return;
            }
            GenerateMethodJsonSchemaGenerator.modifySchema(schema.getItems());
            GenerateMethodJsonSchemaGenerator.modifySchema(schema.getNot());
            Map properties = schema.getProperties();
            if (properties != null) {
                properties.values().forEach(GenerateMethodJsonSchemaGenerator::modifySchema);
            }
            if ((allOf = schema.getAllOf()) != null) {
                schema.setType(null);
                allOf.forEach(GenerateMethodJsonSchemaGenerator::modifySchema);
            }
            if ((anyOf = schema.getAnyOf()) != null) {
                schema.setType(null);
                anyOf.forEach(GenerateMethodJsonSchemaGenerator::modifySchema);
            }
            if ((oneOf = schema.getOneOf()) != null) {
                schema.setType(null);
                oneOf.forEach(GenerateMethodJsonSchemaGenerator::modifySchema);
            }
            if (BYTE.equals(schema.getFormat()) && STRING.equals(schema.getType())) {
                schema.setFormat(null);
                schema.setType(NUMBER);
            }
            GenerateMethodJsonSchemaGenerator.removeUnwantedFields(schema);
        }

        private static void removeUnwantedFields(Schema schema) {
            schema.setSpecVersion(null);
            schema.setSpecVersion(null);
            schema.setContains(null);
            schema.set$id(null);
            schema.set$schema(null);
            schema.set$anchor(null);
            schema.setExclusiveMaximumValue(null);
            schema.setExclusiveMinimumValue(null);
            schema.setDiscriminator(null);
            schema.setTitle(null);
            schema.setMaximum(null);
            schema.setExclusiveMaximum(null);
            schema.setMinimum(null);
            schema.setExclusiveMinimum(null);
            schema.setMaxLength(null);
            schema.setMinLength(null);
            schema.setMaxItems(null);
            schema.setMinItems(null);
            schema.setMaxProperties(null);
            schema.setMinProperties(null);
            schema.setAdditionalProperties(null);
            schema.setAdditionalProperties(null);
            schema.set$ref(null);
            schema.set$ref(null);
            schema.setReadOnly(null);
            schema.setWriteOnly(null);
            schema.setExample(null);
            schema.setExample(null);
            schema.setExternalDocs(null);
            schema.setDeprecated(null);
            schema.setPrefixItems(null);
            schema.setContentEncoding(null);
            schema.setContentMediaType(null);
            schema.setContentSchema(null);
            schema.setPropertyNames(null);
            schema.setUnevaluatedProperties(null);
            schema.setMaxContains(null);
            schema.setMinContains(null);
            schema.setAdditionalItems(null);
            schema.setUnevaluatedItems(null);
            schema.setIf(null);
            schema.setElse(null);
            schema.setThen(null);
            schema.setDependentSchemas(null);
            schema.set$comment(null);
            schema.setExamples(null);
            schema.setExtensions(null);
            schema.setConst(null);
        }

        public void visit(Node node) {
            this.visitSyntaxNode(node);
        }
    }
}

