/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai.plugin;

import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import java.util.Optional;
import java.util.Set;

class InitFunctionAnalysisTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private static final String INIT_METHOD_NAME = "init";
    Set<ModuleId> modulesWithPredefinedInitMethods;

    public InitFunctionAnalysisTask(Set<ModuleId> modulesWithInitMethod) {
        this.modulesWithPredefinedInitMethods = modulesWithInitMethod;
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        Optional symbol = context.semanticModel().symbol(context.node());
        if (symbol.isEmpty()) {
            return;
        }
        if (((Symbol)symbol.get()).kind() != SymbolKind.FUNCTION) {
            return;
        }
        FunctionSymbol functionSymbol = (FunctionSymbol)symbol.get();
        if (functionSymbol.getName().isEmpty() || !((String)functionSymbol.getName().get()).equals(INIT_METHOD_NAME)) {
            return;
        }
        this.modulesWithPredefinedInitMethods.add(context.documentId().moduleId());
    }
}

