/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai.plugin;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.ai.plugin.ModifierContext;
import io.ballerina.stdlib.ai.plugin.diagnostics.CompilationDiagnostic;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.Location;
import java.util.Map;
import java.util.Optional;

class ModuleLevelAgentAnalysisTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private static final String AGENT_CLASS_NAME = "Agent";
    private static final String AI_MODULE_NAME = "ai";
    private final Map<DocumentId, ModifierContext> modifierContextMap;

    public ModuleLevelAgentAnalysisTask(Map<DocumentId, ModifierContext> modifierContextMap) {
        this.modifierContextMap = modifierContextMap;
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        Optional symbol = context.semanticModel().symbol(context.node());
        if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.VARIABLE) {
            return;
        }
        ModuleVariableDeclarationNode moduleVariableDeclarationNode = (ModuleVariableDeclarationNode)context.node();
        TypeDescriptorNode typeDescriptorNode = moduleVariableDeclarationNode.typedBindingPattern().typeDescriptor();
        if (typeDescriptorNode.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            return;
        }
        QualifiedNameReferenceNode nameReferenceNode = (QualifiedNameReferenceNode)typeDescriptorNode;
        IdentifierToken identifier = nameReferenceNode.identifier();
        Token modulePrefix = nameReferenceNode.modulePrefix();
        String agentModulePrefix = this.getAgentModuleNamePrefix(context);
        if (!identifier.text().equals(AGENT_CLASS_NAME) || !modulePrefix.text().equals(agentModulePrefix) || moduleVariableDeclarationNode.initializer().isEmpty()) {
            return;
        }
        this.validateAgentFinalQualifier(context, moduleVariableDeclarationNode);
        this.addToModifierContext(context, moduleVariableDeclarationNode);
    }

    private void validateAgentFinalQualifier(SyntaxNodeAnalysisContext context, ModuleVariableDeclarationNode moduleVariableDeclarationNode) {
        boolean hasFinalKeyword = moduleVariableDeclarationNode.qualifiers().stream().anyMatch(qualifier -> SyntaxKind.FINAL_KEYWORD.stringValue().equals(qualifier.text()));
        if (!hasFinalKeyword) {
            Diagnostic diagnostic = CompilationDiagnostic.getDiagnostic(CompilationDiagnostic.AGENT_MUST_BE_FINAL, (Location)moduleVariableDeclarationNode.location(), new Object[0]);
            context.reportDiagnostic(diagnostic);
        }
    }

    private void addToModifierContext(SyntaxNodeAnalysisContext context, ModuleVariableDeclarationNode moduleVariableDeclarationNode) {
        this.modifierContextMap.computeIfAbsent(context.documentId(), document -> new ModifierContext()).add(moduleVariableDeclarationNode);
    }

    private String getAgentModuleNamePrefix(SyntaxNodeAnalysisContext context) {
        Node rootNode = context.syntaxTree().rootNode();
        if (rootNode.kind() == SyntaxKind.MODULE_PART) {
            ModulePartNode modulePartNode = (ModulePartNode)rootNode;
            Optional<ImportDeclarationNode> agentModuleImport = modulePartNode.imports().stream().filter(importDeclarationNode -> {
                SeparatedNodeList moduleName = importDeclarationNode.moduleName();
                Optional orgNameOpt = importDeclarationNode.orgName();
                return moduleName.size() == 1 && ((IdentifierToken)moduleName.get(0)).text().contains(AI_MODULE_NAME) && orgNameOpt.isPresent() && ((ImportOrgNameNode)orgNameOpt.get()).orgName().text().equals("ballerina");
            }).findFirst();
            if (agentModuleImport.isEmpty() || agentModuleImport.get().prefix().isEmpty()) {
                return AI_MODULE_NAME;
            }
            return ((ImportPrefixNode)agentModuleImport.get().prefix().get()).prefix().text().trim();
        }
        return AI_MODULE_NAME;
    }
}

