/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai.plugin;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.model.ServiceDeclaration;
import io.ballerina.openapi.service.mapper.utils.CodegenUtils;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.ai.plugin.ChatServiceOpenAPISchema;
import io.ballerina.stdlib.ai.plugin.ListenerVisitor;
import io.ballerina.stdlib.ai.plugin.ServersMapper;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextRange;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class OpenAPIGenerator
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    public static final String OPENAPI = "openapi";
    public static final String OAS_PATH_SEPARATOR = "/";
    public static final String UNDERSCORE = "_";
    public static final String BALLERINA = "ballerina";
    public static final String AI_AGENT = "ai";
    public static final String EMPTY = "";
    public static final String LISTENER = "Listener";
    static boolean isErrorPrinted = false;

    static void setIsWarningPrinted() {
        isErrorPrinted = true;
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        SemanticModel semanticModel = context.semanticModel();
        SyntaxTree syntaxTree = context.syntaxTree();
        Package currentPackage = context.currentPackage();
        Project project = currentPackage.project();
        BuildOptions buildOptions = project.buildOptions();
        if (!buildOptions.exportOpenAPI()) {
            return;
        }
        boolean hasErrors = context.compilation().diagnosticResult().diagnostics().stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity()));
        if (hasErrors) {
            if (!isErrorPrinted) {
                OpenAPIGenerator.setIsWarningPrinted();
                PrintStream outStream = System.out;
                outStream.println("openapi contract generation for ai service is skipped because of the following compilation error(s) in the ballerina package:");
            }
            return;
        }
        Path outPath = project.targetDir();
        ServiceDeclarationNode serviceNode = (ServiceDeclarationNode)context.node();
        HashMap<Integer, String> services = new HashMap<Integer, String>();
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (MapperCommonUtils.containErrors((List)semanticModel.diagnostics())) {
            diagnostics.addAll(semanticModel.diagnostics());
        } else if (OpenAPIGenerator.isAiAgentService(serviceNode, semanticModel)) {
            this.generateOpenAPISpec(semanticModel, serviceNode, syntaxTree, services, project, outPath, diagnostics);
        }
        if (!diagnostics.isEmpty()) {
            for (Diagnostic diagnostic : diagnostics) {
                context.reportDiagnostic(diagnostic);
            }
        }
    }

    private void generateOpenAPISpec(SemanticModel semanticModel, ServiceDeclarationNode serviceNode, SyntaxTree syntaxTree, Map<Integer, String> services, Project project, Path outPath, List<Diagnostic> diagnostics) {
        Optional serviceSymbol = semanticModel.symbol((Node)serviceNode);
        if (serviceSymbol.isEmpty() || !(serviceSymbol.get() instanceof ServiceDeclarationSymbol)) {
            return;
        }
        OpenAPIGenerator.extractServiceNodes((ModulePartNode)syntaxTree.rootNode(), services, semanticModel);
        ListenerVisitor listenerVisitor = OpenAPIGenerator.extractListenersFromDefaultModule(project);
        Set<ListenerDeclarationNode> listeners = listenerVisitor.getListenerDeclarationNodes();
        OpenAPI chatServiceSchema = ChatServiceOpenAPISchema.generate();
        ServersMapper serversMapper = new ServersMapper(chatServiceSchema, listeners, serviceNode, semanticModel);
        serversMapper.setServers();
        diagnostics.addAll(serversMapper.getDiagnostics());
        String fileName = this.constructFileName(syntaxTree, services, (Symbol)serviceSymbol.get());
        this.writeOpenAPIYaml(outPath, chatServiceSchema, fileName, diagnostics);
    }

    public static ListenerVisitor extractListenersFromDefaultModule(Project project) {
        ListenerVisitor listenerVisitor = new ListenerVisitor();
        Module module = project.currentPackage().module(project.currentPackage().getDefaultModule().moduleId());
        module.documentIds().forEach(documentId -> {
            SyntaxTree syntaxTreeDoc = module.document(documentId).syntaxTree();
            syntaxTreeDoc.rootNode().accept((NodeVisitor)listenerVisitor);
        });
        return listenerVisitor;
    }

    public static boolean isAiAgentService(ServiceDeclarationNode serviceNode, SemanticModel semanticModel) {
        Object t;
        Optional serviceSymbol = semanticModel.symbol((Node)serviceNode);
        if (serviceSymbol.isEmpty() || !((t = serviceSymbol.get()) instanceof ServiceDeclarationSymbol)) {
            return false;
        }
        ServiceDeclarationSymbol serviceNodeSymbol = (ServiceDeclarationSymbol)t;
        Optional listenerTypeSymbol = semanticModel.types().getTypeByName(BALLERINA, AI_AGENT, EMPTY, LISTENER);
        if (listenerTypeSymbol.isEmpty() || ((Symbol)listenerTypeSymbol.get()).kind() != SymbolKind.CLASS) {
            return false;
        }
        return serviceNodeSymbol.listenerTypes().stream().anyMatch(listenerType -> OpenAPIGenerator.isAiAgentListener(listenerType, (TypeSymbol)((ClassSymbol)listenerTypeSymbol.get())));
    }

    private static boolean isAiAgentListener(TypeSymbol listenerType, TypeSymbol aiAgentListenerType) {
        return aiAgentListenerType.subtypeOf(listenerType);
    }

    private String constructFileName(SyntaxTree syntaxTree, Map<Integer, String> services, Symbol serviceSymbol) {
        String fileName = MapperCommonUtils.getNormalizedFileName((String)services.get(serviceSymbol.hashCode()));
        String balFileName = syntaxTree.filePath().replaceAll(OAS_PATH_SEPARATOR, UNDERSCORE).split("\\.")[0];
        if (fileName.equals(OAS_PATH_SEPARATOR)) {
            return balFileName + "_openapi.yaml";
        }
        if (fileName.contains("-") && fileName.split("-")[0].equals(OAS_PATH_SEPARATOR) || fileName.isBlank()) {
            return balFileName + UNDERSCORE + serviceSymbol.hashCode() + "_openapi.yaml";
        }
        return fileName + "_openapi.yaml";
    }

    private void writeOpenAPIYaml(Path outPath, OpenAPI openAPI, String serviceName, List<Diagnostic> diagnostics) {
        String yamlOpenApiSpec = Yaml.pretty((Object)openAPI);
        if (yamlOpenApiSpec != null) {
            try {
                Files.createDirectories(Paths.get(String.valueOf(outPath) + "/openapi", new String[0]), new FileAttribute[0]);
                String fileName = CodegenUtils.resolveContractFileName((Path)outPath.resolve(OPENAPI), (String)serviceName, (Boolean)false);
                CodegenUtils.writeFile((Path)outPath.resolve("openapi/" + fileName), (String)yamlOpenApiSpec);
            }
            catch (IOException e) {
                ExceptionDiagnostic diagnostic = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_108, new String[]{e.toString()});
                diagnostics.add(OpenAPIGenerator.getDiagnostics((OpenAPIMapperDiagnostic)diagnostic));
            }
        }
    }

    private static void extractServiceNodes(ModulePartNode modulePartNode, Map<Integer, String> services, SemanticModel semanticModel) {
        ArrayList<String> allServices = new ArrayList<String>();
        for (Node node : modulePartNode.members()) {
            Optional serviceSymbol;
            ServiceDeclarationNode serviceNode;
            SyntaxKind syntaxKind = node.kind();
            if (!syntaxKind.equals((Object)SyntaxKind.SERVICE_DECLARATION) || !OpenAPIGenerator.isAiAgentService(serviceNode = (ServiceDeclarationNode)node, semanticModel) || !(serviceSymbol = semanticModel.symbol((Node)serviceNode)).isPresent() || !(serviceSymbol.get() instanceof ServiceDeclarationSymbol)) continue;
            String service = new ServiceDeclaration(serviceNode, semanticModel).absoluteResourcePath();
            Object updateServiceName = service;
            if (allServices.contains(service)) {
                updateServiceName = service + "-" + ((Symbol)serviceSymbol.get()).hashCode();
            } else {
                allServices.add(service);
            }
            services.put(((Symbol)serviceSymbol.get()).hashCode(), (String)updateServiceName);
        }
    }

    public static Diagnostic getDiagnostics(OpenAPIMapperDiagnostic diagnostic) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnostic.getCode(), diagnostic.getMessage(), diagnostic.getDiagnosticSeverity());
        Location location = diagnostic.getLocation().orElse(new NullLocation());
        return DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]);
    }

    public static class NullLocation
    implements Location {
        public LineRange lineRange() {
            LinePosition from = LinePosition.from((int)0, (int)0);
            return LineRange.from((String)OpenAPIGenerator.EMPTY, (LinePosition)from, (LinePosition)from);
        }

        public TextRange textRange() {
            return TextRange.from((int)0, (int)0);
        }
    }
}

