/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai.plugin;

import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.openapi.service.mapper.type.TypeMapperImpl;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.ai.plugin.Utils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.OpenAPISchema2JsonSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SchemaUtils {
    private static final String STRING = "string";
    private static final String BYTE = "byte";
    private static final String NUMBER = "number";

    private SchemaUtils() {
    }

    public static String getParameterSchema(FunctionSymbol functionSymbol, SyntaxNodeAnalysisContext context) throws Exception {
        FunctionTypeSymbol functionTypeSymbol = functionSymbol.typeDescriptor();
        List parameterSymbolList = (List)functionTypeSymbol.params().get();
        if (functionTypeSymbol.params().isEmpty() || parameterSymbolList.isEmpty()) {
            return "()";
        }
        HashMap<String, String> individualParamSchema = new HashMap<String, String>();
        ArrayList<String> requiredParams = new ArrayList<String>();
        TypeMapperImpl typeMapper = new TypeMapperImpl(context);
        for (ParameterSymbol parameterSymbol : parameterSymbolList) {
            try {
                if (Utils.isAiContextType(parameterSymbol.typeDescriptor(), context)) continue;
                String parameterName = (String)parameterSymbol.getName().orElseThrow();
                if (parameterSymbol.paramKind() != ParameterKind.DEFAULTABLE) {
                    requiredParams.add(parameterName);
                }
                Schema schema = typeMapper.getSchema(parameterSymbol.typeDescriptor());
                String parameterDescription = Utils.getParameterDescription(functionSymbol, parameterName);
                schema.setDescription(parameterDescription);
                String jsonSchema = SchemaUtils.getJsonSchema(schema);
                individualParamSchema.put(parameterName, jsonSchema);
            }
            catch (RuntimeException e) {
                throw new Exception(e);
            }
        }
        String properties = individualParamSchema.entrySet().stream().map(entry -> String.format("\"%s\": %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", ", "{", "}"));
        String required = requiredParams.stream().map(paramName -> String.format("\"%s\"", paramName)).collect(Collectors.joining(", ", "[", "]"));
        return String.format("{\"type\":\"object\",\"required\":%s,\"properties\":%s}", required, properties);
    }

    private static String getJsonSchema(Schema schema) {
        SchemaUtils.modifySchema(schema);
        OpenAPISchema2JsonSchema openAPISchema2JsonSchema = new OpenAPISchema2JsonSchema();
        openAPISchema2JsonSchema.process(schema);
        String newLineRegex = "\\R";
        String jsonCompressionRegex = "\\s*([{}\\[\\]:,])\\s*";
        return Json.pretty((Object)schema.getJsonSchema()).replaceAll(newLineRegex, "").replaceAll(jsonCompressionRegex, "$1");
    }

    private static void modifySchema(Schema schema) {
        List oneOf;
        List anyOf;
        List allOf;
        if (schema == null) {
            return;
        }
        SchemaUtils.modifySchema(schema.getItems());
        SchemaUtils.modifySchema(schema.getNot());
        Map properties = schema.getProperties();
        if (properties != null) {
            properties.values().forEach(SchemaUtils::modifySchema);
        }
        if ((allOf = schema.getAllOf()) != null) {
            schema.setType(null);
            allOf.forEach(SchemaUtils::modifySchema);
        }
        if ((anyOf = schema.getAnyOf()) != null) {
            schema.setType(null);
            anyOf.forEach(SchemaUtils::modifySchema);
        }
        if ((oneOf = schema.getOneOf()) != null) {
            schema.setType(null);
            oneOf.forEach(SchemaUtils::modifySchema);
        }
        if (BYTE.equals(schema.getFormat()) && STRING.equals(schema.getType())) {
            schema.setFormat(null);
            schema.setType(NUMBER);
        }
        SchemaUtils.removeUnwantedFields(schema);
    }

    private static void removeUnwantedFields(Schema schema) {
        schema.setSpecVersion(null);
        schema.setSpecVersion(null);
        schema.setContains(null);
        schema.set$id(null);
        schema.set$schema(null);
        schema.set$anchor(null);
        schema.setExclusiveMaximumValue(null);
        schema.setExclusiveMinimumValue(null);
        schema.setDiscriminator(null);
        schema.setTitle(null);
        schema.setMaximum(null);
        schema.setExclusiveMaximum(null);
        schema.setMinimum(null);
        schema.setExclusiveMinimum(null);
        schema.setMaxLength(null);
        schema.setMinLength(null);
        schema.setMaxItems(null);
        schema.setMinItems(null);
        schema.setMaxProperties(null);
        schema.setMinProperties(null);
        schema.setAdditionalProperties(null);
        schema.setAdditionalProperties(null);
        schema.set$ref(null);
        schema.set$ref(null);
        schema.setReadOnly(null);
        schema.setWriteOnly(null);
        schema.setExample(null);
        schema.setExample(null);
        schema.setExternalDocs(null);
        schema.setDeprecated(null);
        schema.setPrefixItems(null);
        schema.setContentEncoding(null);
        schema.setContentMediaType(null);
        schema.setContentSchema(null);
        schema.setPropertyNames(null);
        schema.setUnevaluatedProperties(null);
        schema.setMaxContains(null);
        schema.setMinContains(null);
        schema.setAdditionalItems(null);
        schema.setUnevaluatedItems(null);
        schema.setIf(null);
        schema.setElse(null);
        schema.setThen(null);
        schema.setDependentSchemas(null);
        schema.set$comment(null);
        schema.setExamples(null);
        schema.setExtensions(null);
        schema.setConst(null);
    }
}

