/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai.plugin;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.ballerina.stdlib.ai.plugin.OpenAPIGenerator;
import io.ballerina.stdlib.ai.plugin.diagnostics.CompilationDiagnostic;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ServersMapper {
    private static final String SERVER = "server";
    private static final String PORT = "port";
    private static final String HOST_FIELD_NAME = "host";
    private static final String LISTEN_ON = "listenOn";
    private static final String DEFAULT_HTTP_PORT = "9090";
    private static final String PORT_443 = "443";
    private static final String HTTPS_LOCALHOST = "https://localhost";
    private static final String HTTP_LOCALHOST = "http://localhost";
    private final OpenAPI openAPI;
    private final Map<String, ListenerDeclarationNode> endpoints;
    private final ServiceDeclarationNode service;
    private final SemanticModel semanticModel;
    private final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

    public ServersMapper(OpenAPI openAPI, Set<ListenerDeclarationNode> endpoints, ServiceDeclarationNode service, SemanticModel semanticModel) {
        this.openAPI = openAPI;
        this.endpoints = ServersMapper.mapEndpoints(endpoints);
        this.service = service;
        this.semanticModel = semanticModel;
    }

    private static Map<String, ListenerDeclarationNode> mapEndpoints(Set<ListenerDeclarationNode> nodes) {
        return nodes.stream().collect(Collectors.toMap(node -> node.variableName().text(), Function.identity()));
    }

    public void setServers() {
        this.extractServersFromServiceExpressions();
        List servers = this.openAPI.getServers();
        if (!this.endpoints.isEmpty()) {
            for (ListenerDeclarationNode endpoint : this.endpoints.values()) {
                for (ExpressionNode expression : this.service.expressions()) {
                    this.addServerForEndpoint(servers, endpoint, expression);
                }
            }
        }
        if (this.isServerListEmpty()) {
            this.openAPI.setServers(Collections.singletonList(this.getDefaultServerWithBasePath(this.getServiceBasePath())));
        } else if (servers.size() > 1) {
            this.openAPI.setServers(Collections.singletonList(ServersMapper.mergeServerEnums(servers)));
        }
    }

    private boolean isServerListEmpty() {
        return this.openAPI.getServers().isEmpty() || this.openAPI.getServers().stream().allMatch(server -> server.getUrl() == null && (server.getVariables() == null || server.getVariables().isEmpty()));
    }

    private void addServerForEndpoint(List<Server> servers, ListenerDeclarationNode endpoint, ExpressionNode expNode) {
        QualifiedNameReferenceNode qualifiedNameReferenceNode;
        boolean matchesEndpoint;
        String endpointName = endpoint.variableName().text().trim();
        boolean bl = matchesEndpoint = expNode instanceof QualifiedNameReferenceNode && (qualifiedNameReferenceNode = (QualifiedNameReferenceNode)expNode).identifier().text().trim().equals(endpointName) || expNode.toString().trim().equals(endpointName);
        if (matchesEndpoint) {
            servers.add(this.extractServer(endpoint, this.getServiceBasePath()));
        }
    }

    private static Server mergeServerEnums(List<Server> servers) {
        if (servers.isEmpty()) {
            return null;
        }
        Server mainServer = servers.getFirst();
        ServerVariables mainVars = mainServer.getVariables();
        ServerVariable hostVar = (ServerVariable)mainVars.get((Object)SERVER);
        ServerVariable portVar = (ServerVariable)mainVars.get((Object)PORT);
        if (servers.size() > 1) {
            ArrayList<Server> rotated = new ArrayList<Server>(servers);
            Collections.rotate(rotated, servers.size() - 1);
            for (Server server : rotated) {
                ServerVariables vars = server.getVariables();
                if (vars.get((Object)SERVER) != null) {
                    hostVar.addEnumItem(((ServerVariable)vars.get((Object)SERVER)).getDefault());
                }
                if (vars.get((Object)PORT) == null) continue;
                portVar.addEnumItem(((ServerVariable)vars.get((Object)PORT)).getDefault());
            }
        }
        return mainServer;
    }

    private Server extractServer(ListenerDeclarationNode endpoint, String basePath) {
        Optional<ParenthesizedArgList> argList;
        Node initializer = endpoint.initializer();
        if (initializer.kind() == SyntaxKind.CHECK_EXPRESSION) {
            ExpressionNode innerExpr = ((CheckExpressionNode)initializer).expression();
            argList = ServersMapper.extractParenthesizedArgList((Node)innerExpr);
        } else {
            argList = ServersMapper.extractParenthesizedArgList(initializer);
        }
        return this.generateServer(basePath, argList);
    }

    private static Optional<ParenthesizedArgList> extractParenthesizedArgList(Node expression) {
        return switch (expression.kind()) {
            case SyntaxKind.EXPLICIT_NEW_EXPRESSION -> Optional.ofNullable(((ExplicitNewExpressionNode)expression).parenthesizedArgList());
            case SyntaxKind.IMPLICIT_NEW_EXPRESSION -> ((ImplicitNewExpressionNode)expression).parenthesizedArgList();
            default -> Optional.empty();
        };
    }

    private void extractServersFromServiceExpressions() {
        ArrayList<Server> servers = new ArrayList<Server>();
        String basePath = this.getServiceBasePath();
        for (ExpressionNode expression : this.service.expressions()) {
            if (expression.kind() != SyntaxKind.EXPLICIT_NEW_EXPRESSION) continue;
            ExplicitNewExpressionNode explicit = (ExplicitNewExpressionNode)expression;
            servers.add(this.generateServer(basePath, Optional.ofNullable(explicit.parenthesizedArgList())));
        }
        this.openAPI.setServers(servers);
    }

    private Server generateServer(String basePath, Optional<ParenthesizedArgList> argListOpt) {
        SeparatedNodeList args;
        ServerVariables serverVars = new ServerVariables();
        String port = null;
        String host = null;
        if (argListOpt.isPresent() && !(args = argListOpt.get().arguments()).isEmpty()) {
            NamedArgumentNode namedArg;
            FunctionArgumentNode firstArg = (FunctionArgumentNode)args.get(0);
            if (firstArg instanceof PositionalArgumentNode) {
                PositionalArgumentNode posArg = (PositionalArgumentNode)firstArg;
                symbol = this.semanticModel.symbol((Node)posArg.expression());
                if (symbol.isPresent() && symbol.get() instanceof VariableSymbol && this.endpoints.containsKey(posArg.expression().toSourceCode().strip())) {
                    String varName = posArg.expression().toSourceCode().strip();
                    Optional<ParenthesizedArgList> httpListenerArgList = ServersMapper.extractParenthesizedArgList(this.endpoints.get(varName).initializer());
                    return this.generateServer(basePath, httpListenerArgList);
                }
                port = this.getValidPort(firstArg);
            } else if (firstArg instanceof NamedArgumentNode && ((namedArg = (NamedArgumentNode)firstArg).argumentName().name().text().strip().equals(PORT) || namedArg.argumentName().name().text().strip().equals(LISTEN_ON))) {
                symbol = this.semanticModel.symbol((Node)namedArg.expression());
                if (symbol.isPresent() && symbol.get() instanceof VariableSymbol && this.endpoints.containsKey(namedArg.expression().toSourceCode().strip())) {
                    String varName = namedArg.expression().toSourceCode().strip();
                    Optional<ParenthesizedArgList> httpListenerArgList = ServersMapper.extractParenthesizedArgList(this.endpoints.get(varName).initializer());
                    return this.generateServer(basePath, httpListenerArgList);
                }
                port = this.getValidPort(firstArg);
            }
            if (args.size() > 1) {
                PositionalArgumentNode posArg;
                ExpressionNode expressionNode;
                FunctionArgumentNode secondArg = (FunctionArgumentNode)args.get(1);
                if (secondArg instanceof NamedArgumentNode && HOST_FIELD_NAME.equals((namedArg = (NamedArgumentNode)secondArg).argumentName().name().text())) {
                    host = this.extractHost(namedArg);
                } else if (secondArg instanceof PositionalArgumentNode && (expressionNode = (posArg = (PositionalArgumentNode)secondArg).expression()) instanceof MappingConstructorExpressionNode) {
                    MappingConstructorExpressionNode mapping = (MappingConstructorExpressionNode)expressionNode;
                    host = ServersMapper.extractHost(mapping);
                }
            }
        }
        return this.buildServer(basePath, port, host, serverVars);
    }

    private String extractHost(NamedArgumentNode namedArg) {
        ExpressionNode expressionNode = namedArg.expression();
        if (expressionNode instanceof BasicLiteralNode) {
            BasicLiteralNode bln = (BasicLiteralNode)expressionNode;
            return bln.toSourceCode().replaceAll("\"", "").trim();
        }
        return null;
    }

    private static String extractHost(MappingConstructorExpressionNode mapping) {
        for (MappingFieldNode field : mapping.fields()) {
            SpecificFieldNode specific;
            if (!(field instanceof SpecificFieldNode) || !HOST_FIELD_NAME.equals((specific = (SpecificFieldNode)field).fieldName().toString()) || !specific.valueExpr().isPresent()) continue;
            return ((ExpressionNode)specific.valueExpr().get()).toString().replaceAll("\"", "");
        }
        return null;
    }

    private String getValidPort(FunctionArgumentNode functionArgumentNode) {
        String text = functionArgumentNode.toString();
        if (functionArgumentNode instanceof NamedArgumentNode) {
            NamedArgumentNode namedArgumentNode = (NamedArgumentNode)functionArgumentNode;
            text = namedArgumentNode.expression().toSourceCode().trim();
        } else if (functionArgumentNode instanceof PositionalArgumentNode) {
            PositionalArgumentNode positionalArgumentNode = (PositionalArgumentNode)functionArgumentNode;
            text = positionalArgumentNode.expression().toSourceCode().trim();
        }
        if (text.matches(".*http:getDefaultListener.*$")) {
            return DEFAULT_HTTP_PORT;
        }
        if (text.matches("\\d+")) {
            return text;
        }
        this.addDiagnosticWarning(CompilationDiagnostic.UNABLE_TO_OBTAIN_VALID_SERVER_PORT_FROM_EXPRESSION, (Location)functionArgumentNode.location(), functionArgumentNode.toSourceCode().strip(), DEFAULT_HTTP_PORT);
        return DEFAULT_HTTP_PORT;
    }

    private Server buildServer(String basePath, String port, String host, ServerVariables serverVars) {
        if (port == null) {
            this.addDiagnosticWarning(CompilationDiagnostic.UNABLE_TO_OBTAIN_VALID_SERVER_PORT, new OpenAPIGenerator.NullLocation(), DEFAULT_HTTP_PORT);
            port = DEFAULT_HTTP_PORT;
        }
        ServerVariable serverVar = new ServerVariable();
        serverVar._default(host != null ? host : (port.equals(PORT_443) ? HTTPS_LOCALHOST : HTTP_LOCALHOST));
        ServerVariable portVar = new ServerVariable();
        portVar._default(port);
        serverVars.addServerVariable(SERVER, serverVar);
        serverVars.addServerVariable(PORT, portVar);
        Server server = new Server();
        server.setVariables(serverVars);
        server.setUrl(String.format("{server}:{port}%s", basePath));
        return server;
    }

    private void addDiagnosticWarning(CompilationDiagnostic compilationDiagnostic, Location location, Object ... args) {
        Diagnostic diagnostic = CompilationDiagnostic.getDiagnostic(compilationDiagnostic, location, args);
        this.diagnostics.add(diagnostic);
    }

    private Server getDefaultServerWithBasePath(String basePath) {
        return this.buildServer(basePath, null, null, new ServerVariables());
    }

    private String getServiceBasePath() {
        StringBuilder path = new StringBuilder();
        for (Node node : this.service.absoluteResourcePath()) {
            path.append(MapperCommonUtils.unescapeIdentifier((String)node.toString()));
        }
        return path.toString().trim();
    }

    public List<Diagnostic> getDiagnostics() {
        return Collections.unmodifiableList(this.diagnostics);
    }
}

