/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai.plugin;

import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.ai.plugin.ModifierContext;
import io.ballerina.stdlib.ai.plugin.SchemaUtils;
import io.ballerina.stdlib.ai.plugin.ToolAnnotationConfig;
import io.ballerina.stdlib.ai.plugin.Utils;
import io.ballerina.stdlib.ai.plugin.XmlTypeInspector;
import io.ballerina.stdlib.ai.plugin.diagnostics.CompilationDiagnostic;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

class ToolAnnotationAnalysisTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    public static final String EMPTY_STRING = "";
    public static final String NIL_EXPRESSION = "()";
    private static final String UNKNOWN_SYMBOL = "<unknown>";
    private final Map<DocumentId, ModifierContext> modifierContextMap;
    private SyntaxNodeAnalysisContext context;

    ToolAnnotationAnalysisTask(Map<DocumentId, ModifierContext> modifierContextMap) {
        this.modifierContextMap = modifierContextMap;
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        this.context = context;
        Optional symbol = context.semanticModel().symbol(context.node());
        if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.ANNOTATION || !Utils.isAgentToolAnnotation((AnnotationSymbol)symbol.get())) {
            return;
        }
        AnnotationNode toolAnnotationNode = (AnnotationNode)context.node();
        Optional<FunctionDefinitionNode> functionDefinitionNode = this.getFunctionDefinitionNode(toolAnnotationNode);
        if (functionDefinitionNode.isEmpty()) {
            return;
        }
        Optional<FunctionSymbol> functionSymbol = this.getFunctionSymbol(functionDefinitionNode.get());
        if (functionSymbol.isEmpty() || functionSymbol.get().getName().isEmpty()) {
            return;
        }
        Location functionLocation = (Location)functionSymbol.get().getLocation().orElse(functionDefinitionNode.get().location());
        if (!this.hasValidParameterTypes(functionSymbol.get(), functionLocation) || !this.hasValidateReturnType(functionSymbol.get(), functionLocation)) {
            return;
        }
        if (this.hasSpreadAnnotationFieldValue(toolAnnotationNode)) {
            return;
        }
        ToolAnnotationConfig config = this.createAnnotationConfig(toolAnnotationNode, functionDefinitionNode.get());
        this.addToModifierContext(context, toolAnnotationNode, config);
    }

    private boolean hasSpreadAnnotationFieldValue(AnnotationNode toolAnnotationNode) {
        return toolAnnotationNode.annotValue().isPresent() && ((MappingConstructorExpressionNode)toolAnnotationNode.annotValue().get()).fields().size() == 1 && ((MappingFieldNode)((MappingConstructorExpressionNode)toolAnnotationNode.annotValue().get()).fields().get(0)).kind() == SyntaxKind.SPREAD_FIELD;
    }

    private boolean hasValidateReturnType(FunctionSymbol functionSymbol, Location functionLocation) {
        Optional returnType = functionSymbol.typeDescriptor().returnTypeDescriptor();
        if (returnType.isEmpty() || Utils.isAllowedReturnType((TypeSymbol)returnType.get(), this.context)) {
            return true;
        }
        Diagnostic diagnostic = CompilationDiagnostic.getDiagnostic(CompilationDiagnostic.INVALID_RETURN_TYPE_IN_TOOL, functionLocation, functionSymbol.getName().orElse("unknownFunction"));
        this.reportDiagnostic(diagnostic);
        return false;
    }

    private boolean hasValidParameterTypes(FunctionSymbol functionSymbol, Location alternativeLocation) {
        FunctionTypeSymbol functionTypeSymbol = functionSymbol.typeDescriptor();
        ArrayList parameterSymbolList = new ArrayList((Collection)functionTypeSymbol.params().get());
        if (functionTypeSymbol.params().isEmpty() || parameterSymbolList.isEmpty()) {
            return true;
        }
        ParameterSymbol firstParam = (ParameterSymbol)parameterSymbolList.getFirst();
        if (Utils.isAiContextType(firstParam.typeDescriptor(), this.context)) {
            parameterSymbolList.removeFirst();
        }
        boolean allAnydata = true;
        boolean hasXml = false;
        String functionName = functionSymbol.getName().orElse("unknownFunction");
        for (ParameterSymbol parameterSymbol : parameterSymbolList) {
            Diagnostic diagnostic;
            TypeSymbol paramTypeSymbol = parameterSymbol.typeDescriptor();
            if (Utils.isAiContextType(paramTypeSymbol, this.context)) {
                Diagnostic diagnostic2 = CompilationDiagnostic.getDiagnostic(CompilationDiagnostic.CONTEXT_PARAM_MUST_BE_FIRST, parameterSymbol.getLocation().orElse(alternativeLocation), functionName, parameterSymbol.getName().orElse(UNKNOWN_SYMBOL));
                this.reportDiagnostic(diagnostic2);
                allAnydata = false;
                continue;
            }
            XmlTypeInspector xmlTypeInspector = new XmlTypeInspector(this.context);
            if (xmlTypeInspector.includesXmlType(paramTypeSymbol)) {
                diagnostic = CompilationDiagnostic.getDiagnostic(CompilationDiagnostic.XML_PARAMETER_NOT_SUPPORTED_BY_TOOL, parameterSymbol.getLocation().orElse(alternativeLocation), functionName, parameterSymbol.getName().orElse(UNKNOWN_SYMBOL));
                this.reportDiagnostic(diagnostic);
                hasXml = true;
                continue;
            }
            if (Utils.isAnydataType(paramTypeSymbol, this.context)) continue;
            allAnydata = false;
            diagnostic = CompilationDiagnostic.getDiagnostic(CompilationDiagnostic.PARAMETER_IS_NOT_A_SUBTYPE_OF_ANYDATA, parameterSymbol.getLocation().orElse(alternativeLocation), functionName, parameterSymbol.getName().orElse(UNKNOWN_SYMBOL));
            this.reportDiagnostic(diagnostic);
        }
        return allAnydata && !hasXml;
    }

    private void reportDiagnostic(Diagnostic diagnostic) {
        this.context.reportDiagnostic(diagnostic);
    }

    private Optional<FunctionSymbol> getFunctionSymbol(FunctionDefinitionNode functionDefinitionNode) {
        Optional functionSymbol = this.context.semanticModel().symbol((Node)functionDefinitionNode);
        return functionSymbol.filter(symbol -> symbol.kind() == SymbolKind.FUNCTION || symbol.kind() == SymbolKind.METHOD).map(FunctionSymbol.class::cast);
    }

    private Optional<FunctionDefinitionNode> getFunctionDefinitionNode(AnnotationNode annotationNode) {
        NonTerminalNode possibleFunctionOrMethodNode = annotationNode.parent().parent();
        if (possibleFunctionOrMethodNode.kind() != SyntaxKind.FUNCTION_DEFINITION && possibleFunctionOrMethodNode.kind() != SyntaxKind.OBJECT_METHOD_DEFINITION) {
            return Optional.empty();
        }
        return Optional.of((FunctionDefinitionNode)possibleFunctionOrMethodNode);
    }

    private ToolAnnotationConfig createAnnotationConfig(AnnotationNode annotationNode, FunctionDefinitionNode functionDefinitionNode) {
        FunctionSymbol functionSymbol = this.getFunctionSymbol(functionDefinitionNode).get();
        String functionName = functionSymbol.getName().orElse("unknownFunction");
        SeparatedNodeList fields = annotationNode.annotValue().isEmpty() ? NodeFactory.createSeparatedNodeList((Node[])new Node[0]) : ((MappingConstructorExpressionNode)annotationNode.annotValue().get()).fields();
        Map<String, ExpressionNode> fieldValues = this.extractFieldValues((SeparatedNodeList<MappingFieldNode>)fields);
        String name = fieldValues.containsKey("name") ? fieldValues.get("name").toSourceCode() : Utils.addDoubleQuotes(functionName);
        String description = fieldValues.containsKey("description") ? fieldValues.get("description").toSourceCode() : Utils.addDoubleQuotes(Objects.requireNonNullElse(Utils.getDescription((Documentable)functionSymbol), functionName));
        String parameters = fieldValues.containsKey("parameters") ? fieldValues.get("parameters").toSourceCode() : this.getParameterSchema(functionSymbol, (Location)functionDefinitionNode.location());
        return new ToolAnnotationConfig(name, description, parameters);
    }

    private Map<String, ExpressionNode> extractFieldValues(SeparatedNodeList<MappingFieldNode> fields) {
        return fields.stream().filter(field -> field.kind() == SyntaxKind.SPECIFIC_FIELD).map(field -> (SpecificFieldNode)field).filter(field -> field.valueExpr().isPresent()).collect(Collectors.toMap(field -> field.fieldName().toSourceCode().trim(), field -> field.valueExpr().orElse(NodeParser.parseExpression((String)NIL_EXPRESSION))));
    }

    private String getParameterSchema(FunctionSymbol functionSymbol, Location alternativeFunctionLocation) {
        try {
            return SchemaUtils.getParameterSchema(functionSymbol, this.context);
        }
        catch (Exception e) {
            Diagnostic diagnostic = CompilationDiagnostic.getDiagnostic(CompilationDiagnostic.UNABLE_TO_GENERATE_SCHEMA_FOR_FUNCTION, functionSymbol.getLocation().orElse(alternativeFunctionLocation), functionSymbol.getName().orElse("unknownFunction"));
            this.reportDiagnostic(diagnostic);
            return NIL_EXPRESSION;
        }
    }

    private void addToModifierContext(SyntaxNodeAnalysisContext context, AnnotationNode annotationNode, ToolAnnotationConfig functionDefinitionNode) {
        this.modifierContextMap.computeIfAbsent(context.documentId(), document -> new ModifierContext()).add(annotationNode, functionDefinitionNode);
    }
}

