/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai.plugin;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.StreamTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import java.util.Optional;

public class Utils {
    public static final String BALLERINA_ORG = "ballerina";
    private static final String TOOL_ANNOTATION_NAME = "AgentTool";
    private static final String AI_PACKAGE_NAME = "ai";
    private static final String HTTP_PACKAGE_NAME = "http";
    private static final String HTTP_RESPONSE_OBJECT_NAME = "Response";
    private static final String CONTEXT_OBJECT_TYPE_NAME = "Context";
    private static final String AI_PACKAGE_MAJOR_VERSION = "1";

    private Utils() {
    }

    public static boolean isAgentToolAnnotation(AnnotationSymbol annotationSymbol) {
        return annotationSymbol.getModule().isPresent() && Utils.isAgentModuleSymbol((Symbol)annotationSymbol.getModule().get()) && annotationSymbol.getName().isPresent() && TOOL_ANNOTATION_NAME.equals(annotationSymbol.getName().get());
    }

    public static boolean isAgentModuleSymbol(Symbol symbol) {
        return symbol.getModule().isPresent() && AI_PACKAGE_NAME.equals(((ModuleSymbol)symbol.getModule().get()).id().moduleName()) && BALLERINA_ORG.equals(((ModuleSymbol)symbol.getModule().get()).id().orgName());
    }

    public static boolean isHttpModuleSymbol(Symbol symbol) {
        return symbol.getModule().isPresent() && HTTP_PACKAGE_NAME.equals(((ModuleSymbol)symbol.getModule().get()).id().moduleName()) && BALLERINA_ORG.equals(((ModuleSymbol)symbol.getModule().get()).id().orgName());
    }

    public static boolean isAnydataType(TypeSymbol typeSymbol, SyntaxNodeAnalysisContext context) {
        return typeSymbol.subtypeOf(context.semanticModel().types().ANYDATA);
    }

    public static boolean isAiContextType(TypeSymbol typeSymbol, SyntaxNodeAnalysisContext context) {
        Object t;
        SemanticModel semanticModel = context.semanticModel();
        Types types = semanticModel.types();
        Optional contextSymbol = types.getTypeByName(BALLERINA_ORG, AI_PACKAGE_NAME, AI_PACKAGE_MAJOR_VERSION, CONTEXT_OBJECT_TYPE_NAME);
        if (contextSymbol.isEmpty() || !((t = contextSymbol.get()) instanceof TypeSymbol)) {
            return false;
        }
        TypeSymbol ctxTypeSymbol = (TypeSymbol)t;
        return typeSymbol.subtypeOf(ctxTypeSymbol);
    }

    public static boolean isErrorType(TypeSymbol typeSymbol, SyntaxNodeAnalysisContext context) {
        return typeSymbol.subtypeOf(context.semanticModel().types().ERROR);
    }

    public static boolean isAllowedReturnType(TypeSymbol typeSymbol, SyntaxNodeAnalysisContext context) {
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            TypeReferenceTypeSymbol typeReferenceTypeSymbol = (TypeReferenceTypeSymbol)typeSymbol;
            if (HTTP_RESPONSE_OBJECT_NAME.equals(typeReferenceTypeSymbol.definition().getName().orElse("<unknown>")) && Utils.isHttpModuleSymbol((Symbol)typeReferenceTypeSymbol)) {
                return true;
            }
            return Utils.isAllowedReturnType(typeReferenceTypeSymbol.typeDescriptor(), context);
        }
        if (typeSymbol.typeKind() == TypeDescKind.UNION) {
            UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol;
            return unionTypeSymbol.memberTypeDescriptors().stream().map(member -> Utils.isAllowedReturnType(member, context)).reduce((a, b) -> a != false && b != false).orElse(false);
        }
        if (typeSymbol.typeKind() == TypeDescKind.STREAM) {
            StreamTypeSymbol streamTypeSymbol = (StreamTypeSymbol)typeSymbol;
            TypeSymbol parameterType = streamTypeSymbol.typeParameter();
            TypeSymbol completionType = streamTypeSymbol.completionValueTypeParameter();
            return Utils.isAllowedReturnType(parameterType, context) && Utils.isAllowedReturnType(completionType, context);
        }
        return Utils.isAnydataType(typeSymbol, context) || Utils.isErrorType(typeSymbol, context);
    }

    public static boolean isXmlType(TypeSymbol typeSymbol, SyntaxNodeAnalysisContext context) {
        return typeSymbol.subtypeOf(context.semanticModel().types().XML);
    }

    public static String getParameterDescription(FunctionSymbol functionSymbol, String parameterName) {
        if (functionSymbol.documentation().isEmpty() || ((Documentation)functionSymbol.documentation().get()).description().isEmpty()) {
            return null;
        }
        return ((Documentation)functionSymbol.documentation().get()).parameterMap().getOrDefault(parameterName, null);
    }

    public static String getDescription(Documentable documentable) {
        if (documentable.documentation().isEmpty() || ((Documentation)documentable.documentation().get()).description().isEmpty()) {
            return null;
        }
        return (String)((Documentation)documentable.documentation().get()).description().get();
    }

    public static String addDoubleQuotes(String functionName) {
        return "\"" + functionName + "\"";
    }
}

