/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai.plugin;

import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TableTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.ai.plugin.Utils;
import java.util.HashSet;
import java.util.Set;

public class XmlTypeInspector {
    private final SyntaxNodeAnalysisContext context;
    private final Set<TypeSymbol> visitedSymbol = new HashSet<TypeSymbol>();

    public XmlTypeInspector(SyntaxNodeAnalysisContext context) {
        this.context = context;
    }

    public boolean includesXmlType(TypeSymbol typeSymbol) {
        if (this.visitedSymbol.contains(typeSymbol)) {
            return false;
        }
        this.visitedSymbol.add(typeSymbol);
        return switch (typeSymbol.typeKind()) {
            case TypeDescKind.TYPE_REFERENCE -> this.includesXmlType(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor());
            case TypeDescKind.UNION -> ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors().stream().anyMatch(this::includesXmlType);
            case TypeDescKind.RECORD -> ((RecordTypeSymbol)typeSymbol).fieldDescriptors().values().stream().anyMatch(field -> this.includesXmlType(field.typeDescriptor()));
            case TypeDescKind.MAP -> this.includesXmlType(((MapTypeSymbol)typeSymbol).typeParam());
            case TypeDescKind.ARRAY -> this.includesXmlType(((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor());
            case TypeDescKind.TABLE -> this.includesXmlType(((TableTypeSymbol)typeSymbol).rowTypeParameter());
            default -> Utils.isXmlType(typeSymbol, this.context);
        };
    }
}

