/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai.plugin.diagnostics;

import io.ballerina.stdlib.ai.plugin.diagnostics.DiagnosticCode;
import io.ballerina.stdlib.ai.plugin.diagnostics.DiagnosticMessage;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;

public enum CompilationDiagnostic {
    UNABLE_TO_GENERATE_SCHEMA_FOR_FUNCTION(DiagnosticMessage.ERROR_101, DiagnosticCode.AI_101, DiagnosticSeverity.ERROR),
    PARAMETER_IS_NOT_A_SUBTYPE_OF_ANYDATA(DiagnosticMessage.ERROR_102, DiagnosticCode.AI_102, DiagnosticSeverity.ERROR),
    XML_PARAMETER_NOT_SUPPORTED_BY_TOOL(DiagnosticMessage.ERROR_103, DiagnosticCode.AI_103, DiagnosticSeverity.ERROR),
    INVALID_RETURN_TYPE_IN_TOOL(DiagnosticMessage.ERROR_104, DiagnosticCode.AI_104, DiagnosticSeverity.ERROR),
    AGENT_MUST_BE_FINAL(DiagnosticMessage.ERROR_105, DiagnosticCode.AI_105, DiagnosticSeverity.ERROR),
    CONTEXT_PARAM_MUST_BE_FIRST(DiagnosticMessage.ERROR_106, DiagnosticCode.AI_106, DiagnosticSeverity.ERROR),
    UNABLE_TO_OBTAIN_VALID_SERVER_PORT_FROM_EXPRESSION(DiagnosticMessage.WARNING_107, DiagnosticCode.AI_107, DiagnosticSeverity.WARNING),
    UNABLE_TO_OBTAIN_VALID_SERVER_PORT(DiagnosticMessage.WARNING_108, DiagnosticCode.AI_108, DiagnosticSeverity.WARNING);

    private final String diagnostic;
    private final String diagnosticCode;
    private final DiagnosticSeverity diagnosticSeverity;

    private CompilationDiagnostic(DiagnosticMessage message, DiagnosticCode diagnosticCode, DiagnosticSeverity diagnosticSeverity) {
        this.diagnostic = message.getMessage();
        this.diagnosticCode = diagnosticCode.name();
        this.diagnosticSeverity = diagnosticSeverity;
    }

    public static Diagnostic getDiagnostic(CompilationDiagnostic compilationDiagnostic, Location location, Object ... args) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(compilationDiagnostic.getDiagnosticCode(), compilationDiagnostic.getDiagnostic(), compilationDiagnostic.getDiagnosticSeverity());
        return DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])args);
    }

    public String getDiagnostic() {
        return this.diagnostic;
    }

    public String getDiagnosticCode() {
        return this.diagnosticCode;
    }

    public DiagnosticSeverity getDiagnosticSeverity() {
        return this.diagnosticSeverity;
    }
}

