/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper;

import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ResourcePathParameterNode;
import io.ballerina.openapi.service.mapper.ResourceMapper;
import io.ballerina.openapi.service.mapper.ServiceMapperFactory;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.model.OperationInventory;
import io.ballerina.openapi.service.mapper.model.ResourceFunction;
import io.ballerina.openapi.service.mapper.parameter.ParameterMapper;
import io.ballerina.openapi.service.mapper.parameter.ParameterMapperException;
import io.ballerina.openapi.service.mapper.response.ResponseMapper;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class ResourceMapperImpl
implements ResourceMapper {
    private final Paths pathObject = new Paths();
    private final AdditionalData additionalData;
    private final OpenAPI openAPI;
    private final List<ResourceFunction> resources;
    private final ServiceMapperFactory serviceMapperFactory;

    ResourceMapperImpl(OpenAPI openAPI, List<ResourceFunction> resources, AdditionalData additionalData, ServiceMapperFactory serviceMapperFactory) {
        this.openAPI = openAPI;
        this.resources = resources;
        this.additionalData = additionalData;
        this.serviceMapperFactory = serviceMapperFactory;
    }

    @Override
    public void setOperation() {
        for (ResourceFunction resource : this.resources) {
            this.addResourceMapping(resource);
        }
        this.openAPI.setPaths(this.pathObject);
    }

    private void addResourceMapping(ResourceFunction resource) {
        String path = MapperCommonUtils.unescapeIdentifier(this.generateRelativePath(resource));
        String httpMethod = resource.functionName();
        if (httpMethod.equals(String.format("'%s", "default")) || httpMethod.equals("default")) {
            ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_100, resource.location(), new String[0]);
            this.additionalData.diagnostics().add(error);
        } else {
            this.convertResourceToOperation(resource, httpMethod, path).ifPresent(operation -> this.addPathItem(httpMethod, this.pathObject, operation.getOperation(), path));
        }
    }

    private void addPathItem(String httpMethod, Paths path, Operation operation, String pathName) {
        PathItem pathItem = new PathItem();
        switch (httpMethod.trim().toUpperCase(Locale.ENGLISH)) {
            case "GET": {
                if (this.pathObject.containsKey((Object)pathName)) {
                    ((PathItem)this.pathObject.get((Object)pathName)).setGet(operation);
                    break;
                }
                pathItem.setGet(operation);
                path.addPathItem(pathName, pathItem);
                break;
            }
            case "PUT": {
                if (this.pathObject.containsKey((Object)pathName)) {
                    ((PathItem)this.pathObject.get((Object)pathName)).setPut(operation);
                    break;
                }
                pathItem.setPut(operation);
                path.addPathItem(pathName, pathItem);
                break;
            }
            case "POST": {
                if (this.pathObject.containsKey((Object)pathName)) {
                    ((PathItem)this.pathObject.get((Object)pathName)).setPost(operation);
                    break;
                }
                pathItem.setPost(operation);
                path.addPathItem(pathName, pathItem);
                break;
            }
            case "DELETE": {
                if (this.pathObject.containsKey((Object)pathName)) {
                    ((PathItem)this.pathObject.get((Object)pathName)).setDelete(operation);
                    break;
                }
                pathItem.setDelete(operation);
                path.addPathItem(pathName, pathItem);
                break;
            }
            case "OPTIONS": {
                if (this.pathObject.containsKey((Object)pathName)) {
                    ((PathItem)this.pathObject.get((Object)pathName)).setOptions(operation);
                    break;
                }
                pathItem.setOptions(operation);
                path.addPathItem(pathName, pathItem);
                break;
            }
            case "PATCH": {
                if (this.pathObject.containsKey((Object)pathName)) {
                    ((PathItem)this.pathObject.get((Object)pathName)).setPatch(operation);
                    break;
                }
                pathItem.setPatch(operation);
                path.addPathItem(pathName, pathItem);
                break;
            }
            case "HEAD": {
                if (this.pathObject.containsKey((Object)pathName)) {
                    ((PathItem)this.pathObject.get((Object)pathName)).setHead(operation);
                    break;
                }
                pathItem.setHead(operation);
                path.addPathItem(pathName, pathItem);
                break;
            }
        }
    }

    private Optional<OperationInventory> convertResourceToOperation(ResourceFunction resourceFunction, String httpMethod, String generateRelativePath) {
        OperationInventory operationInventory = new OperationInventory();
        operationInventory.setHttpOperation(httpMethod);
        operationInventory.setPath(generateRelativePath);
        operationInventory.setOperationId(MapperCommonUtils.getOperationId(resourceFunction));
        Map<String, String> apiDocs = this.listAPIDocumentations(resourceFunction, operationInventory);
        ParameterMapper parameterMapper = this.serviceMapperFactory.getParameterMapper(resourceFunction, apiDocs, operationInventory);
        try {
            parameterMapper.setParameters();
        }
        catch (ParameterMapperException exception) {
            this.additionalData.diagnostics().add(exception.getDiagnostic());
            return Optional.empty();
        }
        ResponseMapper responseMapper = this.serviceMapperFactory.getResponseMapper(resourceFunction, operationInventory);
        responseMapper.setApiResponses();
        return Optional.of(operationInventory);
    }

    private Map<String, String> listAPIDocumentations(ResourceFunction resource, OperationInventory operationInventory) {
        Documentation documentation1;
        Optional description;
        Symbol symbol;
        Optional documentation;
        Optional<Symbol> resourceSymbol;
        Map<String, String> apiDocs = new HashMap<String, String>();
        if (resource.metadata().isPresent() && (resourceSymbol = resource.getSymbol(this.additionalData.semanticModel())).isPresent() && (documentation = ((Documentable)(symbol = resourceSymbol.get())).documentation()).isPresent() && (description = (documentation1 = (Documentation)documentation.get()).description()).isPresent()) {
            String resourceFunctionAPI = ((String)description.get()).trim();
            apiDocs = documentation1.parameterMap();
            operationInventory.setSummary(resourceFunctionAPI);
        }
        return apiDocs;
    }

    private String generateRelativePath(ResourceFunction resource) {
        StringBuilder relativePath = new StringBuilder();
        relativePath.append("/");
        if (!resource.relativeResourcePath().isEmpty()) {
            for (Node node : resource.relativeResourcePath()) {
                if (node instanceof ResourcePathParameterNode) {
                    ResourcePathParameterNode pathNode = (ResourcePathParameterNode)node;
                    relativePath.append("{");
                    Optional pathParamToken = pathNode.paramName();
                    if (pathParamToken.isPresent()) {
                        relativePath.append(pathParamToken.get());
                    } else {
                        relativePath.append("unsupported");
                    }
                    relativePath.append("}");
                    continue;
                }
                if (resource.relativeResourcePath().size() == 1 && node.toString().trim().equals(".")) {
                    return relativePath.toString();
                }
                relativePath.append(node.toString().trim());
            }
        }
        return relativePath.toString();
    }
}

