/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.openapi.service.mapper.ResourceMapper;
import io.ballerina.openapi.service.mapper.ResourceMapperImpl;
import io.ballerina.openapi.service.mapper.ServersMapper;
import io.ballerina.openapi.service.mapper.ServersMapperImpl;
import io.ballerina.openapi.service.mapper.ServiceToOpenAPIMapper;
import io.ballerina.openapi.service.mapper.constraint.ConstraintMapper;
import io.ballerina.openapi.service.mapper.constraint.ConstraintMapperImpl;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.example.OpenAPIExampleMapper;
import io.ballerina.openapi.service.mapper.example.OpenAPIExampleMapperImpl;
import io.ballerina.openapi.service.mapper.hateoas.HateoasMapper;
import io.ballerina.openapi.service.mapper.hateoas.HateoasMapperImpl;
import io.ballerina.openapi.service.mapper.interceptor.model.RequestParameterInfo;
import io.ballerina.openapi.service.mapper.interceptor.model.ResponseInfo;
import io.ballerina.openapi.service.mapper.interceptor.pipeline.InterceptorPipeline;
import io.ballerina.openapi.service.mapper.metainfo.MetaInfoMapper;
import io.ballerina.openapi.service.mapper.metainfo.MetaInfoMapperImpl;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.model.ModuleMemberVisitor;
import io.ballerina.openapi.service.mapper.model.OperationInventory;
import io.ballerina.openapi.service.mapper.model.ResourceFunction;
import io.ballerina.openapi.service.mapper.model.ServiceNode;
import io.ballerina.openapi.service.mapper.parameter.DefaultParameterMapper;
import io.ballerina.openapi.service.mapper.parameter.ParameterMapper;
import io.ballerina.openapi.service.mapper.parameter.ParameterMapperWithInterceptors;
import io.ballerina.openapi.service.mapper.response.DefaultResponseMapper;
import io.ballerina.openapi.service.mapper.response.ResponseMapper;
import io.ballerina.openapi.service.mapper.response.ResponseMapperWithInterceptors;
import io.ballerina.openapi.service.mapper.type.TypeMapper;
import io.ballerina.openapi.service.mapper.type.TypeMapperImpl;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;

public class ServiceMapperFactory {
    private final OpenAPI openAPI;
    private final AdditionalData additionalData;
    private final Boolean treatNilableAsOptional;
    private final TypeMapper typeMapper;
    private final ConstraintMapper constraintMapper;
    private final HateoasMapper hateoasMapper;
    private final InterceptorPipeline interceptorPipeline;
    private final MetaInfoMapper metaInfoMapper;
    private final OpenAPIExampleMapper exampleMapper;

    public ServiceMapperFactory(OpenAPI openAPI, SemanticModel semanticModel, ModuleMemberVisitor moduleMemberVisitor, List<OpenAPIMapperDiagnostic> diagnostics, ServiceNode serviceDefinition, boolean enableBallerinaExt) {
        this.additionalData = new AdditionalData(semanticModel, moduleMemberVisitor, diagnostics, enableBallerinaExt);
        this.treatNilableAsOptional = ServiceMapperFactory.isTreatNilableAsOptionalParameter(serviceDefinition);
        this.openAPI = openAPI;
        this.interceptorPipeline = ServiceToOpenAPIMapper.oasAvailableViaServiceContract(serviceDefinition) ? null : ServiceMapperFactory.getInterceptorPipeline(serviceDefinition, this.additionalData);
        this.typeMapper = new TypeMapperImpl(this.getComponents(openAPI), this.additionalData);
        this.constraintMapper = new ConstraintMapperImpl(openAPI, moduleMemberVisitor, diagnostics);
        this.hateoasMapper = new HateoasMapperImpl();
        this.metaInfoMapper = new MetaInfoMapperImpl();
        this.exampleMapper = new OpenAPIExampleMapperImpl(openAPI, serviceDefinition, this.additionalData);
    }

    public ServiceMapperFactory(OpenAPI openAPI, SemanticModel semanticModel, ModuleMemberVisitor moduleMemberVisitor, List<OpenAPIMapperDiagnostic> diagnostics, ServiceNode serviceDefinition) {
        this(openAPI, semanticModel, moduleMemberVisitor, diagnostics, serviceDefinition, false);
    }

    public ServersMapper getServersMapper(Set<ListenerDeclarationNode> endpoints, ServiceNode serviceNode) {
        return new ServersMapperImpl(this.openAPI, endpoints, serviceNode);
    }

    public ResourceMapper getResourceMapper(List<ResourceFunction> resources) {
        return new ResourceMapperImpl(this.openAPI, resources, this.additionalData, this);
    }

    public ParameterMapper getParameterMapper(ResourceFunction resourceNode, Map<String, String> apiDocs, OperationInventory opInventory) {
        if (Objects.nonNull(this.interceptorPipeline)) {
            RequestParameterInfo reqParamInfoFromInterceptors = this.getRequestParameterInfoFromInterceptors(resourceNode, this.additionalData, this.interceptorPipeline);
            return new ParameterMapperWithInterceptors(resourceNode, opInventory, apiDocs, this.additionalData, this.treatNilableAsOptional, reqParamInfoFromInterceptors, this);
        }
        return new DefaultParameterMapper(resourceNode, opInventory, apiDocs, this.additionalData, this.treatNilableAsOptional, this);
    }

    public TypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public ResponseMapper getResponseMapper(ResourceFunction resourceNode, OperationInventory opInventory) {
        if (Objects.nonNull(this.interceptorPipeline)) {
            ResponseInfo responseInfoFromInterceptors = this.getResponseInfoFromInterceptors(resourceNode, this.additionalData, this.interceptorPipeline);
            return new ResponseMapperWithInterceptors(resourceNode, opInventory, this.additionalData, responseInfoFromInterceptors, this);
        }
        return new DefaultResponseMapper(resourceNode, opInventory, this.additionalData, this);
    }

    private ResponseInfo getResponseInfoFromInterceptors(ResourceFunction resourceNode, AdditionalData additionalData, InterceptorPipeline interceptorPipeline) {
        ResponseInfo responseInfoFromInterceptors;
        Symbol symbol;
        Optional<Symbol> symbol2 = resourceNode.getSymbol(additionalData.semanticModel());
        if (symbol2.isPresent() && (symbol = symbol2.get()) instanceof ResourceMethodSymbol) {
            ResourceMethodSymbol resourceMethodSymbol = (ResourceMethodSymbol)symbol;
            responseInfoFromInterceptors = interceptorPipeline.getInfoFromInterceptors(resourceMethodSymbol);
        } else {
            responseInfoFromInterceptors = new ResponseInfo(false);
        }
        return responseInfoFromInterceptors;
    }

    private RequestParameterInfo getRequestParameterInfoFromInterceptors(ResourceFunction resourceNode, AdditionalData additionalData, InterceptorPipeline interceptorPipeline) {
        RequestParameterInfo requestParameterInfoFromInterceptors;
        Symbol symbol;
        Optional<Symbol> symbol2 = resourceNode.getSymbol(additionalData.semanticModel());
        if (symbol2.isPresent() && (symbol = symbol2.get()) instanceof ResourceMethodSymbol) {
            ResourceMethodSymbol resourceMethodSymbol = (ResourceMethodSymbol)symbol;
            requestParameterInfoFromInterceptors = interceptorPipeline.getRequestParameterInfo(resourceMethodSymbol);
        } else {
            requestParameterInfoFromInterceptors = new RequestParameterInfo(additionalData.semanticModel());
        }
        return requestParameterInfoFromInterceptors;
    }

    public ConstraintMapper getConstraintMapper() {
        return this.constraintMapper;
    }

    public HateoasMapper getHateoasMapper() {
        return this.hateoasMapper;
    }

    public MetaInfoMapper getMetaInfoMapper() {
        return this.metaInfoMapper;
    }

    public OpenAPIExampleMapper getExampleMapper() {
        return this.exampleMapper;
    }

    private Components getComponents(OpenAPI openAPI) {
        Components components = openAPI.getComponents();
        if (Objects.isNull(components)) {
            components = new Components();
            openAPI.setComponents(components);
        }
        if (components.getSchemas() == null) {
            components.setSchemas(new TreeMap());
        }
        return components;
    }

    private static boolean isTreatNilableAsOptionalParameter(ServiceNode serviceNode) {
        Optional<String> values;
        if (serviceNode.metadata().isEmpty()) {
            return true;
        }
        MetadataNode metadataNode = serviceNode.metadata().get();
        NodeList annotations = metadataNode.annotations();
        if (!annotations.isEmpty() && (values = MapperCommonUtils.extractServiceAnnotationDetails((NodeList<AnnotationNode>)annotations, "http:ServiceConfig", "treatNilableAsOptional")).isPresent()) {
            return values.get().equals("true");
        }
        return true;
    }

    private static boolean isInterceptableService(ServiceNode serviceDefinition, SemanticModel semanticModel) {
        Object t;
        Optional<TypeSymbol> serviceType = serviceDefinition.typeDescriptor(semanticModel);
        if (serviceType.isEmpty()) {
            return false;
        }
        Optional interceptableServiceType = semanticModel.types().getTypeByName("ballerina", "http", "", "InterceptableService");
        if (interceptableServiceType.isEmpty() || !((t = interceptableServiceType.get()) instanceof TypeDefinitionSymbol)) {
            return false;
        }
        TypeDefinitionSymbol interceptableServiceTypeSymbol = (TypeDefinitionSymbol)t;
        return serviceType.get().subtypeOf(interceptableServiceTypeSymbol.typeDescriptor());
    }

    private static InterceptorPipeline getInterceptorPipeline(ServiceNode serviceDefinition, AdditionalData additionalData) {
        if (!ServiceMapperFactory.isInterceptableService(serviceDefinition, additionalData.semanticModel())) {
            return null;
        }
        return InterceptorPipeline.build(serviceDefinition, additionalData);
    }
}

