/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.example.type;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.example.CommonUtils;
import io.ballerina.openapi.service.mapper.example.ExampleAnnotationMapper;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import java.util.Optional;

public class TypeExampleMapper
extends ExampleAnnotationMapper {
    List<AnnotationAttachmentSymbol> annotations;
    Schema typeSchema;
    List<OpenAPIMapperDiagnostic> diagnostics;
    String typeName;
    Location location;
    TypeSymbol typeSymbol;

    public TypeExampleMapper(TypeDefinitionSymbol typeDefinitionSymbol, Schema typeSchema, SemanticModel semanticModel, List<OpenAPIMapperDiagnostic> diagnostics) {
        super(semanticModel);
        this.annotations = typeDefinitionSymbol.annotAttachments();
        this.typeSymbol = typeDefinitionSymbol.typeDescriptor();
        this.typeSchema = typeSchema;
        this.diagnostics = diagnostics;
        this.typeName = (String)typeDefinitionSymbol.getName().get();
        this.location = typeDefinitionSymbol.getLocation().orElse(null);
    }

    @Override
    public void setExample() {
        try {
            CommonUtils.setExampleForInlineRecordFields(this.typeSymbol, this.typeSchema, this.getSemanticModel(), this.diagnostics);
            Optional<Object> exampleValue = this.extractExample(this.annotations);
            if (exampleValue.isEmpty()) {
                return;
            }
            this.typeSchema.setExample(exampleValue.get());
        }
        catch (JsonProcessingException exception) {
            this.diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_132, this.location, this.typeName));
        }
    }
}

