/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.model;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.openapi.service.mapper.ServiceToOpenAPIMapper;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.model.OASResult;
import io.ballerina.openapi.service.mapper.model.ServiceContractType;
import io.ballerina.openapi.service.mapper.model.ServiceNode;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ServiceDeclaration
implements ServiceNode {
    ServiceDeclarationNode serviceDeclarationNode;
    int serviceId;
    TypeReferenceTypeSymbol serviceContractType;

    public ServiceDeclaration(ServiceDeclarationNode serviceNode, SemanticModel semanticModel) {
        this.serviceId = serviceNode.hashCode();
        this.serviceDeclarationNode = new ServiceDeclarationNode(serviceNode.internalNode(), serviceNode.position(), serviceNode.parent());
        this.serviceContractType = ServiceDeclaration.extractServiceContractType(serviceNode, semanticModel);
    }

    private static TypeReferenceTypeSymbol extractServiceContractType(ServiceDeclarationNode serviceNode, SemanticModel semanticModel) {
        Object t;
        Object t2;
        Optional typeDescriptorNode = serviceNode.typeDescriptor();
        if (typeDescriptorNode.isEmpty()) {
            return null;
        }
        Optional symbol = semanticModel.symbol((Node)typeDescriptorNode.get());
        if (symbol.isEmpty() || !((t2 = symbol.get()) instanceof TypeReferenceTypeSymbol)) {
            return null;
        }
        TypeReferenceTypeSymbol typeSymbol = (TypeReferenceTypeSymbol)t2;
        Optional serviceContractType = semanticModel.types().getTypeByName("ballerina", "http", "", "ServiceContract");
        if (serviceContractType.isEmpty() || !((t = serviceContractType.get()) instanceof TypeDefinitionSymbol)) {
            return null;
        }
        TypeDefinitionSymbol serviceContractTypeDef = (TypeDefinitionSymbol)t;
        return typeSymbol.subtypeOf(serviceContractTypeDef.typeDescriptor()) ? typeSymbol : null;
    }

    @Override
    public Optional<MetadataNode> metadata() {
        return this.serviceDeclarationNode.metadata();
    }

    @Override
    public Optional<Symbol> getSymbol(SemanticModel semanticModel) {
        return semanticModel.symbol((Node)this.serviceDeclarationNode);
    }

    @Override
    public Optional<TypeSymbol> typeDescriptor(SemanticModel semanticModel) {
        Object t;
        Optional serviceSymbol = semanticModel.symbol((Node)this.serviceDeclarationNode);
        if (serviceSymbol.isEmpty() || !((t = serviceSymbol.get()) instanceof ServiceDeclarationSymbol)) {
            return Optional.empty();
        }
        ServiceDeclarationSymbol serviceType = (ServiceDeclarationSymbol)t;
        return serviceType.typeDescriptor();
    }

    @Override
    public SeparatedNodeList<ExpressionNode> expressions() {
        return this.serviceDeclarationNode.expressions();
    }

    @Override
    public String absoluteResourcePath() {
        StringBuilder currentServiceName = new StringBuilder();
        NodeList serviceNameNodes = this.serviceDeclarationNode.absoluteResourcePath();
        for (Node serviceBasedPathNode : serviceNameNodes) {
            currentServiceName.append(MapperCommonUtils.unescapeIdentifier(serviceBasedPathNode.toString()));
        }
        return currentServiceName.toString().trim();
    }

    @Override
    public NodeList<Node> members() {
        return this.serviceDeclarationNode.members();
    }

    @Override
    public ServiceNode.Kind kind() {
        return ServiceNode.Kind.SERVICE_DECLARATION;
    }

    @Override
    public Location location() {
        return this.serviceDeclarationNode.location();
    }

    @Override
    public int getServiceId() {
        return this.serviceId;
    }

    @Override
    public void updateAnnotations(NodeList<AnnotationNode> newAnnotations) {
        Optional metadataOpt = this.serviceDeclarationNode.metadata();
        MetadataNode updatedMetadata = metadataOpt.isEmpty() ? NodeFactory.createMetadataNode(null, newAnnotations) : ((MetadataNode)metadataOpt.get()).modify().withAnnotations(newAnnotations).apply();
        this.serviceDeclarationNode = this.serviceDeclarationNode.modify().withMetadata(updatedMetadata).apply();
    }

    @Override
    public ModuleMemberDeclarationNode getInternalNode() {
        return this.serviceDeclarationNode;
    }

    @Override
    public Optional<TypeSymbol> getInterceptorReturnType(SemanticModel semanticModel) {
        Object t;
        Optional symbol = semanticModel.symbol((Node)this.serviceDeclarationNode);
        if (symbol.isEmpty() || !((t = symbol.get()) instanceof ServiceDeclarationSymbol)) {
            return Optional.empty();
        }
        ServiceDeclarationSymbol serviceType = (ServiceDeclarationSymbol)t;
        MethodSymbol methodSymbol = (MethodSymbol)serviceType.methods().get("createInterceptors");
        if (Objects.isNull(methodSymbol)) {
            return Optional.empty();
        }
        return methodSymbol.typeDescriptor().returnTypeDescriptor();
    }

    public boolean implementsServiceContract() {
        return Objects.nonNull(this.serviceContractType);
    }

    public Optional<OpenAPI> getOpenAPIFromServiceContract(Package pkg, SemanticModel semanticModel, Set<ServiceContractType> serviceContractTypes, List<OpenAPIMapperDiagnostic> diagnostics) {
        Optional<String> jsonOpenApi = this.getOpenAPISpecFromResources(pkg, semanticModel, serviceContractTypes, diagnostics);
        if (jsonOpenApi.isEmpty()) {
            return Optional.empty();
        }
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setResolve(true);
        parseOptions.setFlatten(true);
        SwaggerParseResult parseResult = new OpenAPIParser().readContents(jsonOpenApi.get(), null, parseOptions);
        return Optional.of(parseResult.getOpenAPI());
    }

    private Optional<String> getOpenAPISpecFromResources(Package pkg, SemanticModel semanticModel, Set<ServiceContractType> serviceContractTypes, List<OpenAPIMapperDiagnostic> diagnostics) {
        Optional serviceName = this.serviceContractType.getName();
        if (serviceName.isEmpty()) {
            return Optional.empty();
        }
        String openApiFileName = (String)serviceName.get() + ".json";
        Optional serviceContractModule = this.serviceContractType.getModule();
        if (serviceContractModule.isEmpty()) {
            diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_137, (String)serviceName.get()));
            return Optional.empty();
        }
        ModuleID serviceContractModuleId = ((ModuleSymbol)serviceContractModule.get()).id();
        Optional serviceSymbol = semanticModel.symbol((Node)this.serviceDeclarationNode);
        if (serviceSymbol.isEmpty()) {
            diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_137, (String)serviceName.get()));
            return Optional.empty();
        }
        Optional currentModule = ((Symbol)serviceSymbol.get()).getModule();
        if (currentModule.isEmpty()) {
            diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_137, (String)serviceName.get()));
            return Optional.empty();
        }
        ModuleID currentModuleId = ((ModuleSymbol)currentModule.get()).id();
        if (currentModuleId.orgName().equals(serviceContractModuleId.orgName()) && currentModuleId.moduleName().equals(serviceContractModuleId.moduleName())) {
            Optional<ServiceContractType> serviceContract = serviceContractTypes.stream().filter(contractType -> contractType.matchesName((String)serviceName.get())).findFirst();
            if (serviceContract.isEmpty()) {
                diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_137, (String)serviceName.get()));
                return Optional.empty();
            }
            OASResult oasResult = ServiceToOpenAPIMapper.generateOasFroServiceNode(pkg.project(), (String)serviceName.get(), semanticModel, null, serviceContract.get(), false);
            if (oasResult.getDiagnostics().stream().anyMatch(diagnostic -> diagnostic.getDiagnosticSeverity().equals((Object)DiagnosticSeverity.ERROR))) {
                diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_136, (String)serviceName.get()));
                return Optional.empty();
            }
            return oasResult.getJson();
        }
        Optional<ResolvedPackageDependency> resolvedPackage = pkg.getResolution().allDependencies().stream().filter(dependency -> {
            PackageDescriptor descriptor = dependency.packageInstance().descriptor();
            return descriptor.org().value().equals(serviceContractModuleId.orgName()) && descriptor.name().value().equals(serviceContractModuleId.packageName());
        }).findFirst();
        if (resolvedPackage.isEmpty()) {
            diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_138, String.format("%s/%s:%s", serviceContractModuleId.orgName(), serviceContractModuleId.packageName(), serviceName.get())));
            return Optional.empty();
        }
        Package packageInstance = resolvedPackage.get().packageInstance();
        Optional<DocumentId> openApiDocument = packageInstance.resourceIds().stream().filter(resourceId -> resourceId.toString().contains(openApiFileName)).findFirst();
        if (openApiDocument.isEmpty()) {
            diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_139, String.format("%s/%s:%s", serviceContractModuleId.orgName(), serviceContractModuleId.packageName(), serviceName.get())));
            return Optional.empty();
        }
        byte[] openApiContent = packageInstance.resource(openApiDocument.get()).content();
        return Optional.of(new String(openApiContent, StandardCharsets.UTF_8));
    }
}

