/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.response.utils;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.service.mapper.Constants;
import io.ballerina.openapi.service.mapper.response.model.ResponseInfo;
import io.ballerina.openapi.service.mapper.response.utils.StatusCodeTypeUtils;
import io.ballerina.openapi.service.mapper.type.TypeMapper;
import io.swagger.v3.oas.models.headers.Header;
import java.util.Map;
import java.util.Optional;

public final class StatusCodeResponseUtils
extends StatusCodeTypeUtils {
    private StatusCodeResponseUtils() {
    }

    public static boolean isSubTypeOfHttpStatusCodeResponse(TypeSymbol typeSymbol, SemanticModel semanticModel) {
        return StatusCodeResponseUtils.isSubTypeOfBallerinaModuleType("StatusCodeResponse", "http", typeSymbol, semanticModel);
    }

    public static ResponseInfo extractResponseInfo(TypeSymbol statusCodeResponseType, String defaultStatusCode, TypeMapper typeMapper, SemanticModel semanticModel) {
        Optional<RecordTypeSymbol> statusCodeRecordType = StatusCodeResponseUtils.getRecordTypeSymbol(statusCodeResponseType, typeMapper);
        String statusCode = StatusCodeResponseUtils.getResponseCode(statusCodeResponseType, defaultStatusCode, semanticModel);
        if (statusCodeRecordType.isEmpty()) {
            return new ResponseInfo(statusCode, semanticModel.types().ANYDATA, Map.of());
        }
        TypeSymbol bodyType = StatusCodeResponseUtils.getBodyType(statusCodeRecordType.get(), semanticModel);
        Map<String, Header> headers = StatusCodeResponseUtils.getHeaders(statusCodeRecordType.get(), typeMapper);
        return new ResponseInfo(statusCode, bodyType, headers);
    }

    private static String getResponseCode(TypeSymbol typeSymbol, String defaultCode, SemanticModel semanticModel) {
        for (Map.Entry<String, String> entry : Constants.HTTP_CODES.entrySet()) {
            if (!StatusCodeResponseUtils.isSubTypeOfBallerinaModuleType(entry.getKey(), "http", typeSymbol, semanticModel)) continue;
            return entry.getValue();
        }
        if (StatusCodeResponseUtils.isSubTypeOfBallerinaModuleType("DefaultStatusCodeResponse", "http", typeSymbol, semanticModel)) {
            return "default";
        }
        return defaultCode;
    }
}

