/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.type;

import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.type.AbstractTypeMapper;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.Objects;

public class SimpleTypeMapper
extends AbstractTypeMapper {
    public SimpleTypeMapper(TypeReferenceTypeSymbol typeSymbol, AdditionalData additionalData) {
        super(typeSymbol, additionalData);
    }

    @Override
    public Schema getReferenceSchema(Components components) {
        TypeSymbol referredType = this.typeSymbol.typeDescriptor();
        Schema schema = SimpleTypeMapper.getTypeSchema(referredType, this.additionalData);
        return Objects.nonNull(schema) ? schema.description(this.description) : null;
    }

    public static Schema getTypeSchema(TypeSymbol typeSymbol, AdditionalData additionalData) {
        Schema schema = SimpleTypeMapper.getSchema(typeSymbol.typeKind());
        if (Objects.isNull(schema)) {
            ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_121, MapperCommonUtils.getTypeName(typeSymbol));
            additionalData.diagnostics().add(error);
        }
        return schema;
    }

    public static Schema getSchema(TypeDescKind typeKind) {
        switch (typeKind) {
            case STRING: 
            case STRING_CHAR: {
                return new StringSchema();
            }
            case BYTE: {
                return new StringSchema().format("byte");
            }
            case INT: {
                return new IntegerSchema().format("int64");
            }
            case INT_SIGNED32: {
                return new IntegerSchema().format("int32");
            }
            case INT_UNSIGNED32: 
            case INT_UNSIGNED16: 
            case INT_SIGNED16: 
            case INT_UNSIGNED8: 
            case INT_SIGNED8: {
                return new IntegerSchema().format(null);
            }
            case DECIMAL: {
                return new NumberSchema().format("double");
            }
            case FLOAT: {
                return new NumberSchema().format("float");
            }
            case BOOLEAN: {
                return new BooleanSchema();
            }
            case JSON: 
            case XML: 
            case XML_ELEMENT: 
            case XML_PROCESSING_INSTRUCTION: 
            case XML_TEXT: 
            case XML_COMMENT: {
                return new ObjectSchema();
            }
            case NIL: {
                Schema schema = new Schema();
                schema.setNullable(Boolean.valueOf(true));
                return schema;
            }
            case ANYDATA: {
                return new Schema();
            }
        }
        return null;
    }
}

