/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.logging.accesslog;

import io.ballerina.stdlib.http.api.logging.accesslog.HttpAccessLogConfig;
import io.ballerina.stdlib.http.api.logging.accesslog.HttpAccessLogMessage;
import io.ballerina.stdlib.http.api.logging.accesslog.HttpAccessLogUtil;
import io.ballerina.stdlib.http.api.logging.accesslog.HttpAccessLogger;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderHttpAccessLogger
implements HttpAccessLogger {
    private static final Logger LOG = LoggerFactory.getLogger(SenderHttpAccessLogger.class);
    private Long contentLength = 0L;
    private final SocketAddress remoteAddress;

    public SenderHttpAccessLogger(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    public void logAccessInfo(HttpCarbonMessage requestMessage, HttpCarbonMessage responseMessage) {
        LOG.warn("logAccessInfo is not a dependant action of this logger");
    }

    @Override
    public void updateAccessLogInfo(HttpCarbonMessage outboundRequestMsg, HttpCarbonMessage inboundResponseMsg) {
        long requestBodySize;
        HttpHeaders headers;
        HttpAccessLogMessage outboundAccessLogMessage = HttpAccessLogUtil.getTypedProperty(outboundRequestMsg, "OUTBOUND_ACCESS_LOG_MESSAGE", HttpAccessLogMessage.class);
        if (outboundAccessLogMessage == null) {
            return;
        }
        SocketAddress socketAddress = this.remoteAddress;
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            InetAddress inetAddress = inetSocketAddress.getAddress();
            outboundAccessLogMessage.setIp(inetAddress.getHostAddress());
            outboundAccessLogMessage.setHost(inetAddress.getHostName());
            outboundAccessLogMessage.setPort(inetSocketAddress.getPort());
        }
        if (outboundAccessLogMessage.getIp().startsWith("/")) {
            outboundAccessLogMessage.setIp(outboundAccessLogMessage.getIp().substring(1));
        }
        if ((headers = outboundRequestMsg.getHeaders()).contains("x-forwarded-for")) {
            String forwardedHops = headers.get("x-forwarded-for");
            outboundAccessLogMessage.setHttpXForwardedFor(forwardedHops);
            int firstCommaIndex = forwardedHops.indexOf(44);
            outboundAccessLogMessage.setIp(firstCommaIndex != -1 ? forwardedHops.substring(0, firstCommaIndex) : forwardedHops);
        }
        if (headers.contains((CharSequence)HttpHeaderNames.USER_AGENT)) {
            outboundAccessLogMessage.setHttpUserAgent(headers.get((CharSequence)HttpHeaderNames.USER_AGENT));
        }
        if (headers.contains((CharSequence)HttpHeaderNames.REFERER)) {
            outboundAccessLogMessage.setHttpReferrer(headers.get((CharSequence)HttpHeaderNames.REFERER));
        }
        HttpAccessLogConfig.getInstance().getCustomHeaders().forEach(customHeader -> outboundAccessLogMessage.putCustomHeader((String)customHeader, headers.contains(customHeader) ? headers.get(customHeader) : "-"));
        outboundAccessLogMessage.setRequestMethod(outboundRequestMsg.getHttpMethod());
        outboundAccessLogMessage.setRequestUri((String)outboundRequestMsg.getProperty("TO"));
        HttpResponse inboundResponse = inboundResponseMsg.getNettyHttpResponse();
        if (inboundResponse != null) {
            outboundAccessLogMessage.setScheme(inboundResponse.protocolVersion().toString());
        } else {
            outboundAccessLogMessage.setScheme(inboundResponseMsg.getHttpVersion());
        }
        if (headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
            try {
                requestBodySize = Long.parseLong(headers.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
            }
            catch (Exception ignored) {
                requestBodySize = 0L;
            }
        } else {
            requestBodySize = outboundRequestMsg.getContentSize().intValue();
        }
        outboundAccessLogMessage.setRequestBodySize(requestBodySize);
        outboundAccessLogMessage.setStatus(inboundResponseMsg.getHttpStatusCode());
        outboundAccessLogMessage.setResponseBodySize(this.contentLength);
        long requestTime = Calendar.getInstance().getTimeInMillis() - outboundAccessLogMessage.getDateTime().getTimeInMillis();
        outboundAccessLogMessage.setRequestTime(requestTime);
        HttpCarbonMessage inboundReqMsg = HttpAccessLogUtil.getTypedProperty(outboundRequestMsg, "INBOUND_MESSAGE", HttpCarbonMessage.class);
        if (inboundReqMsg != null) {
            List<HttpAccessLogMessage> outboundAccessLogMessages = HttpAccessLogUtil.getHttpAccessLogMessages(inboundReqMsg);
            outboundAccessLogMessages.add(outboundAccessLogMessage);
        }
    }

    public void updateContentLength(ByteBuf content) {
        this.contentLength = this.contentLength + (long)content.readableBytes();
    }
}

