/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener;

import io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.CertificateVerificationException;
import io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.ocsp.OCSPCache;
import io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.ocsp.OCSPVerifier;
import io.ballerina.stdlib.http.transport.contractimpl.common.ssl.SSLConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPResponseBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OCSPResponseBuilder.class);
    private static List<X509Certificate> certList = new ArrayList<X509Certificate>();
    private static X509Certificate userCertificate = null;
    private static X509Certificate issuer = null;

    private OCSPResponseBuilder() {
    }

    static OCSPResp generateOcspResponse(SSLConfig sslConfig, int cacheAllocatedSize, int cacheDelay) throws IOException, KeyStoreException, CertificateVerificationException, CertificateException {
        int cacheSize = 50;
        int cacheDelayMins = 15;
        if (cacheAllocatedSize != 0 && cacheAllocatedSize > 50 && cacheAllocatedSize < 10000) {
            cacheSize = cacheAllocatedSize;
        }
        if (cacheDelay != 0 && cacheDelay > 1 && cacheDelay < 1440) {
            cacheDelayMins = cacheDelay;
        }
        OCSPCache ocspCache = OCSPCache.getCache();
        ocspCache.init(cacheSize, cacheDelayMins);
        if (sslConfig.getKeyStore() != null) {
            KeyStore keyStore = OCSPResponseBuilder.getKeyStore(sslConfig.getKeyStore(), sslConfig.getKeyStorePass(), sslConfig.getTLSStoreType());
            if (keyStore != null) {
                OCSPResponseBuilder.getUserCerAndIssuer(keyStore);
            }
        } else {
            certList = OCSPResponseBuilder.getCertInfo(sslConfig);
            userCertificate = certList.get(0);
            issuer = certList.get(1);
        }
        if (userCertificate == null) {
            throw new CertificateVerificationException("Could not get revocation status from OCSP.");
        }
        if (ocspCache.getOCSPCacheValue(userCertificate.getSerialNumber()) != null) {
            return ocspCache.getOCSPCacheValue(userCertificate.getSerialNumber());
        }
        OCSPReq request = OCSPVerifier.generateOCSPRequest(issuer, userCertificate.getSerialNumber());
        List<String> locations = OCSPResponseBuilder.getAIALocations(userCertificate);
        return OCSPResponseBuilder.getOCSPResponse(locations, request, userCertificate, ocspCache);
    }

    private static void getUserCerAndIssuer(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        String alias = "";
        boolean isAliasWithPrivateKey = false;
        while (aliases.hasMoreElements() && !(isAliasWithPrivateKey = keyStore.isKeyEntry(alias = aliases.nextElement()))) {
        }
        if (isAliasWithPrivateKey) {
            Certificate[] certificateChain = keyStore.getCertificateChain(alias);
            userCertificate = (X509Certificate)certificateChain[0];
            issuer = (X509Certificate)certificateChain[certificateChain.length - 1];
        }
    }

    public static KeyStore getKeyStore(File keyStoreFile, String keyStorePassword, String tlsStoreType) throws IOException {
        KeyStore keyStore = null;
        if (keyStoreFile != null && keyStorePassword != null) {
            try (FileInputStream inputStream = new FileInputStream(keyStoreFile);){
                keyStore = KeyStore.getInstance(tlsStoreType);
                keyStore.load(inputStream, keyStorePassword.toCharArray());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IOException(e);
            }
        }
        return keyStore;
    }

    public static List<String> getAIALocations(X509Certificate userCertificate) throws CertificateVerificationException {
        List<String> locations;
        try {
            locations = OCSPVerifier.getAIALocations(userCertificate);
        }
        catch (CertificateVerificationException e) {
            throw new CertificateVerificationException("Failed to find AIA locations in the cetificate", e);
        }
        return locations;
    }

    public static OCSPResp getOCSPResponse(List<String> locations, OCSPReq request, X509Certificate userCertificate, OCSPCache ocspCache) throws CertificateVerificationException {
        for (String serviceUrl : locations) {
            SingleResp[] responses;
            OCSPResp response;
            try {
                response = OCSPVerifier.getOCSPResponce(serviceUrl, request);
                if (0 != response.getStatus()) continue;
                BasicOCSPResp basicResponse = (BasicOCSPResp)response.getResponseObject();
                responses = basicResponse == null ? null : basicResponse.getResponses();
            }
            catch (CertificateVerificationException | OCSPException e) {
                LOG.debug("OCSP response failed for url{}. Hence trying the next url", (Object)serviceUrl);
                continue;
            }
            if (responses == null || responses.length != 1) continue;
            SingleResp singleResponse = responses[0];
            CertificateStatus certificateStatus = singleResponse.getCertStatus();
            if (certificateStatus != null) {
                throw new IllegalStateException("certificate-status=" + String.valueOf(certificateStatus));
            }
            if (!userCertificate.getSerialNumber().equals(singleResponse.getCertID().getSerialNumber())) {
                throw new IllegalStateException("Bad Serials=" + String.valueOf(userCertificate.getSerialNumber()) + " vs. " + String.valueOf(singleResponse.getCertID().getSerialNumber()));
            }
            ocspCache.setCacheValue(response, userCertificate.getSerialNumber(), singleResponse, request, serviceUrl);
            return response;
        }
        throw new CertificateVerificationException("Could not get revocation status from OCSP.");
    }

    public static List<X509Certificate> getCertInfo(SSLConfig sslConfig) throws CertificateException, IOException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
        try (FileInputStream certInputStream = new FileInputStream(sslConfig.getServerCertificates());){
            while (certInputStream.available() > 1) {
                Certificate cert = certificateFactory.generateCertificate(certInputStream);
                certList.add((X509Certificate)cert);
            }
            List<X509Certificate> list = certList;
            return list;
        }
    }
}

