/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender.states;

import io.ballerina.stdlib.http.transport.contract.HttpResponseFuture;
import io.ballerina.stdlib.http.transport.contract.exceptions.EndpointTimeOutException;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.SenderReqRespStateManager;
import io.ballerina.stdlib.http.transport.contractimpl.sender.TargetHandler;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.ReceivingHeaders;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.SenderState;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCompleted
implements SenderState {
    private static final Logger LOG = LoggerFactory.getLogger(RequestCompleted.class);
    private final SenderReqRespStateManager senderReqRespStateManager;

    RequestCompleted(SenderReqRespStateManager senderReqRespStateManager) {
        this.senderReqRespStateManager = senderReqRespStateManager;
    }

    @Override
    public void writeOutboundRequestHeaders(HttpCarbonMessage httpOutboundRequest) {
        LOG.warn("writeOutboundRequestHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void writeOutboundRequestEntity(HttpCarbonMessage httpOutboundRequest, HttpContent httpContent) {
        LOG.warn("writeOutboundRequestEntity {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void readInboundResponseHeaders(TargetHandler targetHandler, HttpResponse httpInboundResponse) {
        if (httpInboundResponse.status().code() != HttpResponseStatus.CONTINUE.code()) {
            this.senderReqRespStateManager.state = new ReceivingHeaders(this.senderReqRespStateManager);
            this.senderReqRespStateManager.readInboundResponseHeaders(targetHandler, httpInboundResponse);
        }
    }

    @Override
    public void readInboundResponseEntityBody(ChannelHandlerContext ctx, HttpContent httpContent, HttpCarbonMessage inboundResponseMsg) {
        LOG.warn("readInboundResponseEntityBody {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void handleAbruptChannelClosure(TargetHandler targetHandler, HttpResponseFuture httpResponseFuture) {
        String message = "Remote host closed the connection before initiating inbound response";
        if (targetHandler.getCause() != null) {
            message = targetHandler.getCause().getMessage();
        }
        httpResponseFuture.notifyHttpListener(new ServerConnectorException(message));
        LOG.error(message);
    }

    @Override
    public void handleIdleTimeoutConnectionClosure(TargetHandler targetHandler, HttpResponseFuture httpResponseFuture, String channelID) {
        this.senderReqRespStateManager.nettyTargetChannel.pipeline().remove("idleStateHandler");
        this.senderReqRespStateManager.nettyTargetChannel.close();
        httpResponseFuture.notifyHttpListener(new EndpointTimeOutException(channelID, "Idle timeout triggered before initiating inbound response", HttpResponseStatus.GATEWAY_TIMEOUT.code()));
        LOG.error("Error in HTTP client: {}", (Object)"Idle timeout triggered before initiating inbound response");
    }
}

