/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender.websocket;

import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnectorException;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnectorFuture;
import io.ballerina.stdlib.http.transport.contractimpl.listener.WebSocketMessageQueueHandler;
import io.ballerina.stdlib.http.transport.contractimpl.websocket.DefaultClientHandshakeFuture;
import io.ballerina.stdlib.http.transport.contractimpl.websocket.DefaultWebSocketConnection;
import io.ballerina.stdlib.http.transport.contractimpl.websocket.WebSocketInboundFrameHandler;
import io.ballerina.stdlib.http.transport.message.DefaultListener;
import io.ballerina.stdlib.http.transport.message.HttpCarbonResponse;
import io.ballerina.stdlib.http.transport.message.Listener;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClientHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketClientHandshakeHandler.class);
    private final WebSocketClientHandshaker handshaker;
    private final WebSocketMessageQueueHandler webSocketMessageQueueHandler;
    private final boolean secure;
    private final boolean autoRead;
    private final String requestedUri;
    private final DefaultClientHandshakeFuture handshakeFuture;
    private final WebSocketConnectorFuture connectorFuture;
    private HttpCarbonResponse httpCarbonResponse;

    public WebSocketClientHandshakeHandler(WebSocketClientHandshaker handshaker, DefaultClientHandshakeFuture handshakeFuture, WebSocketMessageQueueHandler webSocketMessageQueueHandler, boolean secure, boolean autoRead, String requestedUri, WebSocketConnectorFuture connectorFuture) {
        this.handshaker = handshaker;
        this.webSocketMessageQueueHandler = webSocketMessageQueueHandler;
        this.secure = secure;
        this.autoRead = autoRead;
        this.requestedUri = requestedUri;
        this.connectorFuture = connectorFuture;
        this.handshakeFuture = handshakeFuture;
    }

    public HttpCarbonResponse getHttpCarbonResponse() {
        return this.httpCarbonResponse;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent) {
            this.handshakeFuture.notifyError(new WebSocketConnectorException("Handshake timed out"), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (!(msg instanceof FullHttpResponse)) {
            throw new IllegalArgumentException("HTTP response is expected");
        }
        FullHttpResponse handshakeResponse = (FullHttpResponse)msg;
        this.httpCarbonResponse = this.setUpCarbonMessage(ctx, (HttpResponse)handshakeResponse);
        try {
            ctx.channel().config().setAutoRead(false);
            this.handshaker.finishHandshake(ctx.channel(), handshakeResponse);
            Channel channel = ctx.channel();
            String extensionsHeader = handshakeResponse.headers().getAsString((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
            if (extensionsHeader == null) {
                channel.pipeline().replace(WebSocketFrameDecoder.class, "ws-decoder", (ChannelHandler)new WebSocket13FrameDecoder(false, false, this.handshaker.maxFramePayloadLength(), false));
            }
            WebSocketInboundFrameHandler inboundFrameHandler = new WebSocketInboundFrameHandler(false, this.secure, this.requestedUri, this.handshaker.actualSubprotocol(), this.connectorFuture, this.webSocketMessageQueueHandler);
            channel.pipeline().addLast("WEBSOCKET_FRAME_HANDLER", (ChannelHandler)inboundFrameHandler);
            channel.pipeline().remove((ChannelHandler)this);
            DefaultWebSocketConnection webSocketConnection = inboundFrameHandler.getWebSocketConnection();
            if (this.autoRead) {
                webSocketConnection.startReadingFrames();
            } else {
                webSocketConnection.stopReadingFrames();
            }
            this.handshakeFuture.notifySuccess(webSocketConnection, this.httpCarbonResponse);
            ctx.fireChannelActive();
            LOG.debug("WebSocket Client connected");
        }
        finally {
            handshakeResponse.release();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error("Caught exception", cause);
        this.handshakeFuture.notifyError(cause, this.httpCarbonResponse);
    }

    private HttpCarbonResponse setUpCarbonMessage(ChannelHandlerContext ctx, HttpResponse msg) {
        HttpCarbonResponse carbonResponse = new HttpCarbonResponse(msg, (Listener)new DefaultListener(ctx));
        carbonResponse.setProperty("DIRECTION", "DIRECTION_RESPONSE");
        carbonResponse.setHttpStatusCode(msg.status().code());
        return carbonResponse;
    }
}

