/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.uri.parser;

import io.ballerina.stdlib.http.api.HttpResourceArguments;
import io.ballerina.stdlib.http.uri.URITemplateException;
import io.ballerina.stdlib.http.uri.parser.DataElement;
import io.ballerina.stdlib.http.uri.parser.Node;
import java.util.Map;

public class Literal<DataType, InboundMsgType>
extends Node<DataType, InboundMsgType> {
    private int tokenLength;

    public Literal(DataElement<DataType, InboundMsgType> dataElement, String token) throws URITemplateException {
        super(dataElement, token);
        this.tokenLength = token.length();
        if (this.tokenLength == 0) {
            throw new URITemplateException("Invalid literal token with zero length");
        }
    }

    @Override
    String expand(Map<String, String> variables) {
        return this.token;
    }

    @Override
    int match(String uriFragment, HttpResourceArguments variables) {
        int tokenIdx;
        int fragLen = uriFragment.length();
        int tokenLen = this.token.length();
        int fragIdx = 0;
        for (tokenIdx = 0; fragIdx < fragLen && tokenIdx < tokenLen; ++tokenIdx) {
            char fragChar = uriFragment.charAt(fragIdx);
            char tokenChar = this.token.charAt(tokenIdx);
            if (tokenChar == '*' && tokenIdx == tokenLen - 1) {
                return fragLen;
            }
            if (fragChar == tokenChar) {
                ++fragIdx;
                continue;
            }
            if (fragChar == '%') {
                if (fragIdx + 2 >= fragLen) {
                    return -1;
                }
                try {
                    int decoded = Integer.parseInt(uriFragment.substring(fragIdx + 1, fragIdx + 3), 16);
                    if ((char)decoded != tokenChar) {
                        return -1;
                    }
                }
                catch (NumberFormatException e) {
                    return -1;
                }
                fragIdx += 3;
                continue;
            }
            return -1;
        }
        if (tokenIdx == tokenLen - 1 && this.token.charAt(tokenIdx) == '*') {
            return fragLen;
        }
        if (uriFragment.equals("/") && this.token.equals("/") && !this.dataElement.hasData()) {
            return 0;
        }
        return tokenIdx == tokenLen ? fragIdx : -1;
    }

    @Override
    String getToken() {
        return this.token;
    }

    @Override
    char getFirstCharacter() {
        return this.token.charAt(0);
    }
}

