/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist;

import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.Set;

public class PersistToolsConstants {
    public static final String BAL_PERSIST_ADD_CMD = "add";
    public static final String COMPONENT_IDENTIFIER = "persist";
    public static final String EMPTY_VALUE = "";
    public static final String KEYWORD_PACKAGE = "package";
    public static final String KEYWORD_NAME = "name";
    public static final String KEYWORD_SHEET_ID = "spreadsheetId";
    public static final String KEYWORD_CLIENT_ID = "clientId";
    public static final String KEYWORD_CLIENT_SECRET = "clientSecret";
    public static final String KEYWORD_REFRESH_TOKEN = "refreshToken";
    public static final String CONFIG_SCRIPT_FILE = "Config.toml";
    public static final String PASSWORD = "password";
    public static final String USER = "user";
    public static final String MYSQL_DRIVER_CLASS = "com.mysql.cj.jdbc.Driver";
    public static final String MSSQL_DRIVER_CLASS = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String POSTGRESQL_DRIVER_CLASS = "org.postgresql.Driver";
    public static final String PERSIST_CONFIG_PATTERN = "persist.model.storage";
    public static final String SQL_SCHEMA_FILE = "script.sql";
    public static final String GOOGLE_SHEETS_SCHEMA_FILE = "script.gs";
    public static final String PERSIST_DIRECTORY = "persist";
    public static final String TARGET_DIRECTORY = "target";
    public static final String GENERATE_CMD_FILE = "Persist.toml";
    public static final String PERSIST_TOOL_CONFIG = "tool.persist";
    public static final String GENERATED_DIRECTORY = "generated";
    public static final String TARGET_MODULE = "targetModule";
    public static final String OPTION_DATASTORE = "options.datastore";
    public static final String OPTION_TEST_DATASTORE = "options.testDatastore";
    public static final String MIGRATIONS = "migrations";
    public static final String BALLERINA_MYSQL_DRIVER_NAME = "ballerinax/mysql.driver";
    public static final String BALLERINA_MSSQL_DRIVER_NAME = "ballerinax/mssql.driver";
    public static final String BALLERINA_POSTGRESQL_DRIVER_NAME = "ballerinax/postgresql.driver";
    public static final String PROPERTY_KEY_PATH = "path";
    public static final String MYSQL_CONNECTOR_NAME_PREFIX = "mysql-connector";
    public static final String MSSQL_CONNECTOR_NAME_PREFIX = "mssql-jdbc";
    public static final String POSTGRESQL_CONNECTOR_NAME_PREFIX = "postgresql";
    public static final String SCHEMA_FILE_NAME = "model";
    public static final String CACHE_FILE = "persist-cache.txt";
    public static final String UNSUPPORTED_TYPE = "Unsupported";
    public static final String UNSUPPORTED_TYPE_COMMENT_START = "//Unsupported[";
    public static final Set<String> SUPPORTED_DB_PROVIDERS = Set.of("mysql", "mssql", "inmemory", "googlesheets", "postgresql", "redis", "h2");
    public static final Set<String> SUPPORTED_TEST_DB_PROVIDERS = Set.of("inmemory", "h2");
    public static final Set<String> SUPPORTED_NOSQL_DB_PROVIDERS = Set.of("inmemory", "googlesheets", "redis");
    public static final Set<String> SUPPORTED_SQL_DB_PROVIDERS = Set.of("mysql", "mssql", "postgresql", "h2");
    public static final Set<String> SUPPORTED_VIA_JDBC_CONNECTOR = Set.of("h2");
    public static final Set<String> CUSTOM_SCHEMA_SUPPORTED_DB_PROVIDERS = Set.of("mssql", "postgresql");
    public static final String JDBC_CONNECTOR_MODULE_NAME = "java.jdbc";

    private PersistToolsConstants() {
    }

    public static final class SupportedDataSources {
        public static final String MYSQL_DB = "mysql";
        public static final String MSSQL_DB = "mssql";
        public static final String MSSQL_DB_ALT = "sqlserver";
        public static final String GOOGLE_SHEETS = "googlesheets";
        public static final String IN_MEMORY_TABLE = "inmemory";
        public static final String POSTGRESQL_DB = "postgresql";
        public static final String REDIS = "redis";
        public static final String H2_DB = "h2";
        public static final String JDBC = "jdbc";

        private SupportedDataSources() {
        }
    }

    public static enum DiagnosticMessages {
        INVALID_MODULE_NAME("PERSIST_CLIENT_01", "invalid module name : `%s`" + System.lineSeparator() + "module name should follow the template \"<package_name>.<module_name>\"", DiagnosticSeverity.ERROR),
        ERROR_WHILE_GENERATING_CLIENT("PERSIST_CLIENT_02", "unexpected error occurred while generating the client" + System.lineSeparator() + "%s", DiagnosticSeverity.ERROR);

        private final String code;
        private final String description;
        private final DiagnosticSeverity severity;

        private DiagnosticMessages(String code, String description, DiagnosticSeverity severity) {
            this.code = code;
            this.description = description;
            this.severity = severity;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public DiagnosticSeverity getSeverity() {
            return this.severity;
        }
    }

    public static final class DBConfigs {
        public static final String KEY_USER = "user";
        public static final String KEY_PORT = "port";
        public static final String KEY_URL = "url";
        public static final String KEY_PASSWORD = "password";
        public static final String KEY_DATABASE = "database";
        public static final String KEY_DEFAULT_SCHEMA = "defaultSchema";
        public static final String KEY_HOST = "host";
        public static final String KEY_CONNECTION = "connection";
        public static final String KEY_MAX_AGE = "maxAge";

        private DBConfigs() {
        }

        public static final class REDIS {
            public static final String CONNECTION_URI = "redis://localhost:6379";
            public static final String MAX_AGE = "-1";

            private REDIS() {
            }
        }

        public static final class POSTGRESQL {
            public static final String DEFAULT_HOST = "localhost";
            public static final String DEFAULT_PORT = "5432";
            public static final String DEFAULT_USER = "postgres";

            private POSTGRESQL() {
            }
        }

        public static final class MSSQL {
            public static final String DEFAULT_HOST = "localhost";
            public static final String DEFAULT_PORT = "1433";
            public static final String DEFAULT_USER = "sa";

            private MSSQL() {
            }
        }

        public static final class MySQL {
            public static final String DEFAULT_HOST = "localhost";
            public static final String DEFAULT_PORT = "3306";
            public static final String DEFAULT_USER = "root";

            private MySQL() {
            }
        }
    }

    public static final class TomlFileConstants {
        public static final String VERSION_PROPERTIES_FILE = "version.properties";
        public static final String KEYWORD_GROUP_ID = "groupId";
        public static final String PERSIST_GROUP_ID = "io.ballerina.stdlib";
        public static final String PERSIST_LIB_GROUP_ID = "io.ballerina.lib";
        public static final String KEYWORD_ARTIFACT_ID = "artifactId";
        public static final String ARTIFACT_ID = "%s-native";
        public static final String PERSIST_SQL_VERSION = "persistSqlVersion";
        public static final String PERSIST_IN_MEMORY_VERSION = "persistInMemoryVersion";
        public static final String PERSIST_GOOGLE_SHEETS_VERSION = "persistGoogleSheetsVersion";
        public static final String PERSIST_REDIS_VERSION = "persistRedisVersion";
        public static final String KEYWORD_VERSION = "version";

        private TomlFileConstants() {
        }
    }

    public static final class DefaultMaxLength {
        public static final int VARCHAR_LENGTH = 191;
        public static final int DECIMAL_PRECISION = 65;
        public static final int DECIMAL_PRECISION_MSSQL = 38;
        public static final int DECIMAL_PRECISION_POSTGRESQL = 65;
        public static final int DECIMAL_SCALE = 30;

        private DefaultMaxLength() {
        }
    }

    public static final class AppScriptComments {
        public static final String AUTOGENERATED_FILE_COMMENT = "// AUTO-GENERATED FILE.";
        public static final String AUTO_GENERATED_COMMENT_WITH_REASON = "// This file is an auto-generated file by Ballerina persistence layer for %s.";
        public static final String COMMENT_SHOULD_BE_VERIFIED_AND_EXECUTED = "// Please verify the generated scripts and execute them against the target DB server.";

        private AppScriptComments() {
        }
    }

    public static final class SqlScriptComments {
        public static final String AUTOGENERATED_FILE_COMMENT = "-- AUTO-GENERATED FILE.";
        public static final String AUTO_GENERATED_COMMENT_WITH_REASON = "-- This file is an auto-generated file by Ballerina persistence layer for %s.";
        public static final String COMMENT_SHOULD_BE_VERIFIED_AND_EXECUTED = "-- Please verify the generated scripts and execute them against the target DB server.";

        private SqlScriptComments() {
        }
    }

    public static final class SqlTypes {
        public static final String INT = "INT";
        public static final String INT4 = "INT4";
        public static final String INT2 = "INT2";
        public static final String INT8 = "INT8";
        public static final String BIGINT = "BIGINT";
        public static final String TINYINT = "TINYINT";
        public static final String SMALLINT = "SMALLINT";
        public static final String MEDIUMINT = "MEDIUMINT";
        public static final String INTEGER = "INTEGER";
        public static final String BIT = "BIT";
        public static final String BOOLEAN = "BOOLEAN";
        public static final String BOOL = "BOOL";
        public static final String DECIMAL = "DECIMAL";
        public static final String NUMERIC = "NUMERIC";
        public static final String DOUBLE = "DOUBLE";
        public static final String FLOAT = "FLOAT";
        public static final String FLOAT4 = "FLOAT4";
        public static final String FLOAT8 = "FLOAT8";
        public static final String VARCHAR = "VARCHAR";
        public static final String CHAR = "CHAR";
        public static final String CHARACTER = "CHARACTER";
        public static final String BPCHAR = "BPCHAR";
        public static final String TINYTEXT = "TINYTEXT";
        public static final String TEXT = "TEXT";
        public static final String MEDIUMTEXT = "MEDIUMTEXT";
        public static final String LONGTEXT = "LONGTEXT";
        public static final String DATE = "DATE";
        public static final String TIME = "TIME";
        public static final String TIMETZ = "TIMETZ";
        public static final String TIME_STAMP = "TIMESTAMP";
        public static final String TIME_STAMPTZ = "TIMESTAMPTZ";
        public static final String DATE_TIME = "DATETIME";
        public static final String DATE_TIME2 = "DATETIME2";
        public static final String LONG_BLOB = "LONGBLOB";
        public static final String MEDIUM_BLOB = "MEDIUMBLOB";
        public static final String TINY_BLOB = "TINYBLOB";
        public static final String BLOB = "BLOB";
        public static final String VARBINARY_WITH_MAX = "VARBINARY(MAX)";
        public static final String BINARY = "BINARY";
        public static final String VARBINARY = "VARBINARY";
        public static final String BYTEA = "BYTEA";
        public static final String BOOLEAN_ALT = "tinyint(1)";
        public static final String SERIAL = "SERIAL";
        public static final String BIGSERIAL = "BIGSERIAL";

        private SqlTypes() {
        }
    }

    public static final class BallerinaTypes {
        public static final String INT = "int";
        public static final String STRING = "string";
        public static final String BOOLEAN = "boolean";
        public static final String DECIMAL = "decimal";
        public static final String FLOAT = "float";
        public static final String DATE = "time:Date";
        public static final String TIME_OF_DAY = "time:TimeOfDay";
        public static final String UTC = "time:Utc";
        public static final String CIVIL = "time:Civil";
        public static final String BYTE = "byte";

        private BallerinaTypes() {
        }
    }
}

